/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.reactor;

import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.impl.nio.DefaultServerIOEventDispatch;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorStatus;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.limewire.http.reactor.DispatchedIOReactor;
import org.limewire.http.reactor.HttpChannel;
import org.limewire.http.reactor.HttpIOSession;
import org.limewire.io.IOUtils;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.nio.channel.ThrottleWriter;

public class DefaultDispatchedIOReactor
implements DispatchedIOReactor {
    public static final String IO_SESSION_KEY = "org.limewire.iosession";
    private static final Log LOG = LogFactory.getLog(DefaultDispatchedIOReactor.class);
    private final HttpParams params;
    protected volatile IOEventDispatch eventDispatch = null;
    private final Executor ioExecutor;
    private static final String NHTTP_CONN = "NHTTP_CONN";

    public DefaultDispatchedIOReactor(HttpParams httpParams, Executor executor) {
        if (httpParams == null) {
            throw new IllegalArgumentException();
        }
        this.params = httpParams;
        this.ioExecutor = executor;
    }

    public void execute(IOEventDispatch iOEventDispatch) throws IOException {
        if (!(iOEventDispatch instanceof DefaultServerIOEventDispatch)) {
            throw new IllegalArgumentException("Event dispatch must be of type DefaultServerIOEventDispatch");
        }
        this.eventDispatch = iOEventDispatch;
    }

    protected void prepareSocket(Socket socket) throws IOException {
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay((HttpParams)this.params));
        int n = HttpConnectionParams.getLinger((HttpParams)this.params);
        if (n >= 0) {
            socket.setSoLinger(n > 0, n);
        }
    }

    protected NHttpConnection connectSocket(AbstractNBSocket abstractNBSocket, Object object, String string) {
        HttpIOSession httpIOSession = new HttpIOSession(abstractNBSocket, this.ioExecutor);
        httpIOSession.setAttribute("http.session.attachment", object);
        httpIOSession.setSocketTimeout(HttpConnectionParams.getSoTimeout((HttpParams)this.params));
        HttpChannel httpChannel = new HttpChannel(httpIOSession, this.eventDispatch, string);
        httpIOSession.setHttpChannel(httpChannel);
        ThrottleWriter throttleWriter = new ThrottleWriter(null);
        httpIOSession.setThrottleChannel(throttleWriter);
        httpChannel.setWriteChannel(throttleWriter);
        this.eventDispatch.connected((IOSession)httpIOSession);
        NHttpConnection nHttpConnection = (NHttpConnection)httpIOSession.getAttribute(NHTTP_CONN);
        assert (nHttpConnection != null);
        nHttpConnection.getContext().setAttribute(IO_SESSION_KEY, (Object)httpIOSession);
        abstractNBSocket.setReadObserver(httpChannel);
        abstractNBSocket.setWriteObserver(httpChannel);
        return nHttpConnection;
    }

    public NHttpConnection acceptConnection(String string, Socket socket) {
        try {
            this.prepareSocket(socket);
            return this.connectSocket((AbstractNBSocket)socket, null, string);
        }
        catch (IOException iOException) {
            LOG.info((Object)"Closing socket due to unexpected exception", (Throwable)iOException);
            IOUtils.close(socket);
            return null;
        }
    }

    public IOReactorStatus getStatus() {
        throw new UnsupportedOperationException();
    }

    public void shutdown() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void shutdown(long l) throws IOException {
        throw new UnsupportedOperationException();
    }
}

