/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.protocol;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.protocol.AsyncNHttpServiceHandler;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.limewire.http.protocol.HttpServiceEventListener;
import org.limewire.http.reactor.HttpIOSession;

public class ExtendedAsyncNHttpServiceHandler
extends AsyncNHttpServiceHandler {
    public ExtendedAsyncNHttpServiceHandler(HttpProcessor httpProcessor, HttpResponseFactory httpResponseFactory, ConnectionReuseStrategy connectionReuseStrategy, ByteBufferAllocator byteBufferAllocator, HttpParams httpParams) {
        super(httpProcessor, httpResponseFactory, connectionReuseStrategy, byteBufferAllocator, httpParams);
    }

    public ExtendedAsyncNHttpServiceHandler(HttpProcessor httpProcessor, HttpResponseFactory httpResponseFactory, ConnectionReuseStrategy connectionReuseStrategy, HttpParams httpParams) {
        this(httpProcessor, httpResponseFactory, connectionReuseStrategy, (ByteBufferAllocator)new HeapByteBufferAllocator(), httpParams);
    }

    public void setEventListener(HttpServiceEventListener httpServiceEventListener) {
        this.eventListener = httpServiceEventListener;
    }

    protected void responseComplete(HttpResponse httpResponse, HttpContext httpContext) {
        DefaultNHttpServerConnection defaultNHttpServerConnection;
        NHttpServerConnection nHttpServerConnection = (NHttpServerConnection)httpContext.getAttribute("http.connection");
        if (this.eventListener instanceof HttpServiceEventListener) {
            ((HttpServiceEventListener)this.eventListener).responseSent((NHttpConnection)nHttpServerConnection, httpResponse);
        }
        if (nHttpServerConnection.isOpen() && (defaultNHttpServerConnection = (DefaultNHttpServerConnection)nHttpServerConnection).hasBufferedInput()) {
            HttpIOSession httpIOSession = (HttpIOSession)defaultNHttpServerConnection.getContext().getAttribute("org.limewire.iosession");
            Executor executor = httpIOSession.getIoExecutor();
            Runnable runnable = new Runnable(){

                public void run() {
                    defaultNHttpServerConnection.consumeInput((NHttpServiceHandler)ExtendedAsyncNHttpServiceHandler.this);
                }
            };
            if (executor instanceof ScheduledExecutorService) {
                ((ScheduledExecutorService)executor).schedule(runnable, 0L, TimeUnit.MILLISECONDS);
            } else {
                executor.execute(runnable);
            }
        }
    }

    protected void closeConnection(NHttpConnection nHttpConnection, Throwable throwable) {
        AsyncNHttpServiceHandler.ServerConnState serverConnState = (AsyncNHttpServiceHandler.ServerConnState)nHttpConnection.getContext().getAttribute("http.nio.conn-state");
        try {
            serverConnState.finishOutput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.closeConnection(nHttpConnection, throwable);
    }

    protected void shutdownConnection(NHttpConnection nHttpConnection, Throwable throwable) {
        AsyncNHttpServiceHandler.ServerConnState serverConnState = (AsyncNHttpServiceHandler.ServerConnState)nHttpConnection.getContext().getAttribute("http.nio.conn-state");
        try {
            serverConnState.finishOutput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.shutdownConnection(nHttpConnection, throwable);
    }
}

