/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.httpclient;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.limewire.concurrent.AbstractLazySingletonProvider;
import org.limewire.http.httpclient.LimeHttpClient;
import org.limewire.http.httpclient.LimeHttpClientImpl;
import org.limewire.http.httpclient.ReapingClientConnectionManager;
import org.limewire.http.httpclient.SocketWrapperProtocolSocketFactory;
import org.limewire.http.httpclient.SocketWrappingHttpClient;
import org.limewire.net.SocketsManager;
import org.limewire.nio.NBSocket;

public class LimeWireHttpClientModule
extends AbstractModule {
    protected void configure() {
        this.bind(ReapingClientConnectionManager.class).annotatedWith((Annotation)Names.named((String)"nonBlockingConnectionManager")).toProvider(LimeClientConnectionManagerProvider.class).in(Scopes.SINGLETON);
        this.bind(ReapingClientConnectionManager.class).annotatedWith((Annotation)Names.named((String)"socketWrappingConnectionManager")).toProvider(SocketWrappingClientConnectionManagerProvider.class).in(Scopes.SINGLETON);
        this.bind(LimeHttpClient.class).toProvider(NonBlockingLimeHttpClientProvider.class);
        this.bind(SocketWrappingHttpClient.class).toProvider(SocketWrappingLimeHttpClientProvider.class);
        this.bind(SchemeRegistry.class).annotatedWith((Annotation)Names.named((String)"limeSchemeRegistry")).toProvider(LimeSchemeRegistryProvider.class);
        this.bind(SchemeRegistry.class).annotatedWith((Annotation)Names.named((String)"socketWrappingSchemeRegistry")).toProvider(SocketWrappingSchemeRegistryProvider.class);
        this.bind(SocketWrapperProtocolSocketFactory.class);
        this.bind(HttpParams.class).annotatedWith((Annotation)Names.named((String)"defaults")).toProvider(DefaultHttpParamsProvider.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Singleton
    private static class DefaultHttpParamsProvider
    implements Provider<HttpParams> {
        private static final int CONNECTION_TIMEOUT = 5000;
        private static final int TIMEOUT = 8000;
        private static final int MAXIMUM_REDIRECTS = 10;

        @Inject
        private DefaultHttpParamsProvider() {
        }

        public HttpParams get() {
            BasicHttpParams basicHttpParams = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)5000);
            HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)8000);
            HttpClientParams.setRedirecting((HttpParams)basicHttpParams, (boolean)true);
            basicHttpParams.setIntParameter("http.protocol.max-redirects", 10);
            return basicHttpParams;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LimeSocketFactory
    implements SocketFactory {
        final Provider<SocketsManager> socketsManager;
        final SocketsManager.ConnectType type;

        public LimeSocketFactory(Provider<SocketsManager> provider, SocketsManager.ConnectType connectType) {
            this.socketsManager = provider;
            this.type = connectType;
        }

        public Socket createSocket() throws IOException {
            return ((SocketsManager)this.socketsManager.get()).create(this.type);
        }

        public Socket connectSocket(Socket socket, String string, int n, InetAddress inetAddress, int n2, HttpParams httpParams) throws IOException, UnknownHostException, ConnectTimeoutException {
            if (socket == null) {
                socket = this.createSocket();
            }
            InetSocketAddress inetSocketAddress = null;
            if (inetAddress != null && !inetAddress.isAnyLocalAddress() || n2 > 0) {
                inetSocketAddress = new InetSocketAddress(inetAddress, n2);
            }
            return ((SocketsManager)this.socketsManager.get()).connect((NBSocket)socket, inetSocketAddress, new InetSocketAddress(string, n), HttpConnectionParams.getConnectionTimeout((HttpParams)httpParams), this.type);
        }

        public boolean isSecure(Socket socket) throws IllegalArgumentException {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Singleton
    private static class SocketWrappingClientConnectionManagerProvider
    extends AbstractClientConnectionManagerProvider {
        @Inject
        public SocketWrappingClientConnectionManagerProvider(@Named(value="socketWrappingSchemeRegistry") Provider<SchemeRegistry> provider, @Named(value="backgroundExecutor") Provider<ScheduledExecutorService> provider2, @Named(value="defaults") Provider<HttpParams> provider3) {
            super(provider, provider2, provider3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Singleton
    private static class LimeClientConnectionManagerProvider
    extends AbstractClientConnectionManagerProvider {
        @Inject
        public LimeClientConnectionManagerProvider(@Named(value="limeSchemeRegistry") Provider<SchemeRegistry> provider, @Named(value="backgroundExecutor") Provider<ScheduledExecutorService> provider2, @Named(value="defaults") Provider<HttpParams> provider3) {
            super(provider, provider2, provider3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractClientConnectionManagerProvider
    extends AbstractLazySingletonProvider<ReapingClientConnectionManager> {
        private final Provider<SchemeRegistry> registry;
        private final Provider<ScheduledExecutorService> scheduler;
        private final Provider<HttpParams> defaultParams;

        public AbstractClientConnectionManagerProvider(Provider<SchemeRegistry> provider, Provider<ScheduledExecutorService> provider2, Provider<HttpParams> provider3) {
            this.registry = provider;
            this.scheduler = provider2;
            this.defaultParams = provider3;
        }

        @Override
        public ReapingClientConnectionManager createObject() {
            return new ReapingClientConnectionManager(this.registry, this.scheduler, this.defaultParams);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Singleton
    private static class SocketWrappingSchemeRegistryProvider
    extends AbstractLazySingletonProvider<SchemeRegistry> {
        private SocketWrappingSchemeRegistryProvider() {
        }

        @Override
        protected SchemeRegistry createObject() {
            SchemeRegistry schemeRegistry = new SchemeRegistry();
            schemeRegistry.register(new Scheme("http", (SocketFactory)new SocketWrapperProtocolSocketFactory(), 80));
            schemeRegistry.register(new Scheme("tls", (SocketFactory)new SocketWrapperProtocolSocketFactory(), 80));
            schemeRegistry.register(new Scheme("https", (SocketFactory)new SocketWrapperProtocolSocketFactory(), 80));
            return schemeRegistry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Singleton
    private static class LimeSchemeRegistryProvider
    extends AbstractLazySingletonProvider<SchemeRegistry> {
        private final Provider<SocketsManager> socketsManager;

        @Inject
        public LimeSchemeRegistryProvider(Provider<SocketsManager> provider) {
            this.socketsManager = provider;
        }

        @Override
        protected SchemeRegistry createObject() {
            SchemeRegistry schemeRegistry = new SchemeRegistry();
            schemeRegistry.register(new Scheme("http", (SocketFactory)new LimeSocketFactory(this.socketsManager, SocketsManager.ConnectType.PLAIN), 80));
            schemeRegistry.register(new Scheme("tls", (SocketFactory)new LimeSocketFactory(this.socketsManager, SocketsManager.ConnectType.TLS), 80));
            schemeRegistry.register(new Scheme("https", (SocketFactory)new LimeSocketFactory(this.socketsManager, SocketsManager.ConnectType.TLS), 80));
            return schemeRegistry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Singleton
    private static class SocketWrappingLimeHttpClientProvider
    extends AbstractLimeHttpClientProvider {
        @Inject
        public SocketWrappingLimeHttpClientProvider(@Named(value="socketWrappingConnectionManager") ReapingClientConnectionManager reapingClientConnectionManager, @Named(value="defaults") Provider<HttpParams> provider) {
            super(reapingClientConnectionManager, provider);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Singleton
    private static class NonBlockingLimeHttpClientProvider
    extends AbstractLimeHttpClientProvider {
        @Inject
        public NonBlockingLimeHttpClientProvider(@Named(value="nonBlockingConnectionManager") ReapingClientConnectionManager reapingClientConnectionManager, @Named(value="defaults") Provider<HttpParams> provider) {
            super(reapingClientConnectionManager, provider);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractLimeHttpClientProvider
    implements Provider<SocketWrappingHttpClient> {
        private ReapingClientConnectionManager manager;
        private final Provider<HttpParams> defaultParams;

        public AbstractLimeHttpClientProvider(ReapingClientConnectionManager reapingClientConnectionManager, Provider<HttpParams> provider) {
            this.manager = reapingClientConnectionManager;
            this.defaultParams = provider;
        }

        public SocketWrappingHttpClient get() {
            return new LimeHttpClientImpl(this.manager, this.defaultParams);
        }
    }
}

