/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.httpclient;

import com.google.inject.Provider;
import java.io.IOException;
import java.net.Socket;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.limewire.http.httpclient.HttpClientUtils;
import org.limewire.http.httpclient.ReapingClientConnectionManager;
import org.limewire.http.httpclient.SocketWrappingHttpClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LimeHttpClientImpl
extends DefaultHttpClient
implements SocketWrappingHttpClient {
    @Override
    public void setSocket(Socket socket) {
        ((ReapingClientConnectionManager)this.getConnectionManager()).setSocket(socket);
    }

    @Override
    public void releaseConnection(HttpResponse httpResponse) {
        this.close(httpResponse);
    }

    public LimeHttpClientImpl(ReapingClientConnectionManager reapingClientConnectionManager, Provider<HttpParams> provider) {
        super((ClientConnectionManager)reapingClientConnectionManager, (HttpParams)provider.get());
    }

    protected HttpRequestRetryHandler createHttpRequestRetryHandler() {
        return new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException iOException, int n, HttpContext httpContext) {
                return false;
            }
        };
    }

    private void close(HttpResponse httpResponse) {
        HttpClientUtils.releaseConnection(httpResponse);
    }
}

