/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.handler;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.nio.entity.ConsumingNHttpEntity;
import org.apache.http.nio.protocol.SimpleNHttpRequestHandler;
import org.apache.http.protocol.HttpContext;
import org.limewire.http.entity.BasicFileTransferMonitor;
import org.limewire.http.entity.FileNIOEntity;
import org.limewire.http.entity.NotFoundEntity;
import org.limewire.http.handler.MimeTypeProvider;

public class FileRequestHandler
extends SimpleNHttpRequestHandler {
    private String indexFilename = "index.html";
    private final File rootDirectory;
    private final MimeTypeProvider mimeTypeProvider;
    private int timeout = -1;

    public FileRequestHandler(File file, MimeTypeProvider mimeTypeProvider) {
        this.rootDirectory = file;
        this.mimeTypeProvider = mimeTypeProvider;
    }

    public void setIndexFilename(String string) {
        this.indexFilename = string;
    }

    public String getIndexFilename() {
        return this.indexFilename;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public ConsumingNHttpEntity entityRequest(HttpEntityEnclosingRequest httpEntityEnclosingRequest, HttpContext httpContext) throws HttpException, IOException {
        return null;
    }

    public void handle(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        File file = this.getFile(httpRequest);
        if (file.exists() && file.isFile()) {
            String string = this.mimeTypeProvider.getMimeType(file);
            FileNIOEntity fileNIOEntity = new FileNIOEntity(file, string, new BasicFileTransferMonitor(httpContext));
            if (this.timeout != -1) {
                fileNIOEntity.setTimeout(this.timeout);
            }
            httpResponse.setEntity((HttpEntity)fileNIOEntity);
        } else {
            httpResponse.setEntity((HttpEntity)new NotFoundEntity(httpRequest));
            httpResponse.setStatusCode(404);
        }
    }

    private File getFile(HttpRequest httpRequest) throws HttpException {
        if (!httpRequest.getRequestLine().getUri().startsWith("/")) {
            throw new ProtocolException("Invalid request");
        }
        File file = this.rootDirectory;
        StringTokenizer stringTokenizer = new StringTokenizer(httpRequest.getRequestLine().getUri(), "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.indexOf(File.pathSeparator) != -1) {
                throw new ProtocolException("Invalid request");
            }
            if (string.indexOf("..") != -1) {
                throw new ProtocolException("Invalid request");
            }
            file = new File(file, string);
        }
        if (file.isDirectory()) {
            file = new File(file, this.indexFilename);
        }
        return file;
    }
}

