/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.entity;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.entity.FileEntity;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.ProducingNHttpEntity;
import org.limewire.http.entity.FilePieceReader;
import org.limewire.http.entity.FileTransferMonitor;
import org.limewire.http.entity.Piece;
import org.limewire.http.entity.PieceListener;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.nio.timeout.StalledUploadWatchdog;

public class FileNIOEntity
extends FileEntity
implements ProducingNHttpEntity {
    private static final Log LOG = LogFactory.getLog(FileNIOEntity.class);
    private final FileTransferMonitor transfer;
    private final File file;
    private ByteBuffer buffer;
    private long length;
    private long begin;
    private long remaining;
    private FilePieceReader reader;
    private Piece piece;
    private IOControl ioctrl;
    private StalledUploadWatchdog watchdog;
    private long timeout = StalledUploadWatchdog.DELAY_TIME;
    private final Shutdownable timeoutable = new Shutdownable(){

        public void shutdown() {
            FileNIOEntity.this.timeout();
        }
    };

    public FileNIOEntity(File file, String string, FileTransferMonitor fileTransferMonitor, long l, long l2) {
        super(file, string);
        this.transfer = fileTransferMonitor;
        this.file = file;
        this.begin = l;
        this.length = l2;
        this.remaining = l2;
        if (l2 < 0L) {
            throw new IllegalStateException("upload end must be >= upload begin");
        }
    }

    public FileNIOEntity(File file, String string, FileTransferMonitor fileTransferMonitor) {
        this(file, string, fileTransferMonitor, 0L, file.length());
    }

    public void setTimeout(long l) {
        this.timeout = l;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public long getContentLength() {
        return this.length;
    }

    public InputStream getContent() throws IOException {
        final FileInputStream fileInputStream = new FileInputStream(this.file);
        return new InputStream(){

            public int read() throws IOException {
                if (FileNIOEntity.this.remaining == 0L) {
                    return -1;
                }
                FileNIOEntity.this.remaining--;
                return fileInputStream.read();
            }
        };
    }

    public boolean isRepeatable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.file));
        try {
            int n;
            byte[] byArray = new byte[4096];
            ((InputStream)bufferedInputStream).skip(this.begin);
            while (this.remaining > 0L && (n = ((InputStream)bufferedInputStream).read(byArray, 0, (int)Math.min(this.remaining, (long)byArray.length))) != -1) {
                outputStream.write(byArray, 0, n);
                this.remaining -= (long)n;
            }
            outputStream.flush();
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    public File getFile() {
        return this.file;
    }

    public void initializeReader() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Initializing upload of " + this.file.getName() + " [begin=" + this.begin + ",length=" + this.length + "]"));
        }
        if (this.length == 0L) {
            return;
        }
        this.transfer.start();
        this.reader = new FilePieceReader(NIODispatcher.instance().getBufferCache(), this.file, this.begin, this.length, new PieceHandler());
        this.reader.start();
    }

    public void initializeWriter() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void finish() {
        this.deactivateTimeout();
        if (this.reader != null) {
            this.reader.shutdown();
            this.reader = null;
        }
        this.ioctrl = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceContent(ContentEncoder contentEncoder, IOControl iOControl) throws IOException {
        int n;
        if (this.ioctrl == null) {
            this.ioctrl = iOControl;
            this.initializeReader();
        }
        if (this.buffer != null && this.buffer.hasRemaining()) {
            n = contentEncoder.write(this.buffer);
            this.transfer.addAmountUploaded(n);
            if (this.buffer.hasRemaining()) {
                this.activateTimeout();
                return;
            }
            if (this.remaining == 0L) {
                this.reader.release(this.piece);
                contentEncoder.complete();
                return;
            }
        } else if (this.remaining == 0L) {
            contentEncoder.complete();
            return;
        }
        do {
            if (this.buffer == null || !this.buffer.hasRemaining()) {
                if (this.piece != null) {
                    this.reader.release(this.piece);
                }
                FileNIOEntity fileNIOEntity = this;
                synchronized (fileNIOEntity) {
                    this.piece = this.reader.next();
                    if (this.piece == null) {
                        this.buffer = null;
                        iOControl.suspendOutput();
                        this.activateTimeout();
                        return;
                    }
                    this.buffer = this.piece.getBuffer();
                    this.remaining -= (long)this.buffer.remaining();
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Uploading " + this.file.getName() + " [read=" + this.buffer.remaining() + ",remaining=" + this.remaining + "]"));
            }
            n = contentEncoder.write(this.buffer);
            this.transfer.addAmountUploaded(n);
        } while (n > 0 && this.remaining > 0L);
        if (this.remaining == 0L && !this.buffer.hasRemaining()) {
            contentEncoder.complete();
        } else {
            this.activateTimeout();
        }
    }

    protected void activateTimeout() {
        if (this.watchdog == null) {
            this.watchdog = new StalledUploadWatchdog(this.timeout, NIODispatcher.instance().getScheduledExecutorService());
        }
        this.watchdog.activate(this.timeoutable);
    }

    protected void deactivateTimeout() {
        if (this.watchdog != null) {
            this.watchdog.deactivate();
        }
    }

    public int consumeContent(ContentDecoder contentDecoder, IOControl iOControl) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + " [file=" + this.file.getName() + "]";
    }

    public void timeout() {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("File transfer timed out: " + this.transfer));
        }
        this.transfer.timeout();
    }

    private class PieceHandler
    implements PieceListener {
        private PieceHandler() {
        }

        public void readFailed(IOException iOException) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Error reading file from disk: " + FileNIOEntity.this.transfer), (Throwable)iOException);
            }
            FileNIOEntity.this.transfer.failed(iOException);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readSuccessful() {
            FileNIOEntity fileNIOEntity = FileNIOEntity.this;
            synchronized (fileNIOEntity) {
                FileNIOEntity.this.ioctrl.requestOutput();
            }
        }
    }
}

