/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http;

import java.io.IOException;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpException;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.nio.DefaultServerIOEventDispatch;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.protocol.NHttpRequestHandler;
import org.apache.http.nio.protocol.NHttpRequestHandlerRegistry;
import org.apache.http.nio.protocol.NHttpRequestHandlerResolver;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.limewire.http.HttpAcceptorListener;
import org.limewire.http.protocol.ExtendedAsyncNHttpServiceHandler;
import org.limewire.http.protocol.HttpServiceEventListener;
import org.limewire.http.protocol.LimeResponseConnControl;
import org.limewire.http.protocol.SynchronizedHttpProcessor;
import org.limewire.http.protocol.SynchronizedNHttpRequestHandlerRegistry;
import org.limewire.http.reactor.DefaultDispatchedIOReactor;
import org.limewire.http.reactor.DispatchedIOReactor;
import org.limewire.net.ConnectionAcceptor;
import org.limewire.nio.NIODispatcher;
import org.limewire.service.ErrorService;

public class BasicHttpAcceptor
implements ConnectionAcceptor {
    private static final Log LOG = LogFactory.getLog(BasicHttpAcceptor.class);
    public static final String[] DEFAULT_METHODS = new String[]{"GET", "HEAD", "POST"};
    private final String[] supportedMethods;
    private final NHttpRequestHandlerRegistry registry;
    private final SynchronizedHttpProcessor processor;
    private final List<HttpAcceptorListener> acceptorListeners = new CopyOnWriteArrayList<HttpAcceptorListener>();
    private final HttpParams params;
    private DispatchedIOReactor reactor;
    private ConnectionEventListener connectionListener;
    private DefaultHttpResponseFactory responseFactory;
    private AtomicBoolean started = new AtomicBoolean();

    public BasicHttpAcceptor(HttpParams httpParams, String ... stringArray) {
        this.params = httpParams;
        this.supportedMethods = stringArray;
        this.registry = new SynchronizedNHttpRequestHandlerRegistry();
        this.processor = new SynchronizedHttpProcessor();
        this.initializeDefaultInterceptor();
    }

    private void initializeDefaultInterceptor() {
        this.addResponseInterceptor((HttpResponseInterceptor)new ResponseDate());
        this.addResponseInterceptor((HttpResponseInterceptor)new ResponseServer());
        this.addResponseInterceptor((HttpResponseInterceptor)new ResponseContent());
        this.addResponseInterceptor((HttpResponseInterceptor)new LimeResponseConnControl());
    }

    public static HttpParams createDefaultParams(String string, int n) {
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        basicHttpParams.setIntParameter("http.socket.timeout", n);
        basicHttpParams.setIntParameter("http.connection.timeout", n);
        basicHttpParams.setIntParameter("http.socket.buffer-size", 8192);
        basicHttpParams.setBooleanParameter("http.tcp.nodelay", true);
        basicHttpParams.setParameter("http.origin-server", (Object)string);
        basicHttpParams.setIntParameter("http.connection.max-line-length", 4096);
        basicHttpParams.setIntParameter("http.connection.max-header-count", 50);
        basicHttpParams.setParameter("http.protocol.element-charset", (Object)"ISO-8859-1");
        return basicHttpParams;
    }

    private void initializeReactor() {
        assert (NIODispatcher.instance().isDispatchThread());
        this.connectionListener = new ConnectionEventListener();
        this.responseFactory = new DefaultHttpResponseFactory();
        ExtendedAsyncNHttpServiceHandler extendedAsyncNHttpServiceHandler = new ExtendedAsyncNHttpServiceHandler(this.processor, (HttpResponseFactory)this.responseFactory, (ConnectionReuseStrategy)new DefaultConnectionReuseStrategy(), this.params);
        extendedAsyncNHttpServiceHandler.setEventListener(this.connectionListener);
        extendedAsyncNHttpServiceHandler.setHandlerResolver((NHttpRequestHandlerResolver)this.registry);
        this.reactor = new DefaultDispatchedIOReactor(this.params, NIODispatcher.instance().getScheduledExecutorService());
        DefaultServerIOEventDispatch defaultServerIOEventDispatch = new DefaultServerIOEventDispatch((NHttpServiceHandler)extendedAsyncNHttpServiceHandler, this.params);
        try {
            this.reactor.execute((IOEventDispatch)defaultServerIOEventDispatch);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unexpected exception", iOException);
        }
    }

    public void acceptConnection(String string, Socket socket) {
        this.reactor.acceptConnection(string + " ", socket);
    }

    public boolean isBlocking() {
        return false;
    }

    public String[] getHttpMethods() {
        return this.supportedMethods;
    }

    public void addAcceptorListener(HttpAcceptorListener httpAcceptorListener) {
        this.acceptorListeners.add(httpAcceptorListener);
    }

    public void addRequestInterceptor(HttpRequestInterceptor httpRequestInterceptor) {
        this.processor.addInterceptor(httpRequestInterceptor);
    }

    public void addResponseInterceptor(HttpResponseInterceptor httpResponseInterceptor) {
        this.processor.addInterceptor(httpResponseInterceptor);
    }

    protected DispatchedIOReactor getReactor() {
        assert (NIODispatcher.instance().isDispatchThread());
        return this.reactor;
    }

    public void removeAcceptorListener(HttpAcceptorListener httpAcceptorListener) {
        this.acceptorListeners.remove(httpAcceptorListener);
    }

    public void removeRequestInterceptor(HttpRequestInterceptor httpRequestInterceptor) {
        this.processor.removeInterceptor(httpRequestInterceptor);
    }

    public void removeResponseInterceptor(HttpResponseInterceptor httpResponseInterceptor) {
        this.processor.removeInterceptor(httpResponseInterceptor);
    }

    public void registerHandler(String string, NHttpRequestHandler nHttpRequestHandler) {
        this.registry.register(string, nHttpRequestHandler);
    }

    public void unregisterHandler(String string) {
        this.registry.unregister(string);
    }

    public void start() {
        if (this.started.getAndSet(true)) {
            throw new IllegalStateException();
        }
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        try {
            Future<?> future = NIODispatcher.instance().getScheduledExecutorService().submit(new Runnable(){

                public void run() {
                    BasicHttpAcceptor.this.initializeReactor();
                    atomicBoolean.set(true);
                }
            });
            future.get();
        }
        catch (InterruptedException interruptedException) {
            if (atomicBoolean.get()) {
                LOG.warn((Object)"Interrupted while waiting for reactor initialization", (Throwable)interruptedException);
            } else {
                ErrorService.error(interruptedException);
            }
        }
        catch (ExecutionException executionException) {
            ErrorService.error(executionException);
        }
    }

    public void stop() {
        if (!this.started.getAndSet(false)) {
            throw new IllegalStateException();
        }
    }

    private class ConnectionEventListener
    implements HttpServiceEventListener {
        private ConnectionEventListener() {
        }

        public void connectionOpen(NHttpConnection nHttpConnection) {
            assert (NIODispatcher.instance().isDispatchThread());
            for (HttpAcceptorListener httpAcceptorListener : BasicHttpAcceptor.this.acceptorListeners) {
                httpAcceptorListener.connectionOpen(nHttpConnection);
            }
        }

        public void connectionClosed(NHttpConnection nHttpConnection) {
            assert (NIODispatcher.instance().isDispatchThread());
            for (HttpAcceptorListener httpAcceptorListener : BasicHttpAcceptor.this.acceptorListeners) {
                httpAcceptorListener.connectionClosed(nHttpConnection);
            }
        }

        public void connectionTimeout(NHttpConnection nHttpConnection) {
            throw new RuntimeException();
        }

        public void fatalIOException(IOException iOException, NHttpConnection nHttpConnection) {
            assert (NIODispatcher.instance().isDispatchThread());
            LOG.debug((Object)"HTTP connection error", (Throwable)iOException);
            for (HttpAcceptorListener httpAcceptorListener : BasicHttpAcceptor.this.acceptorListeners) {
                httpAcceptorListener.connectionClosed(nHttpConnection);
            }
        }

        public void fatalProtocolException(HttpException httpException, NHttpConnection nHttpConnection) {
            assert (NIODispatcher.instance().isDispatchThread());
            LOG.debug((Object)"HTTP protocol error", (Throwable)httpException);
            for (HttpAcceptorListener httpAcceptorListener : BasicHttpAcceptor.this.acceptorListeners) {
                httpAcceptorListener.connectionClosed(nHttpConnection);
            }
        }

        public void responseSent(NHttpConnection nHttpConnection, HttpResponse httpResponse) {
            assert (NIODispatcher.instance().isDispatchThread());
            for (HttpAcceptorListener httpAcceptorListener : BasicHttpAcceptor.this.acceptorListeners) {
                httpAcceptorListener.responseSent(nHttpConnection, httpResponse);
            }
        }
    }
}

