/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.limewire.service.ErrorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTimer
extends AbstractExecutorService
implements ScheduledExecutorService {
    private final Timer TIMER;
    private volatile boolean cancelled = false;

    public SimpleTimer(boolean bl) {
        this.TIMER = new Timer(bl);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable runnable, long l, TimeUnit timeUnit) {
        ScheduledTimerTask scheduledTimerTask = new ScheduledTimerTask(runnable);
        this.scheduleInternal(scheduledTimerTask, timeUnit.toMillis(l), 0L, false);
        return scheduledTimerTask;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long l, TimeUnit timeUnit) {
        ScheduledTimerTask<V> scheduledTimerTask = new ScheduledTimerTask<V>(callable);
        this.scheduleInternal(scheduledTimerTask, timeUnit.toMillis(l), 0L, false);
        return scheduledTimerTask;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        ScheduledTimerTask scheduledTimerTask = new ScheduledTimerTask(runnable);
        this.scheduleInternal(scheduledTimerTask, timeUnit.toMillis(l), timeUnit.toMillis(l2), true);
        return scheduledTimerTask;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        ScheduledTimerTask scheduledTimerTask = new ScheduledTimerTask(runnable);
        this.scheduleInternal(scheduledTimerTask, timeUnit.toMillis(l), timeUnit.toMillis(l2), false);
        return scheduledTimerTask;
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShutdown() {
        return this.cancelled;
    }

    @Override
    public boolean isTerminated() {
        return this.cancelled;
    }

    @Override
    public void shutdown() {
        this.cancelled = true;
        this.TIMER.cancel();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    @Override
    public void execute(final Runnable runnable) {
        TimerTask timerTask = new TimerTask(){

            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    ErrorService.error(throwable);
                }
            }
        };
        this.scheduleInternal(timerTask, 0L, 0L, false);
    }

    private void scheduleInternal(TimerTask timerTask, long l, long l2, boolean bl) {
        block7: {
            try {
                if (l2 == 0L) {
                    if (bl) {
                        throw new IllegalArgumentException("cannot support 0 period w/ fixedRate");
                    }
                    this.TIMER.schedule(timerTask, l);
                } else if (bl) {
                    this.TIMER.scheduleAtFixedRate(timerTask, l, l2);
                } else {
                    this.TIMER.schedule(timerTask, l, l2);
                }
            }
            catch (IllegalStateException illegalStateException) {
                if (!this.cancelled) break block7;
                throw illegalStateException;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResetableFutureTask<V>
    extends FutureTask<V> {
        @Override
        public boolean runAndReset() {
            return super.runAndReset();
        }

        public ResetableFutureTask(Runnable runnable, V v) {
            super(runnable, v);
        }

        public ResetableFutureTask(Callable<V> callable) {
            super(callable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScheduledTimerTask<V>
    extends TimerTask
    implements ScheduledFuture<V> {
        private final ResetableFutureTask<V> task;

        public ScheduledTimerTask(final Runnable runnable) {
            this.task = new ResetableFutureTask<Object>(new Runnable(){

                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        ErrorService.error(throwable);
                    }
                }
            }, null);
        }

        public ScheduledTimerTask(final Callable<V> callable) {
            this.task = new ResetableFutureTask(new Callable<V>(){

                @Override
                public V call() {
                    try {
                        Object v = callable.call();
                        return v;
                    }
                    catch (Throwable throwable) {
                        ErrorService.error(throwable);
                        return null;
                    }
                }
            });
        }

        @Override
        public void run() {
            this.task.runAndReset();
        }

        @Override
        public long getDelay(TimeUnit timeUnit) {
            return -1L;
        }

        @Override
        public int compareTo(Delayed delayed) {
            return 0;
        }

        @Override
        public boolean cancel(boolean bl) {
            this.task.cancel(true);
            return this.cancel();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.task.get();
        }

        @Override
        public V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.task.get(l, timeUnit);
        }

        @Override
        public boolean isCancelled() {
            return this.task.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.task.isDone();
        }
    }
}

