/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.Iterator;
import java.util.LinkedList;
import org.limewire.collection.AutoCompleteDictionary;
import org.limewire.collection.StringTrie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTrieSet
implements AutoCompleteDictionary,
Iterable<String> {
    private transient StringTrie<String> map;

    public StringTrieSet(boolean bl) {
        this.map = new StringTrie(bl);
    }

    @Override
    public void addEntry(String string) {
        if (!this.contains(string)) {
            this.map.add(string, string);
        }
    }

    public boolean contains(String string) {
        return this.map.get(string) != null;
    }

    @Override
    public boolean removeEntry(String string) {
        return this.map.remove(string);
    }

    public Iterator getPrefixedBy(String string) {
        return this.map.getPrefixedBy(string);
    }

    @Override
    public String lookup(String string) {
        Iterator<String> iterator = this.map.getPrefixedBy(string);
        if (!iterator.hasNext()) {
            return null;
        }
        return iterator.next();
    }

    @Override
    public Iterator<String> iterator() {
        return this.map.getIterator();
    }

    @Override
    public Iterator<String> iterator(String string) {
        return this.map.getPrefixedBy(string);
    }

    @Override
    public void clear() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : this) {
            linkedList.add(string);
        }
        for (String string : linkedList) {
            this.removeEntry(string);
        }
    }
}

