/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import org.limewire.collection.UnmodifiableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseIntSet
extends AbstractSet<Integer> {
    private int[] list = new int[0];
    private int size;
    private int modCount;

    public SparseIntSet() {
        this(8);
    }

    public SparseIntSet(int n) {
        this.ensureCapacity(n);
    }

    public SparseIntSet(Collection<? extends Integer> collection) {
        this.addAll(collection);
    }

    public void compact() {
        int n = this.list.length;
        if (this.size < n) {
            int[] nArray = new int[this.size];
            System.arraycopy(this.list, 0, nArray, 0, this.size);
            this.list = nArray;
        }
    }

    public int getActualMemoryUsed() {
        return this.list.length * 4;
    }

    public int nextSetBit(int n) {
        int n2 = this.binarySearch(n);
        if (n2 < 0) {
            n2 = -(n2 + 1);
        }
        if (n2 == this.size) {
            return -1;
        }
        return this.list[n2];
    }

    @Override
    public boolean add(Integer n) {
        int n2 = this.binarySearch(n);
        if (n2 >= 0) {
            return false;
        }
        n2 = -(n2 + 1);
        this.ensureCapacity(this.size + 1);
        ++this.size;
        System.arraycopy(this.list, n2, this.list, n2 + 1, this.size - n2 - 1);
        this.list[n2] = n;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        if (collection instanceof SparseIntSet || collection instanceof SortedSet) {
            if (this.isEmpty()) {
                this.fillFromSorted(collection);
                return true;
            }
            int[] nArray = new int[this.size() + collection.size()];
            Iterator<Integer> iterator = this.iterator();
            Iterator<? extends Integer> iterator2 = collection.iterator();
            int n = 0;
            boolean bl = false;
            int n2 = Integer.MIN_VALUE;
            boolean bl2 = true;
            boolean bl3 = true;
            while (iterator.hasNext() || iterator2.hasNext()) {
                int n3 = n2;
                int n4 = n2;
                if (bl2 && iterator.hasNext()) {
                    n3 = iterator.next();
                }
                if (bl3 && iterator2.hasNext()) {
                    n4 = iterator2.next();
                }
                n2 = Math.max(n3, n4);
                if (n > 0 && nArray[n - 1] == Math.min(n3, n4)) continue;
                if (n3 < n4) {
                    nArray[n] = n3;
                    bl2 = true;
                    bl3 = false;
                } else if (n3 > n4) {
                    bl = true;
                    nArray[n] = n4;
                    bl2 = false;
                    bl3 = true;
                } else {
                    nArray[n] = n3;
                    bl2 = true;
                    bl3 = true;
                }
                ++n;
            }
            if (nArray[n - 1] != n2) {
                nArray[n++] = n2;
            }
            this.list = nArray;
            this.size = n;
            this.compact();
            return bl;
        }
        this.ensureCapacity(this.size() + collection.size());
        boolean bl = super.addAll(collection);
        this.compact();
        return bl;
    }

    private void fillFromSorted(Collection<? extends Integer> collection) {
        this.list = new int[collection.size()];
        Iterator<? extends Integer> iterator = collection.iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            this.list[++this.size - 1] = n;
        }
    }

    private void ensureCapacity(int n) {
        int n2 = this.list.length;
        if (n > n2) {
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            int[] nArray = new int[n3];
            System.arraycopy(this.list, 0, nArray, 0, this.size);
            this.list = nArray;
        }
    }

    private int binarySearch(int n) {
        int n2 = 0;
        int n3 = this.size - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            int n5 = this.list[n4];
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    @Override
    public boolean remove(Object object) {
        if (!(object instanceof Integer)) {
            return false;
        }
        int n = (Integer)object;
        int n2 = this.binarySearch(n);
        if (n2 < 0) {
            return false;
        }
        int n3 = this.size - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(this.list, n2 + 1, this.list, n2, n3);
        }
        --this.size;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean contains(Object object) {
        if (!(object instanceof Integer)) {
            return false;
        }
        int n = (Integer)object;
        int n2 = this.binarySearch(n);
        return n2 >= 0;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new ArrayIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        SparseIntSet sparseIntSet = new SparseIntSet();
        for (int n : this) {
            if (collection.contains(n)) continue;
            sparseIntSet.add(n);
        }
        return this.removeAll(sparseIntSet);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArrayIterator
    extends UnmodifiableIterator<Integer> {
        private int index;
        private final int mod;

        private ArrayIterator() {
            this.mod = SparseIntSet.this.modCount;
        }

        private void checkModification() {
            if (SparseIntSet.this.modCount != this.mod) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < SparseIntSet.this.size;
        }

        @Override
        public Integer next() {
            this.checkModification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return SparseIntSet.this.list[this.index++];
        }
    }
}

