/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LIFOSet<E>
implements Set<E> {
    private final Set<E> set;
    private final List<E> list;

    public LIFOSet() {
        this(50, 0.75f);
    }

    public LIFOSet(int n) {
        this(n, 0.75f);
    }

    public LIFOSet(int n, float f) {
        this.set = new HashSet(n, f);
        this.list = new ArrayList(n);
    }

    @Override
    public boolean add(E e) {
        if (this.set.add(e)) {
            this.list.add(e);
            return true;
        }
        this.list.remove(e);
        this.list.add(e);
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = false;
        for (E e : collection) {
            bl |= this.add(e);
        }
        return bl;
    }

    @Override
    public void clear() {
        this.set.clear();
        this.list.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.set.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.set.containsAll(collection);
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new LIFOSetIterator();
    }

    @Override
    public boolean remove(Object object) {
        if (this.set.remove(object)) {
            this.list.remove(object);
            return true;
        }
        return false;
    }

    protected boolean removeEldest() {
        if (this.list.isEmpty()) {
            return false;
        }
        return this.remove(0);
    }

    protected boolean removeNewest() {
        if (this.list.isEmpty()) {
            return false;
        }
        return this.remove(this.list.size() - 1);
    }

    protected boolean remove(int n) {
        return this.set.remove(this.list.remove(n));
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.list.removeAll(collection);
        return this.set.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.list.retainAll(collection);
        return this.set.retainAll(collection);
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public Object[] toArray() {
        ArrayList<E> arrayList = new ArrayList<E>(this.list);
        Collections.reverse(arrayList);
        return arrayList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        ArrayList<E> arrayList = new ArrayList<E>(this.list);
        Collections.reverse(arrayList);
        return arrayList.toArray(TArray);
    }

    public String toString() {
        ArrayList<E> arrayList = new ArrayList<E>(this.list);
        Collections.reverse(arrayList);
        return ((Object)arrayList).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LIFOSetIterator
    implements Iterator<E> {
        private E current;
        private int index = 0;

        public LIFOSetIterator() {
            this.index = LIFOSet.this.list.size() - 1;
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public E next() {
            if (this.index < 0) {
                throw new NoSuchElementException();
            }
            this.current = LIFOSet.this.list.get(this.index);
            --this.index;
            return this.current;
        }

        @Override
        public void remove() {
            if (this.index == LIFOSet.this.list.size() - 1) {
                throw new IllegalStateException();
            }
            LIFOSet.this.set.remove(this.current);
            Object e = LIFOSet.this.list.remove(this.index + 1);
            if (e != this.current) {
                throw new ConcurrentModificationException();
            }
            this.current = null;
        }
    }
}

