/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import org.limewire.collection.UnmodifiableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntBuffer
implements Cloneable,
Iterable<Integer> {
    private final int size;
    private int[] buf;
    private int head;
    private int tail;

    public IntBuffer(int n) {
        assert (n >= 1);
        this.size = n + 1;
        this.head = 0;
        this.tail = 0;
    }

    public IntBuffer(IntBuffer intBuffer) {
        this.size = intBuffer.size;
        this.head = intBuffer.head;
        this.tail = intBuffer.tail;
        if (intBuffer.buf != null) {
            this.buf = new int[intBuffer.buf.length];
            System.arraycopy(intBuffer.buf, 0, this.buf, 0, intBuffer.buf.length);
        }
    }

    private void initialize() {
        if (this.buf == null) {
            this.buf = new int[this.size + 1];
        }
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public boolean isFull() {
        return this.increment(this.tail) == this.head;
    }

    public final int size() {
        return this.getSize();
    }

    public int getSize() {
        if (this.head <= this.tail) {
            return this.tail - this.head;
        }
        return this.size - this.head + this.tail;
    }

    public int getCapacity() {
        return this.size - 1;
    }

    private int decrement(int n) {
        if (n == 0) {
            return this.size - 1;
        }
        return n - 1;
    }

    private int increment(int n) {
        if (n == this.size - 1) {
            return 0;
        }
        return n + 1;
    }

    private int index(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.getSize()) {
            throw new IndexOutOfBoundsException("index: " + n + ", size: " + this.getSize());
        }
        return (n + this.head) % this.size;
    }

    public int get(int n) throws IndexOutOfBoundsException {
        this.initialize();
        return this.buf[this.index(n)];
    }

    public void set(int n, int n2) throws IndexOutOfBoundsException {
        this.initialize();
        this.buf[this.index((int)n)] = n2;
    }

    public int add(int n) {
        return this.addFirst(n);
    }

    public int addFirst(int n) {
        this.initialize();
        int n2 = -1;
        if (this.isFull()) {
            n2 = this.removeLast();
        }
        this.head = this.decrement(this.head);
        this.buf[this.head] = n;
        return n2;
    }

    public int addLast(int n) {
        this.initialize();
        int n2 = -1;
        if (this.isFull()) {
            n2 = this.removeFirst();
        }
        this.buf[this.tail] = n;
        this.tail = this.increment(this.tail);
        return n2;
    }

    public boolean contains(int n) {
        IntBufferIterator intBufferIterator = this.iterator();
        while (intBufferIterator.hasNext()) {
            if (intBufferIterator.nextInt() != n) continue;
            return true;
        }
        return false;
    }

    public int first() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.buf[this.head];
    }

    public int last() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.buf[this.decrement(this.tail)];
    }

    public int removeFirst() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int n = this.buf[this.head];
        this.buf[this.head] = -1;
        this.head = this.increment(this.head);
        return n;
    }

    public int removeLast() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        this.tail = this.decrement(this.tail);
        int n = this.buf[this.tail];
        this.buf[this.tail] = -1;
        return n;
    }

    public int remove(int n) throws IndexOutOfBoundsException {
        int n2 = this.get(n);
        int n3 = this.index(n);
        while (n3 != this.tail) {
            this.buf[n3] = this.buf[this.increment(n3)];
            n3 = this.increment(n3);
        }
        this.tail = this.decrement(this.tail);
        return n2;
    }

    public boolean removeValue(int n) {
        for (int i = 0; i < this.getSize(); ++i) {
            if (n != this.get(i)) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    public boolean removeAll(int n) {
        boolean bl = false;
        for (int i = 0; i < this.getSize(); ++i) {
            if (n != this.get(i)) continue;
            this.remove(i);
            --i;
            bl = true;
        }
        return bl;
    }

    public void clear() {
        this.head = 0;
        this.tail = 0;
    }

    public IntBufferIterator iterator() {
        return new IntBufferIterator();
    }

    public Object clone() {
        return new IntBuffer(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        boolean bl = true;
        IntBufferIterator intBufferIterator = this.iterator();
        while (intBufferIterator.hasNext()) {
            if (!bl) {
                stringBuilder.append(", ");
            } else {
                bl = false;
            }
            stringBuilder.append(intBufferIterator.nextInt());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IntBufferIterator
    extends UnmodifiableIterator<Integer> {
        int index;
        int oldHead;
        int oldTail;

        IntBufferIterator() {
            this.index = IntBuffer.this.head;
            this.oldHead = IntBuffer.this.head;
            this.oldTail = IntBuffer.this.tail;
        }

        @Override
        public boolean hasNext() {
            this.ensureNoModifications();
            return this.index != IntBuffer.this.tail;
        }

        @Override
        public Integer next() throws NoSuchElementException {
            return this.nextInt();
        }

        public int nextInt() throws NoSuchElementException {
            this.ensureNoModifications();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n = IntBuffer.this.buf[this.index];
            this.index = IntBuffer.this.increment(this.index);
            return n;
        }

        private void ensureNoModifications() {
            if (this.oldHead != IntBuffer.this.head || this.oldTail != IntBuffer.this.tail) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

