/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.limewire.service.ErrorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedSizeSortedSet<E>
implements Iterable<E> {
    private SortedSet<E> _sortedSet;
    private Map<E, E> _map;
    private int _maxSize;

    public FixedSizeSortedSet() {
        this(50);
    }

    public FixedSizeSortedSet(int n) {
        this._maxSize = n;
        this._sortedSet = new TreeSet();
        this._map = new HashMap<E, E>();
    }

    public FixedSizeSortedSet(Comparator<? super E> comparator) {
        this(comparator, 50);
    }

    public FixedSizeSortedSet(Comparator<? super E> comparator, int n) {
        this._maxSize = n;
        this._sortedSet = new TreeSet<E>(comparator);
        this._map = new HashMap<E, E>();
    }

    public Object clone() {
        FixedSizeSortedSet<E> fixedSizeSortedSet = new FixedSizeSortedSet<E>(this._maxSize);
        fixedSizeSortedSet._sortedSet = (SortedSet)((TreeSet)this._sortedSet).clone();
        fixedSizeSortedSet._map = (Map)((HashMap)this._map).clone();
        return fixedSizeSortedSet;
    }

    public boolean add(E e) {
        if (e == null) {
            return false;
        }
        E e2 = this._map.get(e);
        if (e2 != null) {
            boolean bl = this._sortedSet.remove(e2);
            if (!bl) {
                this.invariantsBroken(e, e2);
            }
            this._sortedSet.add(e);
            this._map.put(e, e);
            return false;
        }
        if (this._map.size() >= this._maxSize) {
            boolean bl;
            E e3 = this._sortedSet.last();
            boolean bl2 = bl = this._map.remove(e3) != null;
            if (!bl) {
                this.invariantsBroken(e3, e3);
            }
            if (!(bl = this._sortedSet.remove(e3))) {
                this.invariantsBroken(e3, e3);
            }
        }
        this._map.put(e, e);
        boolean bl = this._sortedSet.add(e);
        if (!bl) {
            this.invariantsBroken(e, e);
        }
        return true;
    }

    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = false;
        for (E e : collection) {
            bl |= this.add(e);
        }
        return bl;
    }

    public E get(E e) {
        return this._map.get(e);
    }

    public E last() {
        return this._sortedSet.last();
    }

    public E first() {
        return this._sortedSet.first();
    }

    public boolean remove(E e) {
        boolean bl;
        E e2 = this._map.remove(e);
        boolean bl2 = e2 != null;
        if (bl2 != (bl = this._sortedSet.remove(e2))) {
            this.invariantsBroken(e, e2);
        }
        return bl2;
    }

    public void clear() {
        this._sortedSet.clear();
        this._map.clear();
    }

    public boolean contains(Object object) {
        return this._map.get(object) != null;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof FixedSizeSortedSet)) {
            return false;
        }
        FixedSizeSortedSet fixedSizeSortedSet = (FixedSizeSortedSet)object;
        return this._sortedSet.equals(fixedSizeSortedSet._sortedSet) && ((Object)this._map).equals(fixedSizeSortedSet._map);
    }

    public int hashCode() {
        return this._sortedSet.hashCode() + 37 * ((Object)this._map).hashCode();
    }

    public boolean isEmpty() {
        assert (this._sortedSet.isEmpty() == this._map.isEmpty());
        return this._sortedSet.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new FSSSIterator();
    }

    public int size() {
        if (this._sortedSet.size() != this._map.size()) {
            this.invariantsBroken(null, null);
        }
        return this._sortedSet.size();
    }

    private void invariantsBroken(E e, E e2) {
        String string = this._map.toString();
        String string2 = this._sortedSet.toString();
        String string3 = "" + this._map.size();
        String string4 = "" + this._sortedSet.size();
        this.stabilize();
        String string5 = this._map.toString();
        String string6 = this._sortedSet.toString();
        String string7 = "" + this._map.size();
        String string8 = "" + this._sortedSet.size();
        ErrorService.error(new IllegalStateException("key: " + e + ", value: " + e2 + "\nbefore stabilization: " + "\nsize of map: " + string3 + ", set: " + string4 + "\nmap: " + string + "\nset: " + string2 + "\nafter stabilization: " + "\nsize of map " + string7 + ", set: " + string8 + "\nmap: " + string5 + "\nset: " + string6));
    }

    private void stabilize() {
        Map.Entry<E, E> entry;
        Object object = this._map.entrySet().iterator();
        while (object.hasNext()) {
            entry = object.next();
            if (this._sortedSet.contains(entry.getValue())) continue;
            object.remove();
        }
        object = this._map.values();
        entry = this._sortedSet.iterator();
        while (entry.hasNext()) {
            Object e = entry.next();
            if (object.contains(e)) continue;
            entry.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FSSSIterator
    implements Iterator<E> {
        private final Iterator<E> _setIterator;
        private E _current;

        public FSSSIterator() {
            this._setIterator = FixedSizeSortedSet.this._sortedSet.iterator();
        }

        @Override
        public boolean hasNext() {
            return this._setIterator.hasNext();
        }

        @Override
        public E next() {
            this._current = this._setIterator.next();
            return this._current;
        }

        @Override
        public void remove() {
            this._setIterator.remove();
            FixedSizeSortedSet.this._map.remove(this._current);
            this._current = null;
        }
    }
}

