/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.limewire.collection.Buffer;
import org.limewire.collection.UnmodifiableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BucketQueue<E>
implements Cloneable,
Iterable<E> {
    private Buffer<E>[] buckets;
    private int size = 0;

    public BucketQueue(int n, int n2) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("Bad priorities: " + n);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Bad capacity: " + n2);
        }
        this.buckets = new Buffer[n];
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new Buffer(n2);
        }
    }

    public BucketQueue(int[] nArray) throws IllegalArgumentException {
        if (nArray.length <= 0) {
            throw new IllegalArgumentException();
        }
        this.buckets = new Buffer[nArray.length];
        for (int i = 0; i < this.buckets.length; ++i) {
            if (nArray[i] <= 0) {
                throw new IllegalArgumentException("Non-positive capacity: " + nArray[i]);
            }
            this.buckets[i] = new Buffer(nArray[i]);
        }
    }

    public BucketQueue(BucketQueue<? extends E> bucketQueue) {
        this.buckets = new Buffer[bucketQueue.buckets.length];
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new Buffer<E>(bucketQueue.buckets[i]);
        }
        this.size = bucketQueue.size;
    }

    public void clear() {
        this.repOk();
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i].clear();
        }
        this.size = 0;
        this.repOk();
    }

    public E insert(E e, int n) {
        this.repOk();
        if (n < 0 || n >= this.buckets.length) {
            throw new IllegalArgumentException("Bad priority: " + n);
        }
        E e2 = this.buckets[n].addFirst(e);
        if (e2 == null) {
            ++this.size;
        }
        this.repOk();
        return e2;
    }

    public boolean removeAll(Object object) {
        int n;
        this.repOk();
        boolean bl = false;
        for (n = 0; n < this.buckets.length; ++n) {
            bl |= this.buckets[n].removeAll(object);
        }
        if (bl) {
            this.size = 0;
            for (n = 0; n < this.buckets.length; ++n) {
                this.size += this.buckets[n].getSize();
            }
        }
        this.repOk();
        return bl;
    }

    public E extractMax() throws NoSuchElementException {
        this.repOk();
        try {
            for (int i = this.buckets.length - 1; i >= 0; --i) {
                if (this.buckets[i].isEmpty()) continue;
                --this.size;
                E e = this.buckets[i].removeFirst();
                return e;
            }
            throw new NoSuchElementException();
        }
        finally {
            this.repOk();
        }
    }

    public E getMax() throws NoSuchElementException {
        for (int i = this.buckets.length - 1; i >= 0; --i) {
            if (this.buckets[i].isEmpty()) continue;
            return this.buckets[i].first();
        }
        throw new NoSuchElementException();
    }

    public int size() {
        return this.size;
    }

    public int size(int n) throws IllegalArgumentException {
        if (n < 0 || n >= this.buckets.length) {
            throw new IllegalArgumentException("Bad priority: " + n);
        }
        return this.buckets[n].getSize();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new BucketQueueIterator(this.buckets.length - 1, this.size());
    }

    public Iterator<E> iterator(int n, int n2) throws IllegalArgumentException {
        if (n < 0 || n >= this.buckets.length) {
            throw new IllegalArgumentException("Bad priority: " + n);
        }
        return new BucketQueueIterator(n, n2);
    }

    public BucketQueue<E> clone() {
        return new BucketQueue<E>(this);
    }

    private void repOk() {
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = this.buckets.length - 1; i >= 0; --i) {
            if (i != this.buckets.length - 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.buckets[i].toString());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BucketQueueIterator
    extends UnmodifiableIterator<E> {
        private Iterator<E> currentIterator;
        private int currentBucket;
        private int left;

        public BucketQueueIterator(int n, int n2) {
            this.currentBucket = n;
            this.currentIterator = BucketQueue.this.buckets[this.currentBucket].iterator();
            this.left = n2;
        }

        @Override
        public synchronized boolean hasNext() {
            if (this.left <= 0) {
                return false;
            }
            if (this.currentIterator.hasNext()) {
                return true;
            }
            if (this.currentBucket < 0) {
                return false;
            }
            --this.currentBucket;
            while (this.currentBucket >= 0) {
                this.currentIterator = BucketQueue.this.buckets[this.currentBucket].iterator();
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                --this.currentBucket;
            }
            return false;
        }

        @Override
        public synchronized E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.left;
            return this.currentIterator.next();
        }
    }
}

