/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cabos;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.limegroup.gnutella.LimeWireCore;
import com.limegroup.gnutella.LimeWireCoreModule;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import jp.sourceforge.cabos.AqDispatcher;
import jp.sourceforge.cabos.AqEvent;
import jp.sourceforge.cabos.AqEventHandler;
import jp.sourceforge.cabos.ConnectionUpdate;
import jp.sourceforge.cabos.TransferUpdate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.nio.NIODispatcher;
import org.limewire.util.VersionUtils;

public class AqMain {
    private static final Log LOG = LogFactory.getLog(AqMain.class);
    private static InputStreamReader reader = null;
    private static OutputStreamWriter writer = null;
    protected static boolean isShuttingdown = false;
    protected static LimeWireCore core = null;

    public static void main(String[] stringArray) {
        try {
            reader = new InputStreamReader(System.in, "UTF-8");
            writer = new OutputStreamWriter((OutputStream)System.out, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.exit(0);
        }
        if (!VersionUtils.isJava15OrAbove()) {
            System.exit(0);
        }
        AqEvent.signalEvent(98);
        if (!NIODispatcher.instance().isRunning()) {
            System.exit(0);
        }
        AqEvent.signalEvent(99);
        AqMain.readLoop();
        System.exit(0);
    }

    private static void readLoop() {
        LinkedList<String> linkedList = new LinkedList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        while (!isShuttingdown) {
            int n;
            try {
                n = reader.read();
            }
            catch (IOException iOException) {
                LOG.error((Object)iOException);
                break;
            }
            char c = (char)n;
            if (c == '|' || c == '\n') {
                linkedList.add(stringBuffer.toString());
                stringBuffer.setLength(0);
                if (c != '\n') continue;
                try {
                    AqDispatcher.dispatchCommand(linkedList);
                }
                catch (Throwable throwable) {
                    LOG.error((Object)throwable);
                    break;
                }
                linkedList.clear();
                continue;
            }
            if (c == '\r') continue;
            stringBuffer.append(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeEvent(String string) {
        OutputStreamWriter outputStreamWriter = writer;
        synchronized (outputStreamWriter) {
            try {
                writer.write(string);
                writer.flush();
            }
            catch (IOException iOException) {
                LOG.warn((Object)iOException);
            }
        }
    }

    protected static void start() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new LimeWireCoreModule(AqEventHandler.class)});
        core = (LimeWireCore)injector.getInstance(LimeWireCore.class);
        core.getLifecycleManager().start();
        if (!ConnectionSettings.DISABLE_UPNP.getValue()) {
            core.getUPnPManager().start();
        }
        core.getBackgroundExecutor().scheduleAtFixedRate(new ConnectionUpdate(), 60000L, 60000L, TimeUnit.MILLISECONDS);
        core.getBackgroundExecutor().scheduleAtFixedRate(new TransferUpdate(), 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void shutdown() {
        OutputStreamWriter outputStreamWriter = writer;
        synchronized (outputStreamWriter) {
            try {
                reader.close();
                writer.close();
            }
            catch (IOException iOException) {
                LOG.error((Object)iOException);
            }
        }
        isShuttingdown = true;
        core.getLifecycleManager().shutdown();
    }
}

