/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cabos;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.connection.ConnectionLifecycleEvent;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.search.HostData;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.cabos.AqEvent;
import jp.sourceforge.cabos.AqResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IpPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AqEventHandler
implements ActivityCallback {
    private static final Log LOG = LogFactory.getLog(AqEventHandler.class);
    protected static final Map hosts = Collections.synchronizedMap(new HashMap());
    protected static final Map queries = Collections.synchronizedMap(new HashMap());
    protected static final Map indices = Collections.synchronizedMap(new HashMap());
    protected static final Map responses = Collections.synchronizedMap(new HashMap());

    @Override
    public void handleAddressStateChanged() {
    }

    @Override
    public void handleConnectionLifecycleEvent(ConnectionLifecycleEvent connectionLifecycleEvent) {
        RoutedConnection routedConnection = connectionLifecycleEvent.getConnection();
        if (connectionLifecycleEvent.isConnectionInitializedEvent()) {
            AqEvent.signalEvent(2, routedConnection);
        } else if (connectionLifecycleEvent.isConnectionClosedEvent()) {
            AqEvent.signalEvent(3, routedConnection);
        }
    }

    @Override
    public void installationCorrupted() {
    }

    @Override
    public void handleQueryResult(RemoteFileDesc remoteFileDesc, HostData hostData, Set<? extends IpPort> set) {
        AqEvent.signalEvent(1, new AqResponse(remoteFileDesc, hostData, set));
    }

    @Override
    public void handleQueryString(String string) {
    }

    @Override
    public void addUpload(Uploader uploader) {
        if (uploader.getState() == Uploader.UploadStatus.CONNECTING || uploader.getState() == Uploader.UploadStatus.UPLOADING || uploader.getState() == Uploader.UploadStatus.QUEUED) {
            AqEvent.signalEvent(9, uploader);
        }
    }

    @Override
    public void removeUpload(Uploader uploader) {
        AqEvent.signalEvent(11, uploader);
        AqEvent.signalEvent(10, uploader);
    }

    @Override
    public void browseHostFailed(GUID gUID) {
        AqEvent.signalEvent(14, gUID);
    }

    @Override
    public void fileManagerLoading() {
    }

    @Override
    public void fileManagerLoaded() {
    }

    @Override
    public boolean warnAboutSharingSensitiveDirectory(File file) {
        return false;
    }

    @Override
    public void handleFileEvent(FileManagerEvent fileManagerEvent) {
        if (fileManagerEvent.isAddEvent()) {
            FileDesc[] fileDescArray = fileManagerEvent.getFileDescs();
            for (int i = 0; i < fileDescArray.length; ++i) {
                AqEvent.signalEvent(13, fileDescArray[i]);
            }
        }
    }

    @Override
    public void handleSharedFileUpdate(File file) {
    }

    @Override
    public void setAnnotateEnabled(boolean bl) {
    }

    @Override
    public void uploadsComplete() {
    }

    @Override
    public void restoreApplication() {
    }

    @Override
    public boolean isQueryAlive(GUID gUID) {
        return queries.containsKey(gUID);
    }

    @Override
    public void componentLoading(String string) {
    }

    @Override
    public void acceptedIncomingChanged(boolean bl) {
    }

    @Override
    public void addDownload(Downloader downloader) {
        AqEvent.signalEvent(5, downloader);
    }

    @Override
    public void removeDownload(Downloader downloader) {
        AqEvent.signalEvent(7, downloader);
        AqEvent.signalEvent(6, downloader);
    }

    @Override
    public void downloadsComplete() {
    }

    @Override
    public void showDownloads() {
    }

    @Override
    public void promptAboutCorruptDownload(Downloader downloader) {
        downloader.discardCorruptDownload(false);
    }

    @Override
    public String getHostValue(String string) {
        return null;
    }
}

