/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cabos;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.cabos.AqEventHandler;
import jp.sourceforge.cabos.AqMain;
import jp.sourceforge.cabos.AqResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.NetworkUtils;
import org.limewire.util.StringUtils;

public class AqEvent {
    private static final Log LOG = LogFactory.getLog(AqEvent.class);
    private static final Map stateCache = new HashMap();
    private static int currentLocalIndex = -1;
    private static final String kSep = "<aq/>";
    protected static final int kLWEventQueryResult = 1;
    protected static final int kLWEventConnectionInitialized = 2;
    protected static final int kLWEventConnectionClosed = 3;
    protected static final int kLWEventConnectionsUpdated = 4;
    protected static final int kLWEventAddDownload = 5;
    protected static final int kLWEventRemoveDownload = 6;
    protected static final int kLWEventUpdateDownloadStats = 7;
    protected static final int kLWEventDownloadsUpdated = 8;
    protected static final int kLWEventAddUpload = 9;
    protected static final int kLWEventRemoveUpload = 10;
    protected static final int kLWEventUpdateUploadStats = 11;
    protected static final int kLWEventUploadsUpdated = 12;
    protected static final int kLWEventAddSharedFile = 13;
    protected static final int kLWEventBrowseHostFailed = 14;
    protected static final int kLWEventCoreConnected = 98;
    protected static final int kLWEventCoreInitialized = 99;

    private static String decodeValue(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        string = StringUtils.replace(string, "&amp;", "&");
        string = StringUtils.replace(string, "&lt;", "<");
        string = StringUtils.replace(string, "&gt;", ">");
        string = StringUtils.replace(string, "&apos;", "'");
        string = StringUtils.replace(string, "&quot;", "\"");
        return string;
    }

    private static String fixValue(String string) {
        return string != null ? string : "";
    }

    private static String fixUserAgent(String string) {
        if (string == null) {
            return "";
        }
        if (string.indexOf("Cabos") == -1 && string.indexOf("Acqlite") == -1) {
            return string;
        }
        return string.substring(string.indexOf("(") + 1, string.indexOf(")"));
    }

    protected static void signalEvent(int n) {
        AqEvent.signalEvent(n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void signalEvent(int n, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        Thread.yield();
        Class<AqEvent> clazz = AqEvent.class;
        synchronized (AqEvent.class) {
            switch (n) {
                case 1: {
                    String string;
                    String string2;
                    String string3;
                    String string4;
                    String string5;
                    Object object2;
                    AqResponse aqResponse = (AqResponse)object;
                    RemoteFileDesc remoteFileDesc = aqResponse.getRFD();
                    HostData hostData = aqResponse.getData();
                    Set set = aqResponse.getLocs();
                    GUID gUID = new GUID(hostData.getMessageGUID());
                    if (!AqEventHandler.queries.containsKey(gUID)) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return;
                    }
                    Integer n2 = (Integer)AqEventHandler.queries.get(gUID);
                    int n3 = ++currentLocalIndex;
                    stringBuffer.append(n2);
                    stringBuffer.append(":");
                    stringBuffer.append(n3);
                    String string6 = stringBuffer.toString();
                    stringBuffer.setLength(0);
                    AqEventHandler.responses.put(string6, aqResponse);
                    if (remoteFileDesc.getXMLDocument() != null) {
                        object2 = remoteFileDesc.getXMLDocument();
                        string5 = AqEvent.fixValue(((LimeXMLDocument)object2).getValue("audios__audio__bitrate__"));
                        string4 = AqEvent.fixValue(((LimeXMLDocument)object2).getValue("audios__audio__seconds__"));
                        string3 = AqEvent.decodeValue(((LimeXMLDocument)object2).getValue("audios__audio__artist__"));
                        string2 = AqEvent.decodeValue(((LimeXMLDocument)object2).getValue("audios__audio__album__"));
                        string = AqEvent.decodeValue(((LimeXMLDocument)object2).getValue("audios__audio__title__"));
                    } else {
                        string5 = "";
                        string4 = "";
                        string3 = "";
                        string2 = "";
                        string = "";
                    }
                    stringBuffer.append(hostData.getIP());
                    stringBuffer.append(":");
                    stringBuffer.append(hostData.getPort());
                    object2 = stringBuffer.toString();
                    stringBuffer.setLength(0);
                    if (hostData.isBrowseHostEnabled()) {
                        AqEventHandler.hosts.put(object2, hostData);
                    }
                    boolean bl = AqMain.core.getSpamManager().isSpam(remoteFileDesc) || set.size() > 10;
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(n2);
                    stringBuffer.append(kSep);
                    stringBuffer.append(n3);
                    stringBuffer.append(kSep);
                    stringBuffer.append(set.size());
                    stringBuffer.append(kSep);
                    stringBuffer.append((String)object2);
                    stringBuffer.append(kSep);
                    stringBuffer.append(hostData.isBrowseHostEnabled() ? 1 : 0);
                    stringBuffer.append(kSep);
                    stringBuffer.append(remoteFileDesc.getSHA1Urn());
                    stringBuffer.append(kSep);
                    stringBuffer.append(remoteFileDesc.getFileName());
                    stringBuffer.append(kSep);
                    stringBuffer.append(remoteFileDesc.getSpeed());
                    stringBuffer.append(kSep);
                    stringBuffer.append(remoteFileDesc.getSize());
                    stringBuffer.append(kSep);
                    stringBuffer.append(string5);
                    stringBuffer.append(kSep);
                    stringBuffer.append(string4);
                    stringBuffer.append(kSep);
                    stringBuffer.append(string3);
                    stringBuffer.append(kSep);
                    stringBuffer.append(string2);
                    stringBuffer.append(kSep);
                    stringBuffer.append(string);
                    stringBuffer.append(kSep);
                    stringBuffer.append(bl ? 1 : 0);
                    stringBuffer.append("\n");
                    break;
                }
                case 2: {
                    RoutedConnection routedConnection = (RoutedConnection)object;
                    String string = new Locale(routedConnection.getLocalePref()).getDisplayLanguage();
                    String string7 = routedConnection.getConnectionCapabilities().isSupernodeClientConnection() ? "Leaf" : (routedConnection.getConnectionCapabilities().isClientSupernodeConnection() ? "Ultrapeer" : (routedConnection.getConnectionCapabilities().isSupernodeSupernodeConnection() ? "Peer" : "Standard"));
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(routedConnection.getAddress());
                    stringBuffer.append(":");
                    stringBuffer.append(routedConnection.getPort());
                    stringBuffer.append(kSep);
                    stringBuffer.append(AqEvent.fixUserAgent(routedConnection.getConnectionCapabilities().getUserAgent()));
                    stringBuffer.append(kSep);
                    stringBuffer.append(string);
                    stringBuffer.append(kSep);
                    stringBuffer.append(string7);
                    stringBuffer.append("\n");
                    break;
                }
                case 3: {
                    RoutedConnection routedConnection = (RoutedConnection)object;
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(routedConnection.getAddress());
                    stringBuffer.append(":");
                    stringBuffer.append(routedConnection.getPort());
                    stringBuffer.append("\n");
                    break;
                }
                case 5: {
                    Downloader downloader = (Downloader)object;
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(downloader.hashCode());
                    stringBuffer.append(kSep);
                    stringBuffer.append(downloader.getSaveFile() != null ? downloader.getSaveFile().getName() : "");
                    stringBuffer.append(kSep);
                    stringBuffer.append(downloader.getState().ordinal());
                    stringBuffer.append(kSep);
                    stringBuffer.append(downloader.getContentLength());
                    stringBuffer.append(kSep);
                    stringBuffer.append(downloader.getAmountRead());
                    stringBuffer.append(kSep);
                    stringBuffer.append(downloader.getSha1Urn());
                    stringBuffer.append("\n");
                    break;
                }
                case 6: {
                    Downloader downloader = (Downloader)object;
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(downloader.hashCode());
                    stringBuffer.append("\n");
                    stateCache.remove(new Integer(downloader.hashCode()));
                    if (!downloader.canceled() || downloader.getFile() == null) break;
                    downloader.getFile().delete();
                    break;
                }
                case 7: {
                    float f;
                    Downloader downloader = (Downloader)object;
                    try {
                        f = downloader.getMeasuredBandwidth() * 1024.0f;
                    }
                    catch (InsufficientDataException insufficientDataException) {
                        f = 0.0f;
                    }
                    float f2 = downloader.getAverageBandwidth() * 1024.0f;
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(downloader.hashCode());
                    stringBuffer.append(kSep);
                    stringBuffer.append(downloader.getState().ordinal());
                    stringBuffer.append(kSep);
                    stringBuffer.append(downloader.getContentLength());
                    stringBuffer.append(kSep);
                    stringBuffer.append(downloader.getAmountRead());
                    stringBuffer.append(kSep);
                    stringBuffer.append(f);
                    stringBuffer.append(kSep);
                    stringBuffer.append(f2);
                    stringBuffer.append(kSep);
                    stringBuffer.append(downloader.getActiveHostCount());
                    stringBuffer.append(kSep);
                    stringBuffer.append(downloader.getBusyHostCount());
                    stringBuffer.append(kSep);
                    stringBuffer.append(downloader.getPossibleHostCount());
                    stringBuffer.append(kSep);
                    stringBuffer.append(downloader.getQueuedHostCount());
                    stringBuffer.append(kSep);
                    stringBuffer.append(downloader.getFile() != null ? downloader.getFile().getAbsolutePath() : "");
                    stringBuffer.append(kSep);
                    stringBuffer.append(downloader.getActiveHostAddresses());
                    stringBuffer.append("\n");
                    Integer n4 = new Integer(downloader.hashCode());
                    if (stringBuffer.toString().equals(stateCache.get(n4))) {
                        stringBuffer = null;
                        break;
                    }
                    stateCache.put(n4, stringBuffer.toString());
                    break;
                }
                case 9: {
                    Uploader uploader = (Uploader)object;
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.hashCode());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getFileName());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getHost());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getGnutellaPort());
                    stringBuffer.append(kSep);
                    stringBuffer.append(AqEvent.fixUserAgent(uploader.getUserAgent()));
                    stringBuffer.append(kSep);
                    stringBuffer.append((Object)uploader.getState());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getFileSize());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getTotalAmountUploaded());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getFileDesc().getPath());
                    stringBuffer.append(kSep);
                    stringBuffer.append(NetworkUtils.isValidPort(uploader.getGnutellaPort()) ? 1 : 0);
                    stringBuffer.append("\n");
                    break;
                }
                case 10: {
                    Uploader uploader = (Uploader)object;
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.hashCode());
                    stringBuffer.append("\n");
                    stateCache.remove(new Integer(uploader.hashCode()));
                    break;
                }
                case 11: {
                    float f;
                    Uploader uploader = (Uploader)object;
                    try {
                        f = uploader.getMeasuredBandwidth() * 1024.0f;
                    }
                    catch (InsufficientDataException insufficientDataException) {
                        f = 0.0f;
                    }
                    float f3 = uploader.getAverageBandwidth() * 1024.0f;
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.hashCode());
                    stringBuffer.append(kSep);
                    stringBuffer.append((Object)uploader.getState());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getFileSize());
                    stringBuffer.append(kSep);
                    stringBuffer.append(uploader.getTotalAmountUploaded());
                    stringBuffer.append(kSep);
                    stringBuffer.append(f);
                    stringBuffer.append(kSep);
                    stringBuffer.append(f3);
                    stringBuffer.append("\n");
                    Integer n5 = new Integer(uploader.hashCode());
                    if (stringBuffer.toString().equals(stateCache.get(n5))) {
                        stringBuffer = null;
                        break;
                    }
                    stateCache.put(n5, stringBuffer.toString());
                    break;
                }
                case 13: {
                    FileDesc fileDesc = (FileDesc)object;
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(fileDesc.getSHA1Urn());
                    stringBuffer.append("\n");
                    break;
                }
                case 14: {
                    GUID gUID = (GUID)object;
                    if (!AqEventHandler.queries.containsKey(gUID)) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return;
                    }
                    Integer n6 = (Integer)AqEventHandler.queries.get(gUID);
                    stringBuffer.append(n);
                    stringBuffer.append(kSep);
                    stringBuffer.append(n6);
                    stringBuffer.append("\n");
                    break;
                }
                default: {
                    stringBuffer.append(n);
                    stringBuffer.append("\n");
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (stringBuffer != null) {
                AqMain.writeEvent(stringBuffer.toString());
            }
            return;
        }
    }
}

