/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cabos;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.settings.NetworkSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.UltrapeerSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.util.QueryUtils;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jp.sourceforge.cabos.AqEventHandler;
import jp.sourceforge.cabos.AqMain;
import jp.sourceforge.cabos.AqResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;
import org.limewire.io.NetworkUtils;
import org.limewire.util.FileUtils;

public class AqDispatcher {
    private static final Log LOG = LogFactory.getLog(AqDispatcher.class);
    private static int currentQueryIndex = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void dispatchCommand(List list) throws Throwable {
        block150: {
            int n;
            String string;
            String string2;
            block158: {
                Object object;
                block157: {
                    block156: {
                        block155: {
                            block154: {
                                int n2;
                                String string3;
                                block153: {
                                    block152: {
                                        block151: {
                                            string2 = (String)list.get(0);
                                            string = list.size() > 1 ? (String)list.get(1) : "";
                                            try {
                                                n = new Integer(string);
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                n = 0;
                                            }
                                            if (string2.equals("")) {
                                                return;
                                            }
                                            if (!string2.equals("query")) break block151;
                                            GUID gUID = new GUID(AqMain.core.getSearchServices().newQueryGUID());
                                            Integer n3 = new Integer(++currentQueryIndex);
                                            AqEventHandler.queries.put(gUID, n3);
                                            AqEventHandler.indices.put(n3, gUID);
                                            try {
                                                AqMain.core.getSearchServices().query(gUID.bytes(), QueryUtils.createQueryString(string), "", null);
                                            }
                                            catch (Throwable throwable) {
                                                LOG.error((Object)throwable);
                                            }
                                            break block150;
                                        }
                                        if (!string2.equals("queryFindMoreSources")) break block152;
                                        GUID gUID = new GUID(AqMain.core.getSearchServices().newQueryGUID());
                                        Integer n4 = new Integer(++currentQueryIndex);
                                        AqEventHandler.queries.put(gUID, n4);
                                        AqEventHandler.indices.put(n4, gUID);
                                        MediaType mediaType = null;
                                        String string4 = FileUtils.getFileExtension(string);
                                        if (string4 != null) {
                                            mediaType = MediaType.getMediaTypeForExtension(string4);
                                        }
                                        try {
                                            AqMain.core.getSearchServices().query(gUID.bytes(), QueryUtils.createQueryString(string, true), "", mediaType);
                                        }
                                        catch (Throwable throwable) {
                                            LOG.error((Object)throwable);
                                        }
                                        break block150;
                                    }
                                    if (!string2.equals("queryWhatIsNew")) break block153;
                                    GUID gUID = new GUID(AqMain.core.getSearchServices().newQueryGUID());
                                    Integer n5 = new Integer(++currentQueryIndex);
                                    AqEventHandler.queries.put(gUID, n5);
                                    AqEventHandler.indices.put(n5, gUID);
                                    AqMain.core.getSearchServices().queryWhatIsNew(gUID.bytes(), null);
                                    break block150;
                                }
                                if (!string2.equals("doBrowseHost")) break block154;
                                GUID gUID = new GUID(AqMain.core.getSearchServices().newQueryGUID());
                                Integer n6 = new Integer(++currentQueryIndex);
                                AqEventHandler.queries.put(gUID, n6);
                                AqEventHandler.indices.put(n6, gUID);
                                if (string.equals("localhost")) {
                                    try {
                                        string3 = NetworkUtils.getLocalAddress().getHostAddress();
                                    }
                                    catch (UnknownHostException unknownHostException) {
                                        string3 = NetworkUtils.ip2string(AqMain.core.getAcceptor().getAddress(false));
                                    }
                                    n2 = AqMain.core.getAcceptor().getPort(false);
                                } else {
                                    string3 = string;
                                    try {
                                        n2 = new Integer((String)list.get(2));
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        n2 = 6346;
                                    }
                                }
                                HostData hostData = (HostData)AqEventHandler.hosts.get(string3 + ":" + n2);
                                try {
                                    if (hostData != null) {
                                        AqMain.core.getSearchServices().doAsynchronousBrowseHost(new ConnectableImpl(string3, n2, false), gUID, new GUID(hostData.getClientGUID()), hostData.getPushProxies(), hostData.supportsFWTransfer());
                                        break block150;
                                    }
                                    AqMain.core.getSearchServices().doAsynchronousBrowseHost(new ConnectableImpl(string3, n2, false), gUID, null, null, false);
                                }
                                catch (Throwable throwable) {
                                    LOG.error((Object)throwable);
                                }
                                break block150;
                            }
                            if (!string2.equals("removeQuery")) break block155;
                            for (int i = 1; i < list.size(); ++i) {
                                Integer n7 = new Integer((String)list.get(i));
                                GUID gUID = (GUID)AqEventHandler.indices.get(n7);
                                AqMain.core.getSearchServices().stopQuery(gUID);
                                AqEventHandler.queries.remove(gUID);
                                AqEventHandler.indices.remove(n7);
                            }
                            break block150;
                        }
                        if (!string2.equals("removeAllQueries")) break block156;
                        Map map = AqEventHandler.queries;
                        synchronized (map) {
                            Iterator iterator = AqEventHandler.queries.keySet().iterator();
                            while (iterator.hasNext()) {
                                AqMain.core.getSearchServices().stopQuery((GUID)iterator.next());
                            }
                        }
                        AqEventHandler.queries.clear();
                        AqEventHandler.indices.clear();
                        AqEventHandler.responses.clear();
                        break block150;
                    }
                    if (!string2.equals("clearAllResults")) break block157;
                    for (int i = 1; i < list.size(); ++i) {
                        String string5 = (String)list.get(i) + ":";
                        Map map = AqEventHandler.responses;
                        synchronized (map) {
                            Iterator iterator = AqEventHandler.responses.keySet().iterator();
                            while (iterator.hasNext()) {
                                String string6 = (String)iterator.next();
                                if (!string6.startsWith(string5)) continue;
                                iterator.remove();
                            }
                            continue;
                        }
                    }
                    break block150;
                }
                if (!string2.equals("download")) break block158;
                HashSet<RemoteFileDesc> hashSet = new HashSet<RemoteFileDesc>();
                HashSet hashSet2 = new HashSet();
                GUID gUID = null;
                for (int i = 1; i < list.size(); ++i) {
                    object = (String)list.get(i);
                    AqResponse aqResponse = (AqResponse)AqEventHandler.responses.get(object);
                    gUID = new GUID(aqResponse.getData().getMessageGUID());
                    hashSet.add(aqResponse.getRFD());
                    hashSet2.addAll(aqResponse.getLocs());
                }
                RemoteFileDesc[] remoteFileDescArray = hashSet.toArray(new RemoteFileDesc[hashSet.size()]);
                object = null;
                for (int i = 0; i < remoteFileDescArray.length; ++i) {
                    RemoteFileDesc remoteFileDesc = remoteFileDescArray[i];
                    remoteFileDesc.setDownloading(true);
                    remoteFileDesc.setRetryAfter(0);
                    if (remoteFileDesc.getSHA1Urn() != null) {
                        object = remoteFileDesc;
                    }
                    hashSet2.remove(new IpPortImpl(remoteFileDesc.getHost(), remoteFileDesc.getPort()));
                }
                if (object == null) {
                    object = remoteFileDescArray[0];
                }
                LinkedList<RemoteFileDesc> linkedList = new LinkedList<RemoteFileDesc>();
                for (Object object2 : hashSet2) {
                    linkedList.add(AqMain.core.getRemoteFileDescFactory().createRemoteFileDesc((RemoteFileDesc)object, (IpPort)object2));
                }
                try {
                    AqMain.core.getDownloadServices().download(remoteFileDescArray, linkedList, gUID, true);
                }
                catch (SaveLocationException saveLocationException) {
                    Object object2;
                    LOG.error((Object)saveLocationException);
                    if (saveLocationException.getErrorCode() != 6) break block150;
                    object2 = new StringBuffer();
                    ((StringBuffer)object2).append(QueryUtils.ripExtension(object.getFileName()));
                    ((StringBuffer)object2).append(" [");
                    ((StringBuffer)object2).append(Integer.toHexString(object.hashCode()).toUpperCase());
                    ((StringBuffer)object2).append("].");
                    ((StringBuffer)object2).append(FileUtils.getFileExtension(object.getFileName()));
                    try {
                        AqMain.core.getDownloadServices().download(remoteFileDescArray, linkedList, gUID, true, SharingSettings.getSaveDirectory(), ((StringBuffer)object2).toString());
                        break block150;
                    }
                    catch (SaveLocationException saveLocationException2) {
                        LOG.error((Object)saveLocationException);
                    }
                }
                break block150;
            }
            if (string2.equals("pauseDownload")) {
                Iterator iterator = AqMain.core.getDownloadManager().getDownloads();
                while (iterator.hasNext()) {
                    Downloader downloader = (Downloader)iterator.next();
                    if (downloader.hashCode() != n) continue;
                    downloader.pause();
                }
            } else if (string2.equals("retryDownload")) {
                Iterator iterator = AqMain.core.getDownloadManager().getDownloads();
                while (iterator.hasNext()) {
                    Downloader downloader = (Downloader)iterator.next();
                    if (downloader.hashCode() != n) continue;
                    downloader.resume();
                }
            } else if (string2.equals("cancelDownload")) {
                Iterator iterator = AqMain.core.getDownloadManager().getDownloads();
                while (iterator.hasNext()) {
                    Downloader downloader = (Downloader)iterator.next();
                    if (downloader.hashCode() != n) continue;
                    downloader.cancel();
                }
            } else if (string2.equals("cancelUpload")) {
                Iterator iterator = AqMain.core.getUploadManager().getUploads();
                while (iterator.hasNext()) {
                    Uploader uploader = (Uploader)iterator.next();
                    if (uploader.hashCode() != n) continue;
                    uploader.stop();
                }
            } else if (string2.equals("closeConnection")) {
                int n8 = new Integer((String)list.get(2));
                for (RoutedConnection routedConnection : AqMain.core.getConnectionManager().getConnections()) {
                    if (!routedConnection.getAddress().equals(string) || routedConnection.getPort() != n8) continue;
                    AqMain.core.getConnectionServices().removeConnection(routedConnection);
                    break;
                }
            } else if (string2.equals("awakeConnection")) {
                AqMain.core.getConnectionServices().disconnect();
                AqMain.core.getConnectionServices().connect();
            } else if (string2.equals("addSpamFiles")) {
                ArrayList<RemoteFileDesc> arrayList = new ArrayList<RemoteFileDesc>();
                for (int i = 1; i < list.size(); ++i) {
                    String string7 = (String)list.get(i);
                    if (!AqEventHandler.responses.containsKey(string7)) continue;
                    arrayList.add(((AqResponse)AqEventHandler.responses.get(string7)).getRFD());
                }
                RemoteFileDesc[] remoteFileDescArray = arrayList.toArray(new RemoteFileDesc[arrayList.size()]);
                AqMain.core.getSpamManager().handleUserMarkedSpam(remoteFileDescArray);
            } else if (string2.equals("removeSpamFiles")) {
                ArrayList<RemoteFileDesc> arrayList = new ArrayList<RemoteFileDesc>();
                for (int i = 1; i < list.size(); ++i) {
                    String string8 = (String)list.get(i);
                    if (!AqEventHandler.responses.containsKey(string8)) continue;
                    arrayList.add(((AqResponse)AqEventHandler.responses.get(string8)).getRFD());
                }
                RemoteFileDesc[] remoteFileDescArray = arrayList.toArray(new RemoteFileDesc[arrayList.size()]);
                AqMain.core.getSpamManager().handleUserMarkedGood(remoteFileDescArray);
            } else if (string2.equals("clearSpamFiles")) {
                AqMain.core.getSpamManager().clearFilterData();
            } else if (string2.equals("setEnableUltrapeer")) {
                UltrapeerSettings.DISABLE_ULTRAPEER_MODE.setValue(n == 0);
            } else if (string2.equals("setAdultFilter")) {
                FilterSettings.FILTER_WHATS_NEW_ADULT.setValue(n == 1);
                FilterSettings.FILTER_ADULT.setValue(n == 1);
            } else if (string2.equals("setBannedIPs")) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 1; i < list.size(); ++i) {
                    String string9 = (String)list.get(i);
                    if (string9.length() == 0) continue;
                    arrayList.add(string9);
                }
                String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
                FilterSettings.BLACK_LISTED_IP_ADDRESSES.setValue(stringArray);
            } else if (string2.equals("setBannedKeywords")) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 1; i < list.size(); ++i) {
                    String string10 = (String)list.get(i);
                    if (string10.length() == 0) continue;
                    arrayList.add(string10);
                }
                String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
                FilterSettings.BANNED_WORDS.setValue(stringArray);
            } else if (string2.equals("applyFilterSettings")) {
                AqMain.core.getSpamServices().adjustSpamFilters();
            } else if (string2.equals("setMaxSimDownload")) {
                DownloadSettings.MAX_SIM_DOWNLOAD.setValue(n);
            } else if (string2.equals("setDownloadSpeed")) {
                DownloadSettings.DOWNLOAD_SPEED.setValue(n);
            } else if (string2.equals("applyDownloadSpeed")) {
                AqMain.core.getBandwidthManager().applyRate();
            } else if (string2.equals("setMaxUploads")) {
                UploadSettings.HARD_MAX_UPLOADS.setValue(n);
            } else if (string2.equals("setUploadsPerPerson")) {
                UploadSettings.UPLOADS_PER_PERSON.setValue(n);
            } else if (string2.equals("setUploadSpeed")) {
                UploadSettings.UPLOAD_SPEED.setValue(n);
            } else if (string2.equals("applyUploadSpeed")) {
                AqMain.core.getBandwidthManager().applyUploadRate();
            } else if (string2.equals("setAllowPartialSharing")) {
                SharingSettings.ALLOW_PARTIAL_SHARING.setValue(n == 1);
            } else if (string2.equals("setConnectionSpeed")) {
                ConnectionSettings.CONNECTION_SPEED.setValue(n);
            } else if (string2.equals("setPort")) {
                if (NetworkUtils.isValidPort(n)) {
                    NetworkSettings.PORT.setValue(n);
                } else {
                    NetworkSettings.PORT.revertToDefault();
                }
            } else if (string2.equals("setUPnPType")) {
                if (n == 0) {
                    ConnectionSettings.DISABLE_UPNP.setValue(false);
                } else if (n == 1) {
                    ConnectionSettings.FORCE_IP_ADDRESS.setValue(true);
                    ConnectionSettings.DISABLE_UPNP.setValue(true);
                } else if (n == 2) {
                    ConnectionSettings.FORCE_IP_ADDRESS.setValue(false);
                    ConnectionSettings.DISABLE_UPNP.setValue(true);
                }
            } else if (string2.equals("setUsesLocalePreferencing")) {
                ConnectionSettings.USE_LOCALE_PREF.setValue(n == 1);
            } else if (string2.equals("setProxyType")) {
                ConnectionSettings.CONNECTION_METHOD.setValue(n);
            } else if (string2.equals("setProxyServer")) {
                ConnectionSettings.PROXY_HOST.setValue(string);
            } else if (string2.equals("setProxyPort")) {
                ConnectionSettings.PROXY_PORT.setValue(n);
            } else if (string2.equals("setProxyUsername")) {
                ConnectionSettings.PROXY_USERNAME.setValue(string);
            } else if (string2.equals("setProxyPassword")) {
                ConnectionSettings.PROXY_PASS.setValue(string);
            } else if (string2.equals("setProxyPrivate")) {
                ConnectionSettings.USE_PROXY_FOR_PRIVATE.setValue(n == 1);
            } else if (string2.equals("setRequiresAuthentication")) {
                ConnectionSettings.PROXY_AUTHENTICATE.setValue(n == 1);
            } else if (string2.equals("setDirectories")) {
                HashSet<File> hashSet = new HashSet<File>();
                for (int i = 1; i < list.size(); ++i) {
                    File file;
                    String string11 = (String)list.get(i);
                    if (string11.equals("") || (file = new File(string11)) == null) continue;
                    hashSet.add(file);
                }
                SharingSettings.DIRECTORIES_TO_SHARE.setValue(hashSet);
            } else if (string2.equals("applyDirectories")) {
                AqMain.core.getFileManager().loadSettings();
            } else if (string2.equals("setSaveDirectory")) {
                try {
                    if (string.equals("")) {
                        SharingSettings.setSaveDirectory(SharingSettings.DEFAULT_SAVE_DIR);
                        break block150;
                    }
                    SharingSettings.setSaveDirectory(new File(string));
                }
                catch (IOException iOException) {
                    LOG.error((Object)iOException);
                }
            } else if (string2.equals("applySaveDirectory")) {
                File[] fileArray = SharingSettings.INCOMPLETE_DIRECTORY.getValue().listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    try {
                        AqMain.core.getDownloadServices().download(fileArray[i]);
                        continue;
                    }
                    catch (CantResumeException cantResumeException) {
                        continue;
                    }
                    catch (SaveLocationException saveLocationException) {
                        // empty catch block
                    }
                }
            } else if (string2.equals("setIncompletePurgeTime")) {
                SharingSettings.INCOMPLETE_PURGE_TIME.setValue(n);
            } else if (string2.equals("setAllowFreeloaders")) {
                if (n == 1) {
                    SharingSettings.FREELOADER_ALLOWED.setValue(100);
                } else {
                    SharingSettings.FREELOADER_ALLOWED.setValue(0);
                }
            } else if (string2.equals("setAllowCompleteSharing")) {
                SharingSettings.SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES.setValue(n == 1);
            } else if (string2.equals("setLanguage")) {
                if (string.equals("")) {
                    ApplicationSettings.LANGUAGE.revertToDefault();
                } else {
                    ApplicationSettings.LANGUAGE.setValue(string);
                }
            } else if (string2.equals("start")) {
                AqMain.start();
            } else if (string2.equals("shutdown")) {
                AqMain.shutdown();
            } else {
                LOG.warn((Object)("Unhandled command: " + list));
            }
        }
    }
}

