/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileEventListener;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.FileManagerController;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.FileManagerImpl;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.metadata.audio.AudioMetaData;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.NameValue;
import org.limewire.util.RPNParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class MetaFileManager
extends FileManagerImpl {
    private static final Log LOG = LogFactory.getLog(MetaFileManager.class);
    private Saver saver;

    @Inject
    public MetaFileManager(FileManagerController fileManagerController) {
        super(fileManagerController);
    }

    @Override
    public synchronized Response[] query(QueryRequest queryRequest) {
        Response[] responseArray;
        LimeXMLDocument limeXMLDocument;
        Response[] responseArray2 = super.query(queryRequest);
        if (this.shouldIncludeXMLInResponse(queryRequest) && (limeXMLDocument = queryRequest.getRichQuery()) != null && (responseArray = this.query(limeXMLDocument)) != null) {
            responseArray2 = this.union(responseArray2, responseArray, limeXMLDocument);
        }
        return responseArray2;
    }

    @Override
    protected boolean isValidXMLMatch(Response response, LimeXMLDocument limeXMLDocument) {
        return LimeXMLUtils.match(response.getDocument(), limeXMLDocument, true);
    }

    @Override
    protected boolean shouldIncludeXMLInResponse(QueryRequest queryRequest) {
        return queryRequest.desiresXMLResponses() || queryRequest.desiresOutOfBandReplies();
    }

    @Override
    protected void addXMLToResponse(Response response, FileDesc fileDesc) {
        List<LimeXMLDocument> list = fileDesc.getLimeXMLDocuments();
        if (list.size() == 0) {
            return;
        }
        if (list.size() == 1) {
            response.setDocument(list.get(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileChanged(File file) {
        RPNParser.StringLookup stringLookup;
        FileDesc fileDesc;
        if (LOG.isTraceEnabled()) {
            LOG.debug((Object)("File Changed: " + file));
        }
        if ((fileDesc = this.getFileDescForFile(file)) == null) {
            return;
        }
        final Long l = this.fileManagerController.getCreationTime(fileDesc.getSHA1Urn());
        List<LimeXMLDocument> list = fileDesc.getLimeXMLDocuments();
        if (LimeXMLUtils.isEditableFormat(file)) {
            try {
                stringLookup = this.fileManagerController.readDocument(file);
                list = this.resolveWriteableDocs(list, (LimeXMLDocument)stringLookup);
            }
            catch (IOException iOException) {
                list = Collections.emptyList();
            }
        }
        stringLookup = this.removeFileIfSharedOrStore(file, false);
        assert (fileDesc == stringLookup) : "wanted to remove: " + fileDesc + "\ndid remove: " + stringLookup;
        MetaFileManager metaFileManager = this;
        synchronized (metaFileManager) {
            _needRebuild = true;
        }
        this.addFileIfSharedOrStore(file, list, false, this._revision, new FileEventListener((FileDesc)stringLookup){
            final /* synthetic */ FileDesc val$removed;
            {
                this.val$removed = fileDesc;
            }

            public void handleFileEvent(FileManagerEvent fileManagerEvent) {
                FileManagerEvent fileManagerEvent2 = null;
                if (fileManagerEvent.isAddEvent() || fileManagerEvent.isAddStoreEvent()) {
                    FileDesc fileDesc = fileManagerEvent.getFileDescs()[0];
                    MetaFileManager.this.fileManagerController.fileChanged(fileDesc.getSHA1Urn(), l);
                    fileManagerEvent2 = new FileManagerEvent((FileManager)MetaFileManager.this, FileManagerEvent.Type.CHANGE_FILE, this.val$removed, fileDesc);
                } else {
                    fileManagerEvent2 = new FileManagerEvent((FileManager)MetaFileManager.this, FileManagerEvent.Type.REMOVE_FILE, this.val$removed);
                }
                MetaFileManager.this.dispatchFileEvent(fileManagerEvent2);
            }
        }, FileManagerImpl.AddType.ADD_SHARE);
    }

    private List<LimeXMLDocument> resolveWriteableDocs(List<LimeXMLDocument> list, LimeXMLDocument limeXMLDocument) {
        LimeXMLDocument limeXMLDocument2 = null;
        LimeXMLSchema limeXMLSchema = this.fileManagerController.getSchema("http://www.limewire.com/schemas/audio.xsd");
        for (LimeXMLDocument object2 : list) {
            if (object2.getSchema() != limeXMLSchema) continue;
            limeXMLDocument2 = object2;
            break;
        }
        if (limeXMLDocument.equals(limeXMLDocument2)) {
            return list;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(list);
        if (limeXMLDocument2 == null) {
            arrayList.add(limeXMLDocument);
            return arrayList;
        }
        arrayList.remove(limeXMLDocument2);
        List<NameValue<String>> list2 = limeXMLDocument2.getOrderedNameValueList();
        List<NameValue<String>> list3 = limeXMLDocument.getOrderedNameValueList();
        for (int i = 0; i < list2.size(); ++i) {
            NameValue<String> nameValue = list2.get(i);
            if (!AudioMetaData.isNonLimeAudioField(nameValue.getName())) continue;
            list3.add(nameValue);
        }
        limeXMLDocument2 = this.fileManagerController.createLimeXMLDocument(list3, "http://www.limewire.com/schemas/audio.xsd");
        arrayList.add(limeXMLDocument2);
        return arrayList;
    }

    @Override
    protected synchronized FileDesc removeFileIfShared(File file, boolean bl) {
        FileDesc fileDesc = super.removeFileIfShared(file, bl);
        if (fileDesc == null) {
            return null;
        }
        this.removeFileDesc(fileDesc, bl);
        return fileDesc;
    }

    @Override
    protected synchronized FileDesc removeStoreFile(File file, boolean bl) {
        FileDesc fileDesc = super.removeStoreFile(file, bl);
        if (fileDesc == null) {
            return null;
        }
        this.removeFileDesc(fileDesc, bl);
        return fileDesc;
    }

    private synchronized void removeFileDesc(FileDesc fileDesc, boolean bl) {
        List<LimeXMLDocument> list = fileDesc.getLimeXMLDocuments();
        LinkedList<String> linkedList = new LinkedList<String>();
        for (LimeXMLDocument object : list) {
            linkedList.add(object.getSchemaURI());
        }
        for (String string : linkedList) {
            LimeXMLReplyCollection limeXMLReplyCollection = this.fileManagerController.getReplyCollection(string);
            if (limeXMLReplyCollection == null) continue;
            limeXMLReplyCollection.removeDoc(fileDesc);
        }
        _needRebuild = true;
    }

    @Override
    protected void loadStarted(int n) {
        this.fileManagerController.setAnnotateEnabled(false);
        String[] stringArray = this.fileManagerController.getAvailableSchemaURIs();
        for (int i = 0; i < stringArray.length; ++i) {
            this.fileManagerController.add(stringArray[i], this.fileManagerController.createLimeXMLReplyCollection(stringArray[i]));
        }
        super.loadStarted(n);
    }

    @Override
    protected void loadFinished(int n) {
        if (this.saver == null) {
            this.saver = new Saver();
            this.fileManagerController.scheduleWithFixedDelay(this.saver, 60000, 60000, TimeUnit.MILLISECONDS);
        }
        Collection<LimeXMLReplyCollection> collection = this.fileManagerController.getCollections();
        for (LimeXMLReplyCollection limeXMLReplyCollection : collection) {
            limeXMLReplyCollection.loadFinished();
        }
        this.fileManagerController.setAnnotateEnabled(true);
        super.loadFinished(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadFile(FileDesc fileDesc, File file, List<? extends LimeXMLDocument> list, Set<? extends URN> set) {
        super.loadFile(fileDesc, file, list, set);
        boolean bl = false;
        Collection<LimeXMLReplyCollection> collection = this.fileManagerController.getCollections();
        for (LimeXMLReplyCollection limeXMLReplyCollection : collection) {
            bl |= limeXMLReplyCollection.initialize(fileDesc, list) != null;
        }
        for (LimeXMLReplyCollection limeXMLReplyCollection : collection) {
            bl |= limeXMLReplyCollection.createIfNecessary(fileDesc) != null;
        }
        if (bl) {
            MetaFileManager metaFileManager = this;
            synchronized (metaFileManager) {
                _needRebuild = true;
            }
        }
    }

    @Override
    protected void save() {
        if (this.isLoadFinished()) {
            Collection<LimeXMLReplyCollection> collection = this.fileManagerController.getCollections();
            for (LimeXMLReplyCollection limeXMLReplyCollection : collection) {
                limeXMLReplyCollection.writeMapToDisk();
            }
        }
        super.save();
    }

    private Response[] union(Response[] responseArray, Response[] responseArray2, LimeXMLDocument limeXMLDocument) {
        int n;
        if (responseArray == null || responseArray.length == 0) {
            return responseArray2;
        }
        if (responseArray2 == null || responseArray2.length == 0) {
            return responseArray;
        }
        HashSet<Response> hashSet = new HashSet<Response>();
        for (n = 0; n < responseArray2.length; ++n) {
            hashSet.add(responseArray2[n]);
        }
        for (n = 0; n < responseArray.length; ++n) {
            hashSet.add(responseArray[n]);
        }
        Response[] responseArray3 = new Response[hashSet.size()];
        responseArray3 = hashSet.toArray(responseArray3);
        return responseArray3;
    }

    @Override
    protected void buildQRT() {
        super.buildQRT();
        for (String string : this.getXMLKeyWords()) {
            _queryRouteTable.add(string);
        }
        for (String string : this.getXMLIndivisibleKeyWords()) {
            _queryRouteTable.addIndivisible(string);
        }
    }

    private List<String> getXMLKeyWords() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.fileManagerController.getAvailableSchemaURIs();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            LimeXMLReplyCollection limeXMLReplyCollection = this.fileManagerController.getReplyCollection(stringArray[i]);
            if (limeXMLReplyCollection == null) continue;
            arrayList.addAll(limeXMLReplyCollection.getKeyWords());
        }
        return arrayList;
    }

    private List<String> getXMLIndivisibleKeyWords() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.fileManagerController.getAvailableSchemaURIs();
        for (int i = 0; i < stringArray.length; ++i) {
            LimeXMLReplyCollection limeXMLReplyCollection;
            if (stringArray[i] != null) {
                arrayList.add(stringArray[i]);
            }
            if ((limeXMLReplyCollection = this.fileManagerController.getReplyCollection(stringArray[i])) == null) continue;
            arrayList.addAll(limeXMLReplyCollection.getKeyWordsIndivisible());
        }
        return arrayList;
    }

    private Response[] query(LimeXMLDocument limeXMLDocument) {
        String string = limeXMLDocument.getSchemaURI();
        LimeXMLReplyCollection limeXMLReplyCollection = this.fileManagerController.getReplyCollection(string);
        if (limeXMLReplyCollection == null) {
            return null;
        }
        List<LimeXMLDocument> list = limeXMLReplyCollection.getMatchingReplies(limeXMLDocument);
        int n = list.size();
        if (n == 0) {
            return null;
        }
        Response[] responseArray = new Response[n];
        int n2 = 0;
        for (LimeXMLDocument limeXMLDocument2 : list) {
            File file = limeXMLDocument2.getIdentifier();
            Response response = null;
            if (file == null) {
                response = this.fileManagerController.createPureMetadataResponse();
            } else {
                FileDesc fileDesc = this.getFileDescForFile(file);
                if (fileDesc == null || fileDesc instanceof IncompleteFileDesc || this.isStoreFileLoaded(file)) continue;
                response = this.fileManagerController.createResponse(fileDesc);
                fileDesc.incrementHitCount();
                this.fileManagerController.handleSharedFileUpdate(fileDesc.getFile());
            }
            response.setDocument(limeXMLDocument2);
            responseArray[n2] = response;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        if (n2 < n) {
            Response[] responseArray2 = new Response[n2];
            System.arraycopy(responseArray, 0, responseArray2, 0, n2);
            responseArray = responseArray2;
        }
        return responseArray;
    }

    private class Saver
    implements Runnable {
        private Saver() {
        }

        public void run() {
            if (!MetaFileManager.this.shutdown && MetaFileManager.this.isLoadFinished()) {
                MetaFileManager.this.save();
            }
        }
    }
}

