/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.licenses.LicenseFactory;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class LimeXMLDocumentFactoryImpl
implements LimeXMLDocumentFactory {
    private final LicenseFactory licenseFactory;
    private final Provider<LimeXMLSchemaRepository> limeXMLSchemaRepository;

    @Inject
    public LimeXMLDocumentFactoryImpl(LicenseFactory licenseFactory, Provider<LimeXMLSchemaRepository> provider) {
        this.licenseFactory = licenseFactory;
        this.limeXMLSchemaRepository = provider;
    }

    @Override
    public LimeXMLDocument createLimeXMLDocument(String string) throws SAXException, SchemaNotFoundException, IOException {
        return new LimeXMLDocument(string, this.licenseFactory, this.limeXMLSchemaRepository);
    }

    @Override
    public LimeXMLDocument createLimeXMLDocument(Map<String, String> map, String string, String string2) throws IOException {
        return new LimeXMLDocument(map, string, string2, this.licenseFactory, this.limeXMLSchemaRepository);
    }

    @Override
    public LimeXMLDocument createLimeXMLDocument(Collection<? extends Map.Entry<String, String>> collection, String string) {
        return new LimeXMLDocument(collection, string, this.licenseFactory, this.limeXMLSchemaRepository);
    }
}

