/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.Portable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import org.limewire.util.FileUtils;

public class PortableImpl
implements Portable {
    static final String PORTABLE_FILE = "portable.props";
    static final String PROGRAM_FILE = "limewire.props";
    static final String SOURCE_KEY = "SOURCE";
    static final String SETTINGS_KEY = "SETTINGS";
    static final String DEFAULT_SETTINGS_VALUE = "Settings";
    static final String KEY_PREFIX = "PORTABLE_PATH_";
    private File path;
    private IOException exception;

    public PortableImpl() {
        try {
            Serializable serializable;
            File file = new File(PORTABLE_FILE);
            if (!file.exists()) {
                return;
            }
            Properties properties = FileUtils.readProperties(file);
            this.path = FileUtils.resolveSpecialPath(properties.getProperty(SETTINGS_KEY));
            if (properties.containsKey(SOURCE_KEY)) {
                serializable = FileUtils.resolveSpecialPath(properties.getProperty(SOURCE_KEY));
                if (!this.path.exists()) {
                    FileUtils.copyDirectory((File)serializable, this.path);
                }
            }
            serializable = new Properties();
            File file2 = new File(this.path, PROGRAM_FILE);
            if (file2.exists()) {
                serializable = FileUtils.readProperties(file2);
            }
            boolean bl = false;
            for (String string : properties.keySet()) {
                String string2;
                if (!string.startsWith(KEY_PREFIX) || (string2 = string.substring(KEY_PREFIX.length(), string.length()).trim()).length() == 0) continue;
                String string3 = FileUtils.resolveSpecialPath(properties.getProperty(string)).getPath();
                ((Properties)serializable).setProperty(string2, string3);
                bl = true;
            }
            if (bl) {
                FileUtils.makeFolder(this.path);
                FileUtils.writeProperties(file2, (Properties)serializable);
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public boolean isPortable() {
        return this.path != null || this.exception != null;
    }

    public File getSettingsLocation() {
        return this.path;
    }

    public static File getDefaultSettingsLocation() throws IOException {
        return FileUtils.resolveSpecialPath(DEFAULT_SETTINGS_VALUE);
    }
}

