/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import org.limewire.service.ErrorService;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;

public class MacOSXUtils {
    private static final String APP_NAME = "LimeWire.app";

    private MacOSXUtils() {
    }

    public static void setLoginStatus(boolean bl) {
        MacOSXUtils.SetLoginStatusNative(bl);
    }

    public static String getUserName() {
        return MacOSXUtils.GetCurrentFullUserName();
    }

    public static String getAppDir() {
        String string = "/Applications/LimeWire/";
        String string2 = CommonUtils.getCurrentDirectory().getPath();
        int n = string2.indexOf(APP_NAME);
        if (n != -1) {
            string = string2.substring(0, n);
        }
        return string + APP_NAME;
    }

    private static final native String GetCurrentFullUserName();

    private static final native void SetLoginStatusNative(boolean var0);

    static {
        if (OSUtils.isMacOSX105()) {
            try {
                System.loadLibrary("MacOSXUtilsLeopard");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                ErrorService.error(unsatisfiedLinkError);
            }
        } else if (OSUtils.isAnyMac()) {
            try {
                System.loadLibrary("MacOSXUtilsTiger");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                ErrorService.error(unsatisfiedLinkError);
            }
        }
    }
}

