/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.uploader.UploadSlotListener;
import com.limegroup.gnutella.uploader.UploadSlotManager;
import com.limegroup.gnutella.uploader.UploadSlotUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.MultiIterable;
import org.limewire.collection.NumericBuffer;
import org.limewire.collection.QueueCounter;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class UploadSlotManagerImpl
implements UploadSlotManager {
    private static final Log LOG = LogFactory.getLog(UploadSlotManager.class);
    private static final int BT_SEED = 0;
    private static final int HTTP = 1;
    private static final int HIGH = 2;
    private static final float MINIMUM_UPLOAD_SPEED = 3.0f;
    @InspectionPoint(value="active uploads")
    private final CountingList<UploadSlotRequest> active;
    @InspectionPoint(value="queued uploads")
    private final CountingList<HTTPSlotRequest> queued;
    @InspectionPoint(value="queued resumable uploads")
    private final CountingList<BTSlotRequest> queuedResumable;
    private final MultiIterable<UploadSlotRequest> allRequests;
    private final NumericBuffer<Float> bandwidth = new NumericBuffer(10);
    private float sessionAverage;
    private int numMeasures;

    @Inject
    public UploadSlotManagerImpl() {
        this.active = new CountingList();
        this.queued = new CountingList();
        this.queuedResumable = new CountingList();
        this.allRequests = new MultiIterable<BTSlotRequest>((Iterable<BTSlotRequest>)this.active, (Iterable<BTSlotRequest>)this.queued, (Iterable<BTSlotRequest>)this.queuedResumable);
    }

    @Override
    public int pollForSlot(UploadSlotUser uploadSlotUser, boolean bl, boolean bl2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(uploadSlotUser + " polling for slot, queuable " + bl));
        }
        return this.requestSlot(new HTTPSlotRequest(uploadSlotUser, bl, bl2));
    }

    @Override
    public int requestSlot(UploadSlotListener uploadSlotListener, boolean bl) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(uploadSlotListener + " requesting slot, high priority " + bl));
        }
        return this.requestSlot(new BTSlotRequest(uploadSlotListener, bl));
    }

    private synchronized int requestSlot(UploadSlotRequest uploadSlotRequest) {
        boolean bl = this.existActiveHigherPriority(uploadSlotRequest.getPriority());
        int n = this.positionInQueue(uploadSlotRequest);
        int n2 = this.getPreemptible(uploadSlotRequest.getPriority());
        if (bl || !this.hasFreeSlot(this.active.size() + Math.max(0, n) - n2)) {
            if (!uploadSlotRequest.isQueuable()) {
                return -1;
            }
            if (n >= 0) {
                return ++n;
            }
            return this.queueRequest(uploadSlotRequest);
        }
        if (n2 > 0) {
            this.killPreemptible(uploadSlotRequest.getPriority());
        }
        if (n > -1) {
            this.removeIfQueued(uploadSlotRequest.getUser());
        }
        this.addActiveRequest(uploadSlotRequest);
        return 0;
    }

    private int positionInQueue(UploadSlotRequest uploadSlotRequest) {
        return this.getQueue(uploadSlotRequest.getUser()).indexOf(uploadSlotRequest);
    }

    @Override
    public synchronized int positionInQueue(UploadSlotUser uploadSlotUser) {
        List<? extends UploadSlotRequest> list = this.getQueue(uploadSlotUser);
        for (int i = 0; i < list.size(); ++i) {
            UploadSlotRequest uploadSlotRequest = list.get(i);
            if (uploadSlotRequest.getUser() != uploadSlotUser) continue;
            return i;
        }
        return -1;
    }

    private List<? extends UploadSlotRequest> getQueue(UploadSlotUser uploadSlotUser) {
        return uploadSlotUser instanceof UploadSlotListener ? this.queuedResumable : this.queued;
    }

    private boolean existActiveHigherPriority(int n) {
        UploadSlotRequest uploadSlotRequest;
        if (n == 2) {
            return false;
        }
        return !this.active.isEmpty() && (uploadSlotRequest = (UploadSlotRequest)this.active.get(0)).getPriority() > n;
    }

    private int getPreemptible(int n) {
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        for (int i = this.active.size() - 1; i >= 0; --i) {
            UploadSlotRequest uploadSlotRequest = (UploadSlotRequest)this.active.get(i);
            if (uploadSlotRequest.getPriority() >= n || !uploadSlotRequest.isPreemptible()) continue;
            ++n2;
        }
        return n2;
    }

    private void killPreemptible(int n) {
        for (int i = this.active.size() - 1; i >= 0; --i) {
            UploadSlotRequest uploadSlotRequest = (UploadSlotRequest)this.active.get(i);
            if (uploadSlotRequest.getPriority() >= n || !uploadSlotRequest.isPreemptible()) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("freeing slot from " + uploadSlotRequest.getUser()));
            }
            this.active.remove(i);
            uploadSlotRequest.getUser().releaseSlot();
        }
    }

    @Override
    public synchronized boolean hasHTTPSlot(int n) {
        if (this.existActiveHigherPriority(1)) {
            return false;
        }
        return this.hasFreeSlot(n);
    }

    @Override
    public synchronized boolean hasHTTPSlotForMeta(int n) {
        return this.hasFreeSlot(n);
    }

    private boolean hasFreeSlot(int n) {
        if (n >= UploadSettings.HARD_MAX_UPLOADS.getValue()) {
            return false;
        }
        if (n < UploadSettings.SOFT_MAX_UPLOADS.getValue()) {
            return true;
        }
        float f = 0.0f;
        for (UploadSlotRequest uploadSlotRequest : this.active) {
            UploadSlotUser uploadSlotUser = uploadSlotRequest.getUser();
            float f2 = 0.0f;
            uploadSlotUser.measureBandwidth();
            try {
                f2 = uploadSlotUser.getMeasuredBandwidth();
            }
            catch (InsufficientDataException insufficientDataException) {
                // empty catch block
            }
            if (!((f = Math.max(f, f2)) > 3.0f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void measureBandwidth() {
        float f = this.getTotalBandwidth();
        this.sessionAverage = (this.sessionAverage * (float)this.numMeasures + f) / (float)(++this.numMeasures);
        this.bandwidth.add(Float.valueOf(f));
    }

    @Override
    public synchronized float getMeasuredBandwidth() throws InsufficientDataException {
        if (this.bandwidth.size() < this.bandwidth.getCapacity()) {
            throw new InsufficientDataException();
        }
        return this.bandwidth.average().floatValue();
    }

    @Override
    public synchronized float getAverageBandwidth() {
        return this.sessionAverage;
    }

    private float getTotalBandwidth() {
        float f = 0.0f;
        for (UploadSlotRequest uploadSlotRequest : this.active) {
            UploadSlotUser uploadSlotUser = uploadSlotRequest.getUser();
            uploadSlotUser.measureBandwidth();
            try {
                f += uploadSlotUser.getMeasuredBandwidth();
            }
            catch (InsufficientDataException insufficientDataException) {}
        }
        return f;
    }

    private <Request_t extends UploadSlotRequest> int queueRequest(Request_t Request_t) {
        List<? extends UploadSlotRequest> list = this.getQueue(((UploadSlotRequest)Request_t).user);
        if (list.size() == UploadSettings.UPLOAD_QUEUE_SIZE.getValue()) {
            return -1;
        }
        list.add(Request_t);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("queued " + Request_t.getUser() + " at position " + list.size()));
        }
        return list.size();
    }

    private void addActiveRequest(UploadSlotRequest uploadSlotRequest) {
        UploadSlotRequest uploadSlotRequest2;
        int n;
        for (n = 0; n < this.active.size() && (uploadSlotRequest2 = (UploadSlotRequest)this.active.get(n)).getPriority() >= uploadSlotRequest.getPriority(); ++n) {
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("added active request " + uploadSlotRequest.getUser() + " at position " + n));
        }
        this.active.add(n, uploadSlotRequest);
    }

    @Override
    public synchronized void cancelRequest(UploadSlotUser uploadSlotUser) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(uploadSlotUser + " cancelling request"));
        }
        if (!this.removeIfQueued(uploadSlotUser)) {
            this.requestDone(uploadSlotUser);
        }
    }

    private boolean removeIfQueued(UploadSlotUser uploadSlotUser) {
        List<? extends UploadSlotRequest> list = this.getQueue(uploadSlotUser);
        Iterator<? extends UploadSlotRequest> iterator = list.iterator();
        while (iterator.hasNext()) {
            UploadSlotRequest uploadSlotRequest = iterator.next();
            if (uploadSlotRequest.getUser() != uploadSlotUser) continue;
            iterator.remove();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("remove queued request by " + uploadSlotUser));
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized void requestDone(UploadSlotUser uploadSlotUser) {
        Iterator iterator = this.active.iterator();
        while (iterator.hasNext()) {
            UploadSlotRequest uploadSlotRequest = (UploadSlotRequest)iterator.next();
            if (uploadSlotRequest.getUser() != uploadSlotUser) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("request finished for " + uploadSlotUser));
            }
            iterator.remove();
            this.resumeQueued();
            return;
        }
    }

    private void resumeQueued() {
        if (this.existActiveHigherPriority(0)) {
            return;
        }
        Iterator iterator = this.queuedResumable.iterator();
        while (iterator.hasNext() && this.hasFreeSlot(this.active.size())) {
            BTSlotRequest bTSlotRequest = (BTSlotRequest)iterator.next();
            iterator.remove();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("resuming queued request " + bTSlotRequest.getUser()));
            }
            this.active.add(bTSlotRequest);
            bTSlotRequest.getListener().slotAvailable();
        }
    }

    @Override
    public synchronized int getNumActive() {
        return this.active.size();
    }

    @Override
    public synchronized int getNumQueued() {
        return this.queued.size();
    }

    @Override
    public synchronized int getNumQueuedResumable() {
        return this.queuedResumable.size();
    }

    @Override
    public synchronized int getNumUsersForHost(String string) {
        int n = 0;
        for (UploadSlotRequest uploadSlotRequest : this.allRequests) {
            if (!string.equals(uploadSlotRequest.getUser().getHost())) continue;
            ++n;
        }
        return n;
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("active:");
        this.appendPriorities(this.active, stringBuilder);
        stringBuilder.append("queued:");
        this.appendPriorities(this.queued, stringBuilder);
        stringBuilder.append("resumable:");
        this.appendPriorities(this.queuedResumable, stringBuilder);
        stringBuilder.append("bw now:").append(this.getTotalBandwidth());
        stringBuilder.append(" session avg:").append(this.sessionAverage);
        return stringBuilder.toString();
    }

    private void appendPriorities(List<? extends UploadSlotRequest> list, StringBuilder stringBuilder) {
        int[] nArray = this.countPriorities(list);
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append(i).append(":").append(nArray[i]).append(" ");
        }
    }

    private int[] countPriorities(List<? extends UploadSlotRequest> list) {
        int[] nArray = new int[3];
        for (UploadSlotRequest uploadSlotRequest : list) {
            int n = uploadSlotRequest.getPriority();
            nArray[n] = nArray[n] + 1;
        }
        return nArray;
    }

    @Override
    public synchronized void cleanup() {
        this.active.clear();
        this.queued.clear();
        this.queuedResumable.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CountingList<E>
    extends ArrayList<E>
    implements Inspectable {
        private final QueueCounter counter = new QueueCounter(10);
        private volatile int maxSize;
        private volatile long lastMod;

        private CountingList() {
        }

        @Override
        public Object inspect() {
            HashMap<String, Number> hashMap = new HashMap<String, Number>();
            hashMap.put("avg", this.counter.getAverageSize());
            hashMap.put("max", this.maxSize);
            hashMap.put("cur", this.size());
            hashMap.put("mod", System.currentTimeMillis() - this.lastMod);
            return hashMap;
        }

        @Override
        public boolean add(E e) {
            this.lastMod = System.currentTimeMillis();
            this.counter.recordArrival();
            this.maxSize = Math.max(this.maxSize, 1 + this.size());
            return super.add(e);
        }

        @Override
        public void add(int n, E e) {
            this.lastMod = System.currentTimeMillis();
            this.counter.recordArrival();
            this.maxSize = Math.max(this.maxSize, 1 + this.size());
            super.add(n, e);
        }

        @Override
        public E remove(int n) {
            this.lastMod = System.currentTimeMillis();
            this.counter.recordDeparture();
            return super.remove(n);
        }

        @Override
        public boolean remove(Object object) {
            boolean bl = super.remove(object);
            if (bl) {
                this.lastMod = System.currentTimeMillis();
                this.counter.recordDeparture();
            }
            return bl;
        }
    }

    private class BTSlotRequest
    extends UploadSlotRequest {
        BTSlotRequest(UploadSlotListener uploadSlotListener, boolean bl) {
            super(uploadSlotListener, !bl, bl ? 2 : 0);
        }

        UploadSlotListener getListener() {
            return (UploadSlotListener)this.getUser();
        }

        boolean isQueuable() {
            return this.getPriority() == 0;
        }
    }

    private class HTTPSlotRequest
    extends UploadSlotRequest {
        private final boolean queuable;

        HTTPSlotRequest(UploadSlotUser uploadSlotUser, boolean bl, boolean bl2) {
            super(uploadSlotUser, false, bl2 ? 2 : 1);
            this.queuable = bl;
        }

        boolean isQueuable() {
            return this.queuable;
        }
    }

    private abstract class UploadSlotRequest {
        private final UploadSlotUser user;
        private final boolean preempt;
        private final int priority;

        boolean isPreemptible() {
            return this.preempt;
        }

        int getPriority() {
            return this.priority;
        }

        UploadSlotUser getUser() {
            return this.user;
        }

        abstract boolean isQueuable();

        protected UploadSlotRequest(UploadSlotUser uploadSlotUser, boolean bl, int n) {
            this.user = uploadSlotUser;
            this.preempt = bl;
            this.priority = n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof UploadSlotRequest)) {
                return false;
            }
            UploadSlotRequest uploadSlotRequest = (UploadSlotRequest)object;
            return this.getUser() == uploadSlotRequest.getUser();
        }

        public String toString() {
            return this.getClass().getName() + "[user=" + this.user + "]";
        }
    }
}

