/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.tigertree.HashTreeWriteHandler;
import com.limegroup.gnutella.tigertree.ThexWriter;
import com.limegroup.gnutella.uploader.HTTPUploader;
import java.io.IOException;
import java.nio.channels.Channel;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.ContentEncoderChannel;
import org.apache.http.nio.IOControl;
import org.limewire.http.entity.AbstractProducingNHttpEntity;
import org.limewire.nio.NBThrottle;

public class THEXResponseEntity
extends AbstractProducingNHttpEntity {
    private static final NBThrottle THROTTLE = new NBThrottle(true, UploadSettings.THEX_UPLOAD_SPEED.getValue());
    private HTTPUploader uploader;
    private final HashTreeWriteHandler tigerWriteHandler;
    private ThexWriter writer;
    private long size;

    public THEXResponseEntity(HTTPUploader hTTPUploader, HashTreeWriteHandler hashTreeWriteHandler, long l) {
        this.uploader = hTTPUploader;
        this.tigerWriteHandler = hashTreeWriteHandler;
        this.size = l;
        this.setContentType(hashTreeWriteHandler.getOutputType());
    }

    public long getContentLength() {
        return this.size;
    }

    public void initialize(ContentEncoder contentEncoder, IOControl iOControl) throws IOException {
        this.writer = this.tigerWriteHandler.createAsyncWriter();
        THROTTLE.setRate(UploadSettings.THEX_UPLOAD_SPEED.getValue());
        this.uploader.getSession().getIOSession().setThrottle(THROTTLE);
    }

    public boolean writeContent(ContentEncoder contentEncoder, IOControl iOControl) throws IOException {
        boolean bl = this.writer.process((Channel)new ContentEncoderChannel(contentEncoder), null);
        this.uploader.setAmountUploaded(this.writer.getAmountProcessed());
        this.activateTimeout();
        return bl;
    }

    public void finish() {
        this.deactivateTimeout();
        this.writer = null;
    }

    public void timeout() {
        this.uploader.stop();
    }
}

