/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.uploader.HTTPHeaderUtils;
import com.limegroup.gnutella.uploader.HTTPUploader;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.entity.ConsumingNHttpEntity;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.SimpleNHttpRequestHandler;
import org.apache.http.protocol.HttpContext;

public class LimitReachedRequestHandler
extends SimpleNHttpRequestHandler {
    public static final String RETRY_AFTER_VALIDATING = "20";
    public static final int RETRY_AFTER_TIME = 900;
    private static final String NO_ALT_LOCS_RETRY_AFTER = "1200";
    private static final String NORMAL_RETRY_AFTER = "900";
    private static final String ERROR_MESSAGE = "Server busy.  Too many active uploads.";
    private static final String VALIDATING_MSG = "Validating file.  One moment please.";
    private final boolean validating;
    private final HTTPUploader uploader;
    private final FileDesc fd;
    private final HTTPHeaderUtils httpHeaderUtils;
    private final AltLocManager altLocManager;

    LimitReachedRequestHandler(HTTPUploader hTTPUploader, HTTPHeaderUtils hTTPHeaderUtils, AltLocManager altLocManager) {
        this.uploader = hTTPUploader;
        this.validating = false;
        this.fd = hTTPUploader.getFileDesc();
        this.httpHeaderUtils = hTTPHeaderUtils;
        this.altLocManager = altLocManager;
    }

    public ConsumingNHttpEntity entityRequest(HttpEntityEnclosingRequest httpEntityEnclosingRequest, HttpContext httpContext) throws HttpException, IOException {
        return null;
    }

    public void handle(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        this.httpHeaderUtils.addProxyHeader(httpResponse);
        this.httpHeaderUtils.addAltLocationsHeader(httpResponse, this.uploader.getAltLocTracker(), this.altLocManager);
        String string = ERROR_MESSAGE;
        if (this.fd != null) {
            URN uRN = this.fd.getSHA1Urn();
            if (this.validating) {
                string = VALIDATING_MSG;
                httpResponse.addHeader(HTTPHeaderName.RETRY_AFTER.create(RETRY_AFTER_VALIDATING));
            } else if (uRN != null) {
                String string2 = !this.altLocManager.hasAltlocs(uRN) ? NO_ALT_LOCS_RETRY_AFTER : NORMAL_RETRY_AFTER;
                httpResponse.addHeader(HTTPHeaderName.RETRY_AFTER.create(string2));
                this.httpHeaderUtils.addRangeHeader(httpResponse, this.uploader, this.fd);
            } else {
                httpResponse.addHeader(HTTPHeaderName.RETRY_AFTER.create(NO_ALT_LOCS_RETRY_AFTER));
            }
        }
        this.uploader.setState(Uploader.UploadStatus.LIMIT_REACHED);
        httpResponse.setStatusCode(503);
        httpResponse.setEntity((HttpEntity)new NStringEntity(string));
    }
}

