/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.google.inject.Inject;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PushRequestImpl;
import com.limegroup.gnutella.uploader.HTTPUploadSessionManager;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.UploadType;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.entity.ConsumingNHttpEntity;
import org.apache.http.nio.protocol.SimpleNHttpRequestHandler;
import org.apache.http.protocol.HttpContext;
import org.limewire.io.NetworkUtils;
import org.limewire.util.Base32;

public class HttpPushRequestHandler
extends SimpleNHttpRequestHandler {
    private static final Log LOG = LogFactory.getLog(HttpPushRequestHandler.class);
    public static final String P_SERVER_ID = "ServerId";
    public static final String P_GUID = "guid";
    public static final String P_FILE = "file";
    public static final String P_TLS = "tls";
    private HTTPUploadSessionManager sessionManager;
    private MessageRouter messageRouter;

    @Inject
    HttpPushRequestHandler(HTTPUploadSessionManager hTTPUploadSessionManager, MessageRouter messageRouter) {
        if (hTTPUploadSessionManager == null) {
            throw new IllegalArgumentException();
        }
        if (messageRouter == null) {
            throw new IllegalArgumentException();
        }
        this.sessionManager = hTTPUploadSessionManager;
        this.messageRouter = messageRouter;
    }

    public ConsumingNHttpEntity entityRequest(HttpEntityEnclosingRequest httpEntityEnclosingRequest, HttpContext httpContext) throws HttpException, IOException {
        return null;
    }

    public void handle(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        HTTPUploader hTTPUploader = null;
        HttpPushRequest httpPushRequest = this.parsePushRequest(httpRequest);
        if (httpPushRequest == null) {
            httpResponse.setStatusCode(400);
            hTTPUploader = this.sessionManager.getOrCreateUploader(httpRequest, httpContext, UploadType.MALFORMED_REQUEST, "Malformed Request");
            hTTPUploader.setState(Uploader.UploadStatus.MALFORMED_REQUEST);
        } else {
            hTTPUploader = this.sessionManager.getOrCreateUploader(httpRequest, httpContext, UploadType.PUSH_PROXY, httpPushRequest.clientGUID);
            hTTPUploader.setState(Uploader.UploadStatus.PUSH_PROXY);
            if (!this.sendRequest(httpPushRequest)) {
                httpResponse.setStatusCode(410);
                httpResponse.setReasonPhrase("Servent not connected");
            } else {
                httpResponse.setStatusCode(202);
                httpResponse.setReasonPhrase("Message sent");
            }
        }
        this.sessionManager.sendResponse(hTTPUploader, httpResponse);
    }

    private HttpPushRequest parsePushRequest(HttpRequest httpRequest) {
        Object object;
        String string;
        String string2 = httpRequest.getRequestLine().getUri();
        int n = string2.indexOf(63);
        if (n == -1) {
            return null;
        }
        String string3 = string2.substring(n + 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "=&");
        if (stringTokenizer.countTokens() < 2 || stringTokenizer.countTokens() % 2 != 0) {
            return null;
        }
        Object object2 = null;
        int n2 = 0;
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            object = stringTokenizer.nextToken();
            if (string.equalsIgnoreCase(P_SERVER_ID)) {
                if (object2 != null) {
                    return null;
                }
                byte[] byArray = Base32.decode((String)object);
                if (byArray.length != 16) {
                    return null;
                }
                object2 = new GUID(byArray).toHexString();
                continue;
            }
            if (string.equalsIgnoreCase(P_GUID)) {
                if (object2 != null || ((String)object).length() != 32) {
                    return null;
                }
                object2 = object;
                continue;
            }
            if (string.equalsIgnoreCase(P_FILE)) {
                if (n2 != 0) {
                    return null;
                }
                try {
                    n2 = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
                if (n2 >= 0) continue;
                return null;
            }
            if (!string.equalsIgnoreCase(P_TLS)) continue;
            bl = "true".equalsIgnoreCase((String)object);
        }
        if (object2 == null) {
            return null;
        }
        string = httpRequest.getLastHeader(HTTPHeaderName.NODE.httpStringValue());
        if (string == null) {
            LOG.info((Object)"Missing X-Node header push proxy request");
            return null;
        }
        object = this.getNodeAddress(string.getValue());
        if (object == null) {
            LOG.info((Object)("Invalid node address for push proxy request: " + string.getValue()));
            return null;
        }
        return new HttpPushRequest((String)object2, n2, (InetSocketAddress)object, bl);
    }

    private InetSocketAddress getNodeAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() == 2) {
            try {
                InetAddress inetAddress = InetAddress.getByName(stringTokenizer.nextToken().trim());
                int n = Integer.parseInt(stringTokenizer.nextToken().trim());
                if (NetworkUtils.isValidAddress(inetAddress) && NetworkUtils.isValidPort(n)) {
                    return new InetSocketAddress(inetAddress, n);
                }
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean sendRequest(HttpPushRequest httpPushRequest) {
        byte[] byArray = GUID.fromHexString(httpPushRequest.getClientGUID());
        PushRequestImpl pushRequestImpl = new PushRequestImpl(GUID.makeGuid(), 0, byArray, httpPushRequest.getFileIndex(), httpPushRequest.getAddress().getAddress().getAddress(), httpPushRequest.getAddress().getPort(), Message.Network.TCP, httpPushRequest.isUseTLS());
        try {
            this.messageRouter.sendPushRequest(pushRequestImpl);
        }
        catch (IOException iOException) {
            LOG.debug((Object)"Sending of push proxy request failed", (Throwable)iOException);
            return false;
        }
        return true;
    }

    private static class HttpPushRequest {
        private String clientGUID;
        private int fileIndex;
        private InetSocketAddress address;
        private boolean useTLS;

        public HttpPushRequest(String string, int n, InetSocketAddress inetSocketAddress, boolean bl) {
            this.clientGUID = string;
            this.fileIndex = n;
            this.address = inetSocketAddress;
            this.useTLS = bl;
        }

        public String getClientGUID() {
            return this.clientGUID;
        }

        public int getFileIndex() {
            return this.fileIndex;
        }

        public InetSocketAddress getAddress() {
            return this.address;
        }

        public boolean isUseTLS() {
            return this.useTLS;
        }
    }
}

