/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.google.inject.Provider;
import com.limegroup.gnutella.BandwidthManager;
import com.limegroup.gnutella.uploader.HTTPUploader;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.limewire.http.entity.AbstractProducingNHttpEntity;
import org.limewire.http.entity.FilePieceReader;
import org.limewire.http.entity.Piece;
import org.limewire.http.entity.PieceListener;
import org.limewire.http.reactor.HttpIOSession;
import org.limewire.nio.NIODispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileResponseEntity
extends AbstractProducingNHttpEntity {
    private static final Log LOG = LogFactory.getLog(FileResponseEntity.class);
    private final HTTPUploader uploader;
    private final File file;
    private ByteBuffer buffer;
    private long length;
    private long begin;
    private long remaining;
    private FilePieceReader reader;
    private Piece piece;
    private final Provider<BandwidthManager> bandwidthManager;

    FileResponseEntity(HTTPUploader hTTPUploader, File file, Provider<BandwidthManager> provider) {
        this.uploader = hTTPUploader;
        this.file = file;
        this.bandwidthManager = provider;
        this.setContentType("application/binary");
        this.begin = hTTPUploader.getUploadBegin();
        long l = hTTPUploader.getUploadEnd();
        this.remaining = this.length = l - this.begin;
        if (this.length < 0L) {
            throw new IllegalStateException("upload end must be >= upload begin");
        }
    }

    @Override
    public long getContentLength() {
        return this.length;
    }

    @Override
    public void initialize(ContentEncoder contentEncoder, IOControl iOControl) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Initializing upload of " + this.file.getName() + " [begin=" + this.begin + ",length=" + this.length + "]"));
        }
        if (this.length == 0L) {
            return;
        }
        HttpIOSession httpIOSession = this.uploader.getSession().getIOSession();
        httpIOSession.setThrottle(((BandwidthManager)this.bandwidthManager.get()).getWriteThrottle(httpIOSession.getSocket()));
        this.reader = new FilePieceReader(NIODispatcher.instance().getBufferCache(), this.file, this.begin, this.length, new PieceHandler(iOControl));
        this.reader.start();
    }

    public void finish() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Finished upload of " + this.file.getName() + " [begin=" + this.begin + ",length=" + this.length + ",remaining=" + this.remaining + "]"));
        }
        this.deactivateTimeout();
        if (this.reader != null) {
            this.reader.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeContent(ContentEncoder contentEncoder, IOControl iOControl) throws IOException {
        int n;
        if (this.buffer != null && this.buffer.hasRemaining()) {
            n = contentEncoder.write(this.buffer);
            this.uploader.addAmountUploaded(n);
            if (this.buffer.hasRemaining()) {
                this.activateTimeout();
                return true;
            }
            if (this.remaining == 0L) {
                this.reader.release(this.piece);
                return false;
            }
        } else if (this.remaining == 0L) {
            return false;
        }
        do {
            if (this.buffer == null || !this.buffer.hasRemaining()) {
                if (this.piece != null) {
                    this.reader.release(this.piece);
                }
                FileResponseEntity fileResponseEntity = this;
                synchronized (fileResponseEntity) {
                    this.piece = this.reader.next();
                    if (this.piece == null) {
                        this.buffer = null;
                        iOControl.suspendOutput();
                        this.activateTimeout();
                        return true;
                    }
                    this.buffer = this.piece.getBuffer();
                    this.remaining -= (long)this.buffer.remaining();
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Uploading " + this.file.getName() + " [remaining=" + this.remaining + "+" + this.buffer.remaining() + "]"));
            }
            n = contentEncoder.write(this.buffer);
            this.uploader.addAmountUploaded(n);
        } while (n > 0 && this.remaining > 0L);
        this.activateTimeout();
        return this.remaining > 0L || this.buffer.hasRemaining();
    }

    @Override
    public void timeout() {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("File transfer timed out: " + this.uploader));
        }
        this.uploader.stop();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + " [file=" + this.file.getName() + "]";
    }

    private class PieceHandler
    implements PieceListener {
        private final IOControl ioControl;

        public PieceHandler(IOControl iOControl) {
            this.ioControl = iOControl;
        }

        public void readFailed(IOException iOException) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Error reading file from disk: " + FileResponseEntity.this.uploader), (Throwable)iOException);
            }
            FileResponseEntity.this.uploader.stop();
        }

        public void readSuccessful() {
            this.ioControl.requestOutput();
        }
    }
}

