/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.util.URLDecoder;
import java.io.IOException;
import java.util.Locale;

class FileRequestParser {
    FileRequestParser() {
    }

    public static boolean isURNGet(String string) {
        int n = string.indexOf("/");
        int n2 = string.indexOf("/", n + 1);
        if (n == -1 || n2 == -1) {
            return false;
        }
        String string2 = string.substring(n + 1, n2);
        return string2.equalsIgnoreCase("uri-res");
    }

    public static FileRequest parseTraditionalGet(String string) throws IOException {
        try {
            int n = -1;
            String string2 = null;
            int n2 = string.indexOf("/get/");
            int n3 = string.indexOf("/", n2 + 5);
            String string3 = string.substring(n2 + 5, n3);
            n = Integer.parseInt(string3);
            try {
                string2 = URLDecoder.decode(string.substring(n3 + 1));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string2 = string.substring(n3 + 1);
            }
            return new FileRequest(n, string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException();
        }
    }

    public static FileRequest parseURNGet(FileManager fileManager, String string) throws IOException {
        RequestType requestType;
        URN uRN = URN.createSHA1UrnFromHttpRequest(string + " HTTP/1.1");
        String string2 = string.toUpperCase(Locale.US);
        if (string2.indexOf("N2X?") > 0) {
            requestType = RequestType.THEX;
        } else if (string2.indexOf("N2R?") > 0) {
            requestType = RequestType.FILE;
        } else {
            return null;
        }
        FileDesc fileDesc = fileManager.getSharedFileDescForUrn(uRN);
        if (fileDesc == null) {
            return null;
        }
        return new FileRequest(fileDesc.getIndex(), fileDesc.getFileName(), requestType);
    }

    static class FileRequest {
        String filename;
        int index;
        RequestType requestType;

        public FileRequest(int n, String string, RequestType requestType) {
            this.index = n;
            this.filename = string;
            this.requestType = requestType;
        }

        public FileRequest(int n, String string) {
            this(n, string, RequestType.FILE);
        }

        public boolean isThexRequest() {
            return this.requestType == RequestType.THEX;
        }

        public String toString() {
            return this.getClass().getName() + " [index=" + this.index + ",filename=" + this.filename + ",type=" + (Object)((Object)this.requestType) + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RequestType {
        FILE,
        THEX;

    }
}

