/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree.dime;

import com.limegroup.gnutella.dime.DIMEGenerator;
import com.limegroup.gnutella.dime.DIMERecord;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.HashTreeNodeManager;
import com.limegroup.gnutella.tigertree.HashTreeWriteHandler;
import com.limegroup.gnutella.tigertree.ThexWriter;
import com.limegroup.gnutella.tigertree.dime.AsyncTigerTreeWriter;
import com.limegroup.gnutella.tigertree.dime.TigerDimeUtils;
import com.limegroup.gnutella.util.UUID;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TigerDimeWriteHandler
implements HashTreeWriteHandler {
    private static final Log LOG = LogFactory.getLog(TigerDimeWriteHandler.class);
    private static final String OUTPUT_TYPE = "application/dime";
    private static final String XML_TYPE = "text/xml";
    private static final byte[] TREE_TYPE_BYTES = TigerDimeWriteHandler.getBytes("http://open-content.net/spec/thex/breadthfirst");
    private static final byte[] XML_TYPE_BYTES = TigerDimeWriteHandler.getBytes("text/xml");
    private static final String XML_TREE_DESC_START = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE hashtree SYSTEM \"http://open-content.net/spec/thex/thex.dtd\"><hashtree>";
    private static final String XML_TREE_DESC_END = "</hashtree>";
    private final DIMEGenerator GENERATOR;

    private static byte[] getBytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.debug((Object)string, (Throwable)unsupportedEncodingException);
            return string.getBytes();
        }
    }

    public TigerDimeWriteHandler(HashTree hashTree, HashTreeNodeManager hashTreeNodeManager) {
        LOG.trace((Object)"creating HashTreeHandler for sending");
        UUID uUID = UUID.nextUUID();
        this.GENERATOR = new DIMEGenerator();
        this.GENERATOR.add(new XMLRecord(hashTree, uUID));
        this.GENERATOR.add(new TreeRecord(hashTree, uUID, hashTreeNodeManager));
    }

    public void write(OutputStream outputStream) throws IOException {
        this.GENERATOR.write(outputStream);
    }

    public int getOutputLength() {
        return this.GENERATOR.getLength();
    }

    public String getOutputType() {
        return OUTPUT_TYPE;
    }

    public ThexWriter createAsyncWriter() {
        return new AsyncTigerTreeWriter(this.GENERATOR.createAsyncWriter());
    }

    private static class TreeRecord
    extends DIMERecord {
        private final HashTree tigerTree;
        private final int length;
        private final HashTreeNodeManager hashTreeNodeManager;

        TreeRecord(HashTree hashTree, UUID uUID, HashTreeNodeManager hashTreeNodeManager) {
            super((byte)32, null, TigerDimeWriteHandler.getBytes("uuid:" + uUID), TREE_TYPE_BYTES, null);
            this.tigerTree = hashTree;
            this.length = this.tigerTree.getNodeCount() * TigerDimeUtils.HASH_SIZE;
            this.hashTreeNodeManager = hashTreeNodeManager;
        }

        public void writeData(OutputStream outputStream) throws IOException {
            for (List<byte[]> list : this.hashTreeNodeManager.getAllNodes(this.tigerTree)) {
                for (byte[] byArray : list) {
                    outputStream.write(byArray);
                }
            }
            TreeRecord.writePadding(this.getDataLength(), outputStream);
        }

        public int getDataLength() {
            return this.length;
        }
    }

    private static class XMLRecord
    extends DIMERecord {
        XMLRecord(HashTree hashTree, UUID uUID) {
            super((byte)16, null, null, XML_TYPE_BYTES, XMLRecord.getXML(hashTree, uUID));
        }

        private static byte[] getXML(HashTree hashTree, UUID uUID) {
            String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE hashtree SYSTEM \"http://open-content.net/spec/thex/thex.dtd\"><hashtree><file size='" + hashTree.getFileSize() + "' segmentsize='" + 1024 + "'/>" + "<digest algorithm='" + "http://open-content.net/spec/digest/tiger" + "' outputsize='" + TigerDimeUtils.HASH_SIZE + "'/>" + "<serializedtree depth='" + hashTree.getDepth() + "' type='" + "http://open-content.net/spec/thex/breadthfirst" + "' uri='uuid:" + uUID + "'/>" + TigerDimeWriteHandler.XML_TREE_DESC_END;
            return TigerDimeWriteHandler.getBytes(string);
        }
    }
}

