/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.security.MerkleTree;
import com.limegroup.gnutella.security.Tiger;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.HashTreeUtils;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Range;
import org.limewire.util.Base32;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HashTreeImpl
implements Serializable,
HashTree {
    private static final long serialVersionUID = -5752974896215224469L;
    private static final Log LOG = LogFactory.getLog(HashTreeImpl.class);
    public static final HashTreeImpl INVALID = new HashTreeImpl();
    private final List<byte[]> NODES;
    private final byte[] ROOT_HASH;
    private final long FILE_SIZE;
    private final int DEPTH;
    private final String THEX_URI;
    private transient int _nodeSize;

    private HashTreeImpl() {
        this.NODES = null;
        this.ROOT_HASH = null;
        this.FILE_SIZE = -1L;
        this.DEPTH = -1;
        this.THEX_URI = null;
    }

    HashTreeImpl(List<List<byte[]>> list, String string, long l, int n) {
        this.THEX_URI = "/uri-res/N2X?" + string;
        this.NODES = list.get(list.size() - 1);
        this.FILE_SIZE = l;
        this.ROOT_HASH = list.get(0).get(0);
        this.DEPTH = list.size() - 1;
        assert (MerkleTree.log2Ceil(this.NODES.size()) == this.DEPTH);
        assert ((long)this.NODES.size() * (long)n >= l);
        this._nodeSize = n;
    }

    @Override
    public boolean isCorrupt(Range range, byte[] byArray) {
        return this.isCorrupt(range, byArray, byArray.length);
    }

    @Override
    public boolean isCorrupt(Range range, byte[] byArray, int n) {
        assert (range.getHigh() <= this.FILE_SIZE);
        if (range.getLow() % (long)this._nodeSize == 0L && range.getHigh() - range.getLow() + 1L <= (long)this._nodeSize && (range.getHigh() == range.getLow() + (long)this._nodeSize - 1L || range.getHigh() == this.FILE_SIZE - 1L)) {
            MerkleTree merkleTree = new MerkleTree(new Tiger());
            merkleTree.update(byArray, 0, n);
            byte[] byArray2 = merkleTree.digest();
            byte[] byArray3 = this.NODES.get((int)(range.getLow() / (long)this._nodeSize));
            boolean bl = Arrays.equals(byArray3, byArray2);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("interval " + range + " verified " + bl));
            }
            return !bl;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCorrupt(Range range, RandomAccessFile randomAccessFile, byte[] byArray) {
        assert (range.getHigh() <= this.FILE_SIZE) : "invalid range " + range + " vs " + this.FILE_SIZE;
        if (range.getLow() % (long)this._nodeSize == 0L && range.getHigh() - range.getLow() + 1L <= (long)this._nodeSize && (range.getHigh() == range.getLow() + (long)this._nodeSize - 1L || range.getHigh() == this.FILE_SIZE - 1L)) {
            try {
                Object object;
                int n;
                MerkleTree merkleTree = new MerkleTree(new Tiger());
                for (long i = range.getLow(); i <= range.getHigh(); i += (long)n) {
                    n = (int)Math.min((long)byArray.length, range.getHigh() - i + 1L);
                    object = randomAccessFile;
                    synchronized (object) {
                        randomAccessFile.seek(i);
                        randomAccessFile.readFully(byArray, 0, n);
                    }
                    merkleTree.update(byArray, 0, n);
                }
                byte[] byArray2 = merkleTree.digest();
                object = this.NODES.get((int)(range.getLow() / (long)this._nodeSize));
                boolean bl = Arrays.equals((byte[])object, byArray2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("interval " + range + " verified " + bl));
                }
                return !bl;
            }
            catch (IOException iOException) {
                LOG.debug((Object)"iox while verifying ", (Throwable)iOException);
                return true;
            }
        }
        return true;
    }

    @Override
    public String httpStringValue() {
        return this.THEX_URI + ";" + Base32.encode(this.ROOT_HASH);
    }

    @Override
    public boolean isGoodDepth() {
        return this.DEPTH == HashTreeUtils.calculateDepth(this.FILE_SIZE);
    }

    @Override
    public boolean isDepthGoodEnough() {
        return this.DEPTH >= HashTreeUtils.calculateDepth(this.FILE_SIZE) - 1;
    }

    @Override
    public boolean isBetterTree(HashTree hashTree) {
        int n;
        if (hashTree == null) {
            return true;
        }
        if (hashTree.isGoodDepth()) {
            return false;
        }
        if (this.isGoodDepth()) {
            return true;
        }
        int n2 = HashTreeUtils.calculateDepth(this.FILE_SIZE);
        int n3 = Math.abs(this.getDepth() - n2);
        return n3 < (n = Math.abs(hashTree.getDepth() - n2));
    }

    @Override
    public long getFileSize() {
        return this.FILE_SIZE;
    }

    @Override
    public String getRootHash() {
        return Base32.encode(this.ROOT_HASH);
    }

    @Override
    public byte[] getRootHashBytes() {
        return this.ROOT_HASH;
    }

    @Override
    public URN getTreeRootUrn() {
        try {
            return URN.createTTRootFromBytes(this.ROOT_HASH);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getThexURI() {
        return this.THEX_URI;
    }

    @Override
    public int getDepth() {
        return this.DEPTH;
    }

    @Override
    public List<byte[]> getNodes() {
        return this.NODES;
    }

    @Override
    public synchronized int getNodeSize() {
        if (this._nodeSize == 0) {
            this._nodeSize = HashTreeUtils.calculateNodeSize(this.FILE_SIZE, this.DEPTH);
        }
        return this._nodeSize;
    }

    @Override
    public int getNodeCount() {
        double d = this.NODES.size();
        int n = (int)d;
        for (int i = this.DEPTH - 1; i >= 0; --i) {
            d = Math.ceil(d / 2.0);
            n += (int)d;
        }
        return n;
    }
}

