/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.security.Tiger;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.HashTreeFactory;
import com.limegroup.gnutella.tigertree.HashTreeImpl;
import com.limegroup.gnutella.tigertree.HashTreeNodeManager;
import com.limegroup.gnutella.tigertree.HashTreeUtils;
import com.limegroup.gnutella.tigertree.dime.TigerDimeReadUtils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class HashTreeFactoryImpl
implements HashTreeFactory {
    private static final Log LOG = LogFactory.getLog(HashTreeFactoryImpl.class);
    private final HashTreeNodeManager hashTreeNodeManager;

    @Inject
    public HashTreeFactoryImpl(HashTreeNodeManager hashTreeNodeManager) {
        this.hashTreeNodeManager = hashTreeNodeManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashTree createHashTree(FileDesc fileDesc) throws IOException {
        HashTree hashTree;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("creating hashtree for file " + fileDesc));
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(fileDesc.getFile()));
            hashTree = this.createHashTree(fileDesc.getFileSize(), bufferedInputStream, fileDesc.getSHA1Urn());
        }
        catch (Throwable throwable) {
            IOUtils.close(bufferedInputStream);
            throw throwable;
        }
        IOUtils.close(bufferedInputStream);
        return hashTree;
    }

    HashTree createHashTree(InputStream inputStream, String string, String string2, long l) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("reading " + string + "." + string2 + " dime data."));
        }
        return this.createHashTree(TigerDimeReadUtils.read(inputStream, l, string2), string, l);
    }

    @Override
    public HashTree createHashTree(List<List<byte[]>> list, String string, long l) {
        return this.createHashTree(list, string, l, HashTreeUtils.calculateNodeSize(l, list.size() - 1));
    }

    public HashTree createHashTree(long l, InputStream inputStream, URN uRN) throws IOException {
        int n = HashTreeUtils.calculateNodeSize(l, HashTreeUtils.calculateDepth(l));
        List<byte[]> list = HashTreeUtils.createTreeNodes(n, l, inputStream, new Tiger());
        List<List<byte[]>> list2 = HashTreeUtils.createAllParentNodes(list, new Tiger());
        return this.createHashTree(list2, uRN.toString(), l, n);
    }

    private HashTree createHashTree(List<List<byte[]>> list, String string, long l, int n) {
        HashTreeImpl hashTreeImpl = new HashTreeImpl(list, string.toString(), l, n);
        this.hashTreeNodeManager.register(hashTreeImpl, list);
        return hashTreeImpl;
    }
}

