/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.HashTreeCache;
import com.limegroup.gnutella.tigertree.HashTreeFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Tuple;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.GenericsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class HashTreeCacheImpl
implements HashTreeCache {
    private static final Log LOG = LogFactory.getLog(HashTreeCacheImpl.class);
    private final ExecutorService QUEUE = ExecutorsHelper.newProcessingQueue("TreeHashTread");
    private final URN BUSH = URN.INVALID;
    private final Map<URN, URN> ROOT_MAP;
    private final Map<URN, HashTree> TREE_MAP;
    private final File ROOT_CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "ttroot.cache");
    private final File TREE_CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "ttrees.cache");
    private volatile boolean dirty = false;
    private final HashTreeFactory tigerTreeFactory;

    @Inject
    HashTreeCacheImpl(HashTreeFactory hashTreeFactory) {
        this.tigerTreeFactory = hashTreeFactory;
        Tuple<Map<URN, URN>, Map<URN, HashTree>> tuple = this.loadCaches();
        this.ROOT_MAP = tuple.getFirst();
        this.TREE_MAP = tuple.getSecond();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashTree getHashTreeAndWait(FileDesc fileDesc, long l) throws InterruptedException, TimeoutException {
        Object object;
        if (fileDesc instanceof IncompleteFileDesc) {
            throw new IllegalArgumentException("fd must not inherit from IncompleFileDesc");
        }
        Object object2 = this;
        synchronized (object2) {
            object = this.ROOT_MAP.get(fileDesc.getSHA1Urn());
            if (object != null && object != this.BUSH) {
                return this.TREE_MAP.get(object);
            }
            this.ROOT_MAP.put(fileDesc.getSHA1Urn(), this.BUSH);
        }
        object2 = this.QUEUE.submit(new HashRunner(fileDesc));
        try {
            object2.get(l, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            throw new RuntimeException(executionException);
        }
        object = this;
        synchronized (object) {
            URN uRN = this.ROOT_MAP.get(fileDesc.getSHA1Urn());
            if (uRN != null && uRN != this.BUSH) {
                return this.TREE_MAP.get(uRN);
            }
        }
        throw new RuntimeException("hash tree was not calculated");
    }

    @Override
    public synchronized HashTree getHashTree(FileDesc fileDesc) {
        URN uRN = this.ROOT_MAP.get(fileDesc.getSHA1Urn());
        if (uRN == null || uRN == this.BUSH) {
            return null;
        }
        HashTree hashTree = this.TREE_MAP.get(uRN);
        if (hashTree == null) {
            this.ROOT_MAP.put(fileDesc.getSHA1Urn(), this.BUSH);
            this.QUEUE.execute(new HashRunner(fileDesc));
        }
        return hashTree;
    }

    @Override
    public synchronized HashTree getHashTree(URN uRN) {
        if (!uRN.isSHA1()) {
            throw new IllegalArgumentException();
        }
        URN uRN2 = this.ROOT_MAP.get(uRN);
        if (uRN2 == null || uRN2 == this.BUSH) {
            return null;
        }
        return this.TREE_MAP.get(uRN2);
    }

    @Override
    public synchronized URN getHashTreeRootForSha1(URN uRN) {
        if (!uRN.isSHA1()) {
            throw new IllegalArgumentException();
        }
        URN uRN2 = this.ROOT_MAP.get(uRN);
        if (uRN2 == this.BUSH) {
            uRN2 = null;
        }
        return uRN2;
    }

    @Override
    public synchronized void purgeTree(URN uRN) {
        if (!uRN.isSHA1()) {
            throw new IllegalArgumentException();
        }
        URN uRN2 = this.ROOT_MAP.remove(uRN);
        if (uRN2 == null) {
            return;
        }
        if (this.TREE_MAP.remove(uRN2) != null) {
            this.dirty = true;
        }
    }

    @Override
    public synchronized void addHashTree(URN uRN, HashTree hashTree) {
        URN uRN2 = hashTree.getTreeRootUrn();
        this.addRoot(uRN, uRN2);
        if (hashTree.isGoodDepth()) {
            this.ROOT_MAP.put(uRN, uRN2);
            this.TREE_MAP.put(uRN2, hashTree);
            this.dirty = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("added hashtree for urn " + uRN + ";" + hashTree.getRootHash()));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("hashtree for urn " + uRN + " had bad depth"));
        }
    }

    @Override
    public synchronized void addRoot(URN uRN, URN uRN2) {
        if (!uRN.isSHA1() || !uRN2.isTTRoot()) {
            throw new IllegalArgumentException();
        }
        this.dirty |= !uRN2.equals(this.ROOT_MAP.put(uRN, uRN2));
    }

    private Tuple<Map<URN, URN>, Map<URN, HashTree>> loadCaches() {
        Object object;
        Object object2;
        HashMap hashMap;
        try {
            hashMap = this.ROOT_CACHE_FILE.exists() ? FileUtils.readObject(this.ROOT_CACHE_FILE) : new HashMap();
            object2 = this.TREE_CACHE_FILE.exists() ? FileUtils.readObject(this.TREE_CACHE_FILE) : new HashMap();
        }
        catch (Throwable throwable) {
            LOG.debug((Object)"Error reading from disk.", throwable);
            hashMap = new HashMap();
            object2 = new HashMap();
        }
        Map<URN, URN> map = GenericsUtils.scanForMap(hashMap, URN.class, URN.class, GenericsUtils.ScanMode.REMOVE);
        Map<URN, HashTree> map2 = GenericsUtils.scanForMap(object2, URN.class, HashTree.class, GenericsUtils.ScanMode.REMOVE);
        map2.keySet().retainAll(map.values());
        Iterator<Object> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object.getKey().isSHA1() && object.getValue().isTTRoot()) continue;
            iterator.remove();
        }
        iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            object = (URN)iterator.next();
            if (((URN)object).isTTRoot()) continue;
            iterator.remove();
        }
        return new Tuple<Map<URN, URN>, Map<URN, HashTree>>(map, map2);
    }

    private void removeOldEntries(Map<URN, URN> map, Map<URN, HashTree> map2, FileManager fileManager, DownloadManager downloadManager) {
        Iterator<URN> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            URN uRN = iterator.next();
            if (map.get(uRN) != this.BUSH && (fileManager.getFileDescForUrn(uRN) != null || downloadManager.getIncompleteFileManager().getFileForUrn(uRN) != null || Math.random() > (double)(map2.size() / 200))) continue;
            iterator.remove();
            map2.remove(map.get(uRN));
            this.dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistCache(FileManager fileManager, DownloadManager downloadManager) {
        HashMap<URN, URN> hashMap;
        HashMap<URN, HashTree> hashMap2;
        if (!this.dirty) {
            return;
        }
        HashTreeCacheImpl hashTreeCacheImpl = this;
        synchronized (hashTreeCacheImpl) {
            hashMap2 = new HashMap<URN, HashTree>(this.TREE_MAP);
            hashMap = new HashMap<URN, URN>(this.ROOT_MAP);
        }
        this.removeOldEntries(hashMap, hashMap2, fileManager, downloadManager);
        hashTreeCacheImpl = this;
        synchronized (hashTreeCacheImpl) {
            this.TREE_MAP.clear();
            this.TREE_MAP.putAll(hashMap2);
            this.ROOT_MAP.clear();
            this.ROOT_MAP.putAll(hashMap);
        }
        try {
            FileUtils.writeObject(this.ROOT_CACHE_FILE, hashMap);
            FileUtils.writeObject(this.TREE_CACHE_FILE, hashMap2);
            this.dirty = false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class HashRunner
    implements Runnable {
        private final FileDesc FD;

        HashRunner(FileDesc fileDesc) {
            this.FD = fileDesc;
        }

        public void run() {
            try {
                URN uRN = this.FD.getSHA1Urn();
                if (HashTreeCacheImpl.this.getHashTree(uRN) == null) {
                    HashTree hashTree = HashTreeCacheImpl.this.tigerTreeFactory.createHashTree(this.FD);
                    HashTreeCacheImpl.this.addHashTree(uRN, hashTree);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

