/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.templates;

import java.text.ParseException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StoreTemplateProcessor {
    public static final String ARTIST_LABEL = "artist";
    public static final String ALBUM_LABEL = "album";
    public static final String TITLE_LABEL = "title";
    public static final String TRACK_LABEL = "track";
    protected static final char START_DELIM = '<';
    protected static final char END_DELIM = '>';
    static final int TEMPLATE_PROCESSOR_ILLEGAL_CHARACTER = 0;
    static final int TEMPLATE_PROCESSOR_MISSING_DELIMETER = 1;
    static final int TEMPLATE_PROCESSOR_UNKNOWN_REPLACEMENT = 2;
    static final int TEMPLATE_PROCESSOR_UNCLOSED_VARIABLE = 3;

    protected String performSubstitution(String string, Map<String, String> map) throws IllegalTemplateException {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        States states = States.LOOKING_FOR_START_DELIM;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (states == States.LOOKING_FOR_START_DELIM) {
                if (c == '<') {
                    states = States.INSIDE_START_DELIM;
                    stringBuilder2 = new StringBuilder();
                    continue;
                }
                stringBuilder.append(c);
                continue;
            }
            if (states != States.INSIDE_START_DELIM) continue;
            if (c == '>') {
                String string2 = stringBuilder2.toString().replaceAll("\\s", "");
                String string3 = map.get(string2);
                if (string3 == null) {
                    throw new IllegalTemplateException(i, 2, string);
                }
                stringBuilder.append(string3);
                states = States.LOOKING_FOR_START_DELIM;
                continue;
            }
            stringBuilder2.append(c);
        }
        if (states == States.INSIDE_START_DELIM) {
            throw new IllegalTemplateException(string.length(), 3, string);
        }
        stringBuilder.trimToSize();
        return stringBuilder.toString();
    }

    public static final class IllegalTemplateException
    extends ParseException {
        private final int messageType;
        private final String template;

        public IllegalTemplateException(int n, int n2, String string) {
            super("", n);
            this.messageType = n2;
            this.template = string;
        }

        public String getMessage() {
            StringBuilder stringBuilder = new StringBuilder();
            String string = null;
            try {
                string = super.getMessage();
            }
            catch (Exception exception) {
                string = exception.getLocalizedMessage();
            }
            stringBuilder.append(string);
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append(this.template);
            stringBuilder.append(System.getProperty("line.separator"));
            int n = this.getErrorOffset();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(' ');
            }
            stringBuilder.append('^');
            return stringBuilder.toString();
        }

        public String getTemplate() {
            return this.template;
        }

        public int getMessageType() {
            return this.messageType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum States {
        LOOKING_FOR_START_DELIM,
        INSIDE_START_DELIM;

    }
}

