/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.statistics;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.LifecycleManager;
import java.util.HashMap;
import org.limewire.collection.NumericBuffer;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectionPoint;
import org.limewire.util.ByteUtils;

@Singleton
public class QueryStats {
    private NumericBuffer<Long> times = new NumericBuffer(200);
    private final LifecycleManager lifecycleManager;
    @InspectionPoint(value="user query stats v3")
    private final Inspectable queryStats = new Inspectable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object inspect() {
            QueryStats queryStats = QueryStats.this;
            synchronized (queryStats) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("ver", 3);
                byte[] byArray = new byte[QueryStats.this.times.getSize() * 4];
                for (int i = 0; i < QueryStats.this.times.getSize(); ++i) {
                    int n = Float.floatToIntBits((float)((Long)QueryStats.this.times.get(i) - QueryStats.this.lifecycleManager.getStartFinishedTime()) / 1000.0f);
                    ByteUtils.int2beb(n, byArray, i * 4);
                }
                hashMap.put("buf", byArray);
                return hashMap;
            }
        }
    };

    @Inject
    public QueryStats(LifecycleManager lifecycleManager) {
        this.lifecycleManager = lifecycleManager;
    }

    public synchronized void recordQuery() {
        this.times.add(System.currentTimeMillis());
    }

    public synchronized long getLastQueryTime() {
        if (this.times.isEmpty()) {
            return 0L;
        }
        return (Long)this.times.first();
    }
}

