/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.spam;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.spam.RatingTable;
import com.limegroup.gnutella.spam.Token;
import java.util.Locale;

@Singleton
public class SpamManager {
    public static final float MAX_THRESHOLD = 0.995f;
    private static final float NO_SHA1_URN_RATING = 0.5f;
    private static final float INCOMPLETE_FILE_RATING = 0.0f;
    private final RatingTable ratingTable;

    @Inject
    SpamManager(RatingTable ratingTable) {
        this.ratingTable = ratingTable;
    }

    public void startedQuery(QueryRequest queryRequest) {
        if (SearchSettings.ENABLE_SPAM_FILTER.getValue()) {
            this.ratingTable.mark(queryRequest, Token.Rating.CLEARED);
        }
    }

    public boolean isSpam(RemoteFileDesc remoteFileDesc) {
        if (!SearchSettings.ENABLE_SPAM_FILTER.getValue()) {
            return false;
        }
        float f = 0.0f;
        if (remoteFileDesc.getSHA1Urn() == null && remoteFileDesc.getXMLDocument() != null && remoteFileDesc.getXMLDocument().getAction().length() == 0) {
            f = 1.0f - (1.0f - f) * 0.5f;
        }
        if (this.isIncompleteFile(remoteFileDesc.getFileName().toLowerCase(Locale.US))) {
            f = 1.0f - (1.0f - f) * 0.0f;
        }
        String string = remoteFileDesc.getFileName().toLowerCase(Locale.US);
        long l = remoteFileDesc.getSize();
        if (l == 48139L || l == 50327L || l == 53379L || l == 56993L || l == 96191L || l == 96268L || l == 121836L || l == 200706L || l == 283692L || l == 822182L || l == 863798L || l == 938820L || l == 1058868L || l == 1105392L || l == 1155729L || l == 1167481L || l == 1216226L || l == 1251562L || l == 1252087L || l == 0x132212L || l == 1279141L || l == 1279142L || l == 1411929L || l == 1431124L || l == 3545425L || string.indexOf("cracked") != -1 && (string.endsWith(".html") || string.endsWith(".wma") || string.endsWith(".xml") || string.indexOf("special edition") != -1) || string.startsWith("horny ") && (string.endsWith(".html") || string.endsWith(".zip")) || string.startsWith("sexy ") && string.endsWith(".zip") || string.endsWith(" (2).zip") || string.endsWith(" (album.edition).wma") || string.endsWith(" (cover).wma") || string.endsWith(" (divx).zip") || string.endsWith(" (front).wma") || string.endsWith(" (intro).wma") || string.endsWith(" (latest).wma") || string.endsWith(" (mix).wma") || string.endsWith(" (music).zip") || string.endsWith(" (new.album).wma") || string.endsWith(" (new.single).wma") || string.endsWith(" (original).zip") || string.endsWith(" (porn).zip") || string.endsWith(" (radio.edit).wma") || string.endsWith(" (radio.version).zip") || string.endsWith(" (remix).wma") || string.endsWith(" (rock).wma") || string.endsWith(" (single).zip") || string.endsWith(" (special).wma") || string.endsWith(" (special.edition).wma") || string.endsWith(" (svcd).zip") || string.endsWith(" (tool).wma") || string.endsWith(" (uncensored).html") || string.endsWith(" (uncensored).mov") || string.endsWith(" (uncensored).zip") || string.endsWith(" (unreleased).zip") || string.endsWith(" (very hot).mpg") || string.endsWith(" (vocal).wma") || string.endsWith(" (working) album.wma") || string.endsWith(" (working) divx.zip") || string.endsWith(" *better version* [key].zip") || string.endsWith(" *uncensored* single.wma") || string.endsWith(" *working* (full).zip") || string.endsWith(" *working* dirty.zip") || string.endsWith(" - best music.zip") || string.endsWith(" - gives blowjob.html") || string.endsWith(" - great blowjob.html") || string.endsWith(" - greatest hits.mp3") || string.endsWith(" - greatest hits.wma") || string.endsWith(" - pics.html") || string.endsWith(" 2006.zip") || string.endsWith(" 2007.zip") || string.endsWith(" [!].zip") || string.endsWith(" [album.edition].wma") || string.endsWith(" [banned.version].zip") || string.endsWith(" [bonus].wma") || string.endsWith(" [cd].zip") || string.endsWith(" [dirty].zip") || string.endsWith(" [divx].zip") || string.endsWith(" [explicit].zip") || string.endsWith(" [extended.edition].wma") || string.endsWith(" [full].zip") || string.endsWith(" [mix].zip") || string.endsWith(" [new.single].wma") || string.endsWith(" [porn].zip") || string.endsWith(" [radio.version].zip") || string.endsWith(" [registered].wma") || string.endsWith(" [rock].wma") || string.endsWith(" [single].wma") || string.endsWith(" [soundtrack].zip") || string.endsWith(" [svcd].zip") || string.endsWith(" [techno.remix].zip") || string.endsWith(" [techno].zip") || string.endsWith(" [theme].wma") || string.endsWith(" [tool].wma") || string.endsWith(" [ultimate.edition].wma") || string.endsWith(" [vcd].zip") || string.endsWith(" [video].wma") || string.endsWith(" [wyzo].zip") || string.endsWith(" [x].zip") || string.endsWith(" album.edition.zip") || string.endsWith(" back.wma") || string.endsWith(" bdsm.html") || string.endsWith(" bearshare download accelerator.zip") || string.endsWith(" bittorrent downloader.zip") || string.endsWith(" bonus.zip") || string.endsWith(" by cdz intro.wma") || string.endsWith(" by cdz theme.zip") || string.endsWith(" by incite (1).zip") || string.endsWith(" by pr0nstars key.wma") || string.endsWith(" clip.zip") || string.endsWith(" cover.zip") || string.endsWith(" crack by frost.zip") || string.endsWith(" cute girl has orgasm on webcam.mp3") || string.endsWith(" cute girl has orgasm on webcam.mpg") || string.endsWith(" dvdrip.zip") || string.endsWith(" extended.edition.zip") || string.endsWith(" extended.wma") || string.endsWith(" fucking.html") || string.endsWith(" full.zip") || string.endsWith(" hentai anime.zip") || string.endsWith(" limewire download accelerator.zip") || string.endsWith(" mp3.html") || string.endsWith(" music.html") || string.endsWith(" naked.html") || string.endsWith(" naked.zip") || string.endsWith(" new.zip") || string.endsWith(" pictures.html") || string.endsWith(" radio.edition.zip") || string.endsWith(" remix.zip") || string.endsWith(" ringtones.html") || string.endsWith(" securely with new secured browser.zip") || string.endsWith(" sexy girl has shaking orgasm during sex.mpg") || string.endsWith(" share accelerator.zip") || string.endsWith(" song.zip") || string.endsWith(" soul.zip") || string.endsWith(" special.edition.wma") || string.endsWith(" special.zip") || string.endsWith(" techno.zip") || string.endsWith(" ultimate.edition.zip") || string.endsWith(" using emule multimedia toolbar.zip") || string.endsWith(" using the best ultimate player.zip") || string.endsWith(" video (extended).wma") || string.endsWith(" video.zip") || string.endsWith(" videos.html") || string.endsWith(" vocal.wma") || string.endsWith(" web hottest videos personal player.exe") || string.endsWith(" webcam.html") || string.endsWith(" wet and wild.zip") || string.endsWith(" with bonus.zip") || string.endsWith(" with new secured emule.zip") || string.endsWith(" with the fastest bittorrent downloader.zip") || string.endsWith(" with the ultimate player.zip") || string.endsWith(" xvid.zip") || string.endsWith(" young and cute.zip") || string.endsWith("-vids.html") || string.endsWith("-xcd.wma") || string.endsWith("-xxx.wmv") || string.endsWith("-xxx.wmv") || string.equals("official limewire pro available here.com") || string.startsWith("!!!!!!!! ") || string.startsWith("###### ") || string.startsWith("(cinemaniacs) ") || string.startsWith("(corp) ") || string.startsWith("(deviance) ") || string.startsWith("(fusion) ") || string.startsWith("(genius) ") || string.startsWith("(h2o) ") || string.startsWith("*better version* ") || string.startsWith("*myth* ") || string.startsWith("*naked* ") || string.startsWith("*strike* ") || string.startsWith("*subnet* ") || string.startsWith("- presented by ash - ") || string.startsWith("---===== ") || string.startsWith("download music ") || string.startsWith("get music ") || string.startsWith("warning, visit ") || remoteFileDesc.getXMLDocument() != null && remoteFileDesc.getXMLDocument().getValue("audios__audio__title__") != null && remoteFileDesc.getXMLDocument().getValue("audios__audio__title__").startsWith("not related : ")) {
            f = 1.0f;
        }
        f = 1.0f - (1.0f - f) * (1.0f - this.ratingTable.getRating(remoteFileDesc));
        remoteFileDesc.setSpamRating(f);
        return f >= Math.max(SearchSettings.FILTER_SPAM_RESULTS.getValue(), SearchSettings.QUERY_SPAM_CUTOFF.getValue());
    }

    public void handleUserMarkedSpam(RemoteFileDesc[] remoteFileDescArray) {
        for (int i = 0; i < remoteFileDescArray.length; ++i) {
            remoteFileDescArray[i].setSpamRating(1.0f);
        }
        this.ratingTable.mark(remoteFileDescArray, Token.Rating.USER_MARKED_SPAM);
    }

    public void handleUserMarkedGood(RemoteFileDesc[] remoteFileDescArray) {
        for (int i = 0; i < remoteFileDescArray.length; ++i) {
            remoteFileDescArray[i].setSpamRating(0.0f);
        }
        this.ratingTable.mark(remoteFileDescArray, Token.Rating.USER_MARKED_GOOD);
    }

    public void clearFilterData() {
        this.ratingTable.clear();
    }

    private boolean isIncompleteFile(String string) {
        int n;
        if (string.startsWith("incomplete_")) {
            return true;
        }
        if (string.startsWith("incomplete~")) {
            return true;
        }
        if (string.startsWith("inacheve_")) {
            return true;
        }
        if (string.startsWith("in_")) {
            return true;
        }
        if (string.startsWith("__incomplete")) {
            return true;
        }
        if (string.startsWith("___incompleted")) {
            return true;
        }
        if (string.startsWith("___arestra")) {
            return true;
        }
        if (string.startsWith("preview-t-")) {
            return true;
        }
        if (string.startsWith("t-")) {
            for (n = 2; n < string.length(); ++n) {
                if (Character.isDigit(string.charAt(n))) continue;
                return string.charAt(n) == '-';
            }
        }
        if (string.startsWith("corrupt-")) {
            for (n = 8; n < string.length(); ++n) {
                if (Character.isDigit(string.charAt(n))) continue;
                return string.charAt(n) == '-';
            }
        }
        return false;
    }
}

