/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.spam;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.spam.Token;
import com.limegroup.gnutella.spam.Tokenizer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.IOUtils;
import org.limewire.util.CommonUtils;
import org.limewire.util.GenericsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class RatingTable {
    private static final Log LOG = LogFactory.getLog(Tokenizer.class);
    private static final int MAX_SIZE = 50000;
    private final Map<Token, Token> _tokenMap;
    private final Tokenizer tokenizer;
    @InspectionPoint(value="spam rating table token hashes")
    private final Inspectable TOKEN_HASH = new Inspectable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object inspect() {
            RatingTable ratingTable = RatingTable.this;
            synchronized (ratingTable) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("ver", 1);
                float f = Math.max(SearchSettings.FILTER_SPAM_RESULTS.getValue(), SearchSettings.QUERY_SPAM_CUTOFF.getValue());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                try {
                    Token token;
                    float f2;
                    Iterator iterator = RatingTable.this._tokenMap.values().iterator();
                    while (iterator.hasNext() && !((f2 = (token = (Token)iterator.next()).getRating()) < f)) {
                        dataOutputStream.writeFloat(f2);
                        dataOutputStream.writeInt(token.hashCode());
                    }
                    dataOutputStream.flush();
                    dataOutputStream.close();
                    hashMap.put("dump", byteArrayOutputStream.toByteArray());
                }
                catch (IOException iOException) {
                    hashMap.put("error", iOException.toString());
                }
                return hashMap;
            }
        }
    };

    @Inject
    RatingTable(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
        this._tokenMap = this.readData();
        for (Token token : this._tokenMap.values()) {
            tokenizer.initialize(token);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("size of tokenSet " + this._tokenMap.size()));
        }
    }

    synchronized void clear() {
        this._tokenMap.clear();
    }

    float getRating(RemoteFileDesc remoteFileDesc) {
        float f = this.getRating(this.lookup(this.tokenizer.getTokens(remoteFileDesc)));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(remoteFileDesc.toString() + " rated " + f));
        }
        return f;
    }

    float getRating(Token[] tokenArray) {
        float f = 1.0f;
        for (int i = 0; i < tokenArray.length && f > 0.0f; f *= 1.0f - tokenArray[i].getRating(), ++i) {
        }
        float f2 = SearchSettings.FILTER_SPAM_RESULTS.getValue();
        if ((f = 1.0f - f) >= f2 && f <= 0.995f) {
            this.markInternal(tokenArray, Token.Rating.PROGRAM_MARKED_SPAM);
        } else if (f <= 1.0f - f2) {
            this.markInternal(tokenArray, Token.Rating.PROGRAM_MARKED_GOOD);
        }
        return f;
    }

    void mark(RemoteFileDesc[] remoteFileDescArray, Token.Rating rating) {
        this.markInternal(this.lookup(this.tokenizer.getTokens(remoteFileDescArray)), rating);
    }

    void mark(RemoteFileDesc remoteFileDesc, Token.Rating rating) {
        this.markInternal(this.lookup(this.tokenizer.getTokens(remoteFileDesc)), rating);
    }

    void mark(QueryRequest queryRequest, Token.Rating rating) {
        this.markInternal(this.lookup(this.tokenizer.getTokens(queryRequest)), rating);
    }

    private void markInternal(Token[] tokenArray, Token.Rating rating) {
        for (int i = 0; i < tokenArray.length; ++i) {
            tokenArray[i].rate(rating);
        }
    }

    private Token[] lookup(Token[] tokenArray) {
        for (int i = 0; i < tokenArray.length; ++i) {
            tokenArray[i] = this.lookup(tokenArray[i]);
        }
        return tokenArray;
    }

    private synchronized Token lookup(Token token) {
        Token token2 = this._tokenMap.get(token);
        if (token2 == null) {
            this._tokenMap.put(token, token);
            this.checkSize();
            token2 = token;
        }
        return token2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Token, Token> readData() {
        Map<Token, Token> map;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(RatingTable.getSpamDat())));
            map = GenericsUtils.scanForMap(objectInputStream.readObject(), Token.class, Token.class, GenericsUtils.ScanMode.REMOVE);
        }
        catch (Throwable throwable) {
            try {
                HashMap<Token, Token> hashMap = new HashMap<Token, Token>();
                return hashMap;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                IOUtils.close(objectInputStream);
            }
        }
        IOUtils.close(objectInputStream);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        HashMap<Token, Token> hashMap;
        Object object = this;
        synchronized (object) {
            if (this._tokenMap.size() > 50000) {
                this.pruneEntries();
            }
            hashMap = new HashMap<Token, Token>(this._tokenMap);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("size of tokenMap " + hashMap.size()));
        }
        object = null;
        try {
            object = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(RatingTable.getSpamDat())));
            ((ObjectOutputStream)object).writeObject(hashMap);
            ((ObjectOutputStream)object).flush();
        }
        catch (IOException iOException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"saving rating table failed", (Throwable)iOException);
            }
        }
        finally {
            IOUtils.close((Closeable)object);
        }
    }

    public synchronized void ageAndSave() {
        for (Token token : this._tokenMap.values()) {
            token.incrementAge();
        }
        this.save();
    }

    private synchronized void checkSize() {
        if (this._tokenMap.size() < 100000) {
            return;
        }
        this.pruneEntries();
    }

    private void pruneEntries() {
        int n;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"pruning unimportant entries from RatingTable");
        }
        if ((n = this._tokenMap.size() - 50000) <= 0) {
            return;
        }
        TreeSet<Token> treeSet = new TreeSet<Token>(this._tokenMap.values());
        for (Token token : treeSet) {
            this._tokenMap.remove(token);
            if (--n != 0) continue;
            break;
        }
    }

    private static File getSpamDat() {
        return new File(CommonUtils.getUserSettingsDir(), "spam.dat");
    }
}

