/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.spam;

import com.google.inject.Provider;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.spam.AbstractToken;
import com.limegroup.gnutella.spam.Token;
import java.util.Arrays;
import org.limewire.io.IP;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressToken
extends AbstractToken {
    private static final long serialVersionUID = 3257568416670824244L;
    private static final byte INITIAL_GOOD = 20;
    private static final int MAX = 50;
    private final byte[] _address;
    private final short _port;
    private boolean ratingInitialized;
    private byte _good;
    private byte _bad;
    private final int _hashCode;
    private volatile transient Provider<IPFilter> ipFilter;

    public AddressToken(byte[] byArray, int n, Provider<IPFilter> provider) {
        this.ipFilter = provider;
        assert (byArray.length == 4);
        this._address = byArray;
        this._port = (short)n;
        this._hashCode = this.getHashCode();
        this.ratingInitialized = false;
    }

    void setIpFilter(Provider<IPFilter> provider) {
        this.ipFilter = provider;
    }

    private synchronized void initializeRating() {
        if (this.ratingInitialized) {
            return;
        }
        if (this.ipFilter == null) {
            throw new IllegalStateException("must initialize IPFilter after deserializing.");
        }
        this._good = (byte)20;
        int n = ((IPFilter)this.ipFilter.get()).logMinDistanceTo(new IP(this._address));
        int n2 = (int)(1600.0 * Math.pow(1 + n, -3.3));
        while (n2 > 50) {
            n2 /= 2;
            this._good = (byte)(this._good / 2);
        }
        this._bad = (byte)n2;
        this.ratingInitialized = true;
    }

    private int getHashCode() {
        return this._address[0] + this._address[1] + this._address[2] + this._address[3] + this._port;
    }

    @Override
    public float getRating() {
        if (!this.ratingInitialized) {
            this.initializeRating();
        }
        return (float)this._bad / (float)(this._good + this._bad + 1);
    }

    @Override
    public double getImportance() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public void rate(Token.Rating rating) {
        if (!this.ratingInitialized) {
            this.initializeRating();
        }
        this._age = 0;
        switch (rating) {
            case PROGRAM_MARKED_GOOD: {
                this._good = (byte)(this._good + 1);
                break;
            }
            case PROGRAM_MARKED_SPAM: {
                this._bad = (byte)(this._bad + 1);
                break;
            }
            case USER_MARKED_GOOD: {
                this._bad = 0;
                break;
            }
            case USER_MARKED_SPAM: {
                this._bad = (byte)Math.min(this._bad + 10, 50);
                break;
            }
            case CLEARED: {
                this._bad = 0;
                this._good = (byte)20;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type of rating");
            }
        }
        if (this._good >= 50 || this._bad >= 50) {
            this._good = (byte)(this._good * 9 / 10);
            this._bad = (byte)(this._bad * 9 / 10);
        }
    }

    @Override
    public Token.TokenType getType() {
        return Token.TokenType.ADDRESS;
    }

    public final int hashCode() {
        return this._hashCode;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof AddressToken)) {
            return false;
        }
        if (this._hashCode != object.hashCode()) {
            return false;
        }
        return this._port == ((AddressToken)object)._port && Arrays.equals(this._address, ((AddressToken)object)._address);
    }

    public String toString() {
        return "" + (0xFF & this._address[0]) + "." + (0xFF & this._address[1]) + "." + (0xFF & this._address[2]) + "." + (0xFF & this._address[3]) + ":" + (0xFFFF & this._port) + " " + this._bad;
    }
}

