/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.simpp;

import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimppParser {
    private static final Log LOG = LogFactory.getLog(SimppParser.class);
    private static final String VERSION = "version";
    private static final String PROPS = "props";
    private int _version;
    private String _propsData;

    public SimppParser(byte[] byArray) throws IOException {
        this.parseInfo(new String(byArray, "UTF-8"));
    }

    public int getVersion() {
        return this._version;
    }

    public String getPropsData() {
        return this._propsData;
    }

    private void parseInfo(String string) throws IOException {
        if (string == null || string.equals("")) {
            throw new IOException("null xml for version info");
        }
        Document document = XMLUtils.getDocument(string, LOG);
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            String string2 = node.getNodeName().toLowerCase(Locale.US).trim();
            String string3 = LimeXMLUtils.getText(node.getChildNodes());
            if (string2.equals(VERSION)) {
                String string4 = string3;
                try {
                    this._version = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.error((Object)("Unable to parse version number: " + numberFormatException));
                    this._version = -1;
                }
                continue;
            }
            if (!string2.equals(PROPS)) continue;
            this._propsData = string3;
        }
    }
}

