/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.simpp;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.NetworkUpdateSanityChecker;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HttpClientListener;
import com.limegroup.gnutella.http.HttpExecutor;
import com.limegroup.gnutella.settings.SimppSettingsManager;
import com.limegroup.gnutella.simpp.SimppDataProvider;
import com.limegroup.gnutella.simpp.SimppDataVerifier;
import com.limegroup.gnutella.simpp.SimppListener;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.simpp.SimppParser;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.limewire.io.IOUtils;
import org.limewire.util.Clock;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class SimppManagerImpl
implements SimppManager {
    private static final Log LOG = LogFactory.getLog(SimppManagerImpl.class);
    private static int MIN_VERSION = 3;
    private static final String FILENAME = "simpp.xml";
    private static final Random RANDOM = new Random();
    private static final int IGNORE_ID = Integer.MAX_VALUE;
    private volatile byte[] _lastBytes = new byte[0];
    private volatile String _lastString = "";
    private volatile int _lastId = MIN_VERSION;
    private final HttpRequestControl httpRequestControl = new HttpRequestControl();
    private final List<SimppListener> listeners = new CopyOnWriteArrayList<SimppListener>();
    private final CopyOnWriteArrayList<SimppSettingsManager> simppSettingsManagers;
    private final Provider<NetworkUpdateSanityChecker> networkUpdateSanityChecker;
    private final ApplicationServices applicationServices;
    private final Clock clock;
    private final Provider<HttpExecutor> httpExecutor;
    private final ScheduledExecutorService backgroundExecutor;
    private final Provider<HttpParams> defaultParams;
    private final SimppDataProvider simppDataProvider;
    private volatile List<String> maxedUpdateList = Arrays.asList("http://simpp1.limewire.com/v2/simpp.def", "http://simpp2.limewire.com/v2/simpp.def", "http://simpp3.limewire.com/v2/simpp.def", "http://simpp4.limewire.com/v2/simpp.def", "http://simpp5.limewire.com/v2/simpp.def", "http://simpp6.limewire.com/v2/simpp.def", "http://simpp7.limewire.com/v2/simpp.def", "http://simpp8.limewire.com/v2/simpp.def", "http://simpp9.limewire.com/v2/simpp.def", "http://simpp10.limewire.com/v2/simpp.def");
    private volatile int minMaxHttpRequestDelay = 60000;
    private volatile int maxMaxHttpRequestDelay = 1800000;
    private volatile int silentPeriodForMaxHttpRequest = 300000;

    @Inject
    public SimppManagerImpl(Provider<NetworkUpdateSanityChecker> provider, Clock clock, ApplicationServices applicationServices, Provider<HttpExecutor> provider2, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, @Named(value="defaults") Provider<HttpParams> provider3, SimppDataProvider simppDataProvider) {
        this.networkUpdateSanityChecker = provider;
        this.clock = clock;
        this.applicationServices = applicationServices;
        this.simppSettingsManagers = new CopyOnWriteArrayList();
        this.httpExecutor = provider2;
        this.backgroundExecutor = scheduledExecutorService;
        this.defaultParams = provider3;
        this.simppDataProvider = simppDataProvider;
    }

    List<String> getMaxUrls() {
        return this.maxedUpdateList;
    }

    void setMaxUrls(List<String> list) {
        this.maxedUpdateList = list;
    }

    int getMinHttpRequestUpdateDelayForMaxFailover() {
        return this.minMaxHttpRequestDelay;
    }

    int getMaxHttpRequestUpdateDelayForMaxFailover() {
        return this.maxMaxHttpRequestDelay;
    }

    void setMinHttpRequestUpdateDelayForMaxFailover(int n) {
        this.minMaxHttpRequestDelay = n;
    }

    void setMaxHttpRequestUpdateDelayForMaxFailover(int n) {
        this.maxMaxHttpRequestDelay = n;
    }

    int getSilentPeriodForMaxHttpRequest() {
        return this.silentPeriodForMaxHttpRequest;
    }

    void setSilentPeriodForMaxHttpRequest(int n) {
        this.silentPeriodForMaxHttpRequest = n;
    }

    @Override
    public void initialize() {
        LOG.trace((Object)"Initializing SimppManager");
        this.backgroundExecutor.execute(new Runnable(){

            public void run() {
                SimppManagerImpl.this.handleDataInternal(FileUtils.readFileFully(new File(CommonUtils.getUserSettingsDir(), SimppManagerImpl.FILENAME)), UpdateType.FROM_DISK, null);
                SimppManagerImpl.this.handleDataInternal(SimppManagerImpl.this.simppDataProvider.getDefaultData(), UpdateType.FROM_DISK, null);
            }
        });
    }

    @Override
    public int getVersion() {
        return this._lastId;
    }

    @Override
    public byte[] getSimppBytes() {
        return this._lastBytes;
    }

    @Override
    public String getPropsString() {
        return this._lastString;
    }

    @Override
    public void addSimppSettingsManager(SimppSettingsManager simppSettingsManager) {
        this.simppSettingsManagers.add(simppSettingsManager);
    }

    @Override
    public List<SimppSettingsManager> getSimppSettingsManagers() {
        return this.simppSettingsManagers;
    }

    @Override
    public void addListener(SimppListener simppListener) {
        this.listeners.add(simppListener);
    }

    @Override
    public void removeListener(SimppListener simppListener) {
        this.listeners.remove(simppListener);
    }

    @Override
    public void checkAndUpdate(final ReplyHandler replyHandler, final byte[] byArray) {
        if (byArray != null) {
            this.backgroundExecutor.execute(new Runnable(){

                public void run() {
                    LOG.trace((Object)"Parsing new data...");
                    SimppManagerImpl.this.handleDataInternal(byArray, UpdateType.FROM_NETWORK, replyHandler);
                }
            });
        }
    }

    private void handleDataInternal(byte[] byArray, UpdateType updateType, ReplyHandler replyHandler) {
        if (byArray == null) {
            if (updateType == UpdateType.FROM_NETWORK && replyHandler != null) {
                ((NetworkUpdateSanityChecker)this.networkUpdateSanityChecker.get()).handleInvalidResponse(replyHandler, NetworkUpdateSanityChecker.RequestType.SIMPP);
            }
            LOG.warn((Object)"No data to handle.");
            return;
        }
        SimppDataVerifier simppDataVerifier = new SimppDataVerifier(byArray);
        if (!simppDataVerifier.verifySource()) {
            if (updateType == UpdateType.FROM_NETWORK && replyHandler != null) {
                ((NetworkUpdateSanityChecker)this.networkUpdateSanityChecker.get()).handleInvalidResponse(replyHandler, NetworkUpdateSanityChecker.RequestType.SIMPP);
            }
            LOG.warn((Object)"Couldn't verify signature on data.");
            return;
        }
        if (updateType == UpdateType.FROM_NETWORK && replyHandler != null) {
            ((NetworkUpdateSanityChecker)this.networkUpdateSanityChecker.get()).handleValidResponse(replyHandler, NetworkUpdateSanityChecker.RequestType.SIMPP);
        }
        SimppParser simppParser = null;
        try {
            simppParser = new SimppParser(simppDataVerifier.getVerifiedData());
        }
        catch (IOException iOException) {
            LOG.error((Object)"IOX parsing simpp data", (Throwable)iOException);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Got data with version: " + simppParser.getVersion() + " from: " + (Object)((Object)updateType) + ", current version is: " + this._lastId));
        }
        switch (updateType) {
            case FROM_NETWORK: {
                if (simppParser.getVersion() == Integer.MAX_VALUE) {
                    if (this._lastId == Integer.MAX_VALUE) break;
                    this.doHttpMaxFailover();
                    break;
                }
                if (simppParser.getVersion() <= this._lastId) break;
                this.storeAndUpdate(byArray, simppParser, updateType);
                break;
            }
            case FROM_DISK: {
                if (simppParser.getVersion() <= this._lastId) break;
                this.storeAndUpdate(byArray, simppParser, updateType);
                break;
            }
            case FROM_HTTP: {
                if (simppParser.getVersion() < this._lastId) break;
                this.storeAndUpdate(byArray, simppParser, updateType);
            }
        }
    }

    private void storeAndUpdate(byte[] byArray, SimppParser simppParser, UpdateType updateType) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Retrieved new data from: " + (Object)((Object)updateType) + ", storing & updating"));
        }
        if (simppParser.getVersion() == Integer.MAX_VALUE && updateType == UpdateType.FROM_NETWORK) {
            throw new IllegalStateException("shouldn't be here!");
        }
        if (updateType == UpdateType.FROM_NETWORK && this.httpRequestControl.isRequestPending()) {
            return;
        }
        this._lastId = simppParser.getVersion();
        this._lastBytes = byArray;
        this._lastString = simppParser.getPropsData();
        if (updateType != UpdateType.FROM_DISK) {
            FileUtils.verySafeSave(CommonUtils.getUserSettingsDir(), FILENAME, byArray);
        }
        for (SimppSettingsManager object : this.simppSettingsManagers) {
            object.updateSimppSettings(this._lastString);
        }
        for (SimppListener simppListener : this.listeners) {
            simppListener.simppUpdated(this._lastId);
        }
    }

    private void doHttpMaxFailover() {
        long l = this.clock.now() - (long)this.silentPeriodForMaxHttpRequest;
        if (!this.httpRequestControl.requestQueued(HttpRequestControl.RequestReason.MAX)) {
            int n = RANDOM.nextInt(this.maxMaxHttpRequestDelay) + this.minMaxHttpRequestDelay;
            final String string = this.maxedUpdateList.get(RANDOM.nextInt(this.maxedUpdateList.size()));
            LOG.debug((Object)("Scheduling http max failover in: " + n + ", to: " + string));
            this.backgroundExecutor.schedule(new Runnable(){

                public void run() {
                    String string2 = string;
                    try {
                        SimppManagerImpl.this.launchHTTPUpdate(string2);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        SimppManagerImpl.this.httpRequestControl.requestFinished();
                        SimppManagerImpl.this.httpRequestControl.cancelRequest();
                        LOG.warn((Object)"uri failure", (Throwable)uRISyntaxException);
                    }
                }
            }, (long)n, TimeUnit.MILLISECONDS);
        } else {
            LOG.debug((Object)"Ignoring http max failover.");
        }
    }

    private void launchHTTPUpdate(String string) throws URISyntaxException {
        if (!this.httpRequestControl.isRequestPending()) {
            return;
        }
        LOG.debug((Object)"about to issue http request method");
        HttpGet httpGet = new HttpGet(LimeWireUtils.addLWInfoToUrl(string, this.applicationServices.getMyGUID()));
        httpGet.addHeader("User-Agent", LimeWireUtils.getHttpServer());
        httpGet.addHeader(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
        this.httpRequestControl.requestActive();
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)10000);
        HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)10000);
        basicHttpParams = new DefaultedHttpParams((HttpParams)basicHttpParams, (HttpParams)this.defaultParams.get());
        ((HttpExecutor)this.httpExecutor.get()).execute((HttpUriRequest)httpGet, (HttpParams)basicHttpParams, new RequestHandler());
    }

    @Override
    public byte[] getOldUpdateResponse() {
        return this.simppDataProvider.getOldUpdateResponse();
    }

    private static class HttpRequestControl {
        private final AtomicBoolean requestQueued = new AtomicBoolean(false);
        private final AtomicBoolean requestActive = new AtomicBoolean(false);
        private volatile RequestReason requestReason;

        private HttpRequestControl() {
        }

        boolean isRequestPending() {
            return this.requestActive.get() || this.requestQueued.get();
        }

        boolean requestQueued(RequestReason requestReason) {
            boolean bl = this.requestQueued.getAndSet(true);
            if (!bl || requestReason == RequestReason.MAX) {
                this.requestReason = requestReason;
            }
            return bl || this.requestActive.get();
        }

        void requestActive() {
            this.requestActive.set(true);
            this.requestQueued.set(false);
        }

        RequestReason getRequestReason() {
            return this.requestReason;
        }

        void cancelRequest() {
            this.requestQueued.set(false);
        }

        void requestFinished() {
            this.requestActive.set(false);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum RequestReason {
            MAX;

        }
    }

    private class RequestHandler
    implements HttpClientListener {
        private RequestHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean requestComplete(HttpUriRequest httpUriRequest, HttpResponse httpResponse) {
            byte[] byArray;
            LOG.debug((Object)"http request method succeeded");
            try {
                if (httpResponse.getStatusLine().getStatusCode() < 200 || httpResponse.getStatusLine().getStatusCode() >= 300) {
                    throw new IOException("bad code " + httpResponse.getStatusLine().getStatusCode());
                }
                byte[] byArray2 = null;
                if (httpResponse.getEntity() != null) {
                    byArray2 = IOUtils.readFully(httpResponse.getEntity().getContent());
                }
                if (byArray2 == null || byArray2.length == 0) {
                    throw new IOException("bad body");
                }
                byArray = IOUtils.inflate(byArray2);
            }
            catch (IOException iOException) {
                SimppManagerImpl.this.httpRequestControl.requestFinished();
                LOG.warn((Object)"couldn't fetch data ", (Throwable)iOException);
                boolean bl = false;
                return bl;
            }
            finally {
                ((HttpExecutor)SimppManagerImpl.this.httpExecutor.get()).releaseResources(httpResponse);
            }
            SimppManagerImpl.this.backgroundExecutor.execute(new Runnable(){

                public void run() {
                    SimppManagerImpl.this.httpRequestControl.requestFinished();
                    LOG.trace((Object)"Parsing new data...");
                    SimppManagerImpl.this.handleDataInternal(byArray, UpdateType.FROM_HTTP, null);
                }
            });
            return false;
        }

        public boolean requestFailed(HttpUriRequest httpUriRequest, HttpResponse httpResponse, IOException iOException) {
            LOG.warn((Object)"http failover failed", (Throwable)iOException);
            SimppManagerImpl.this.httpRequestControl.requestFinished();
            ((HttpExecutor)SimppManagerImpl.this.httpExecutor.get()).releaseResources(httpResponse);
            return false;
        }

        public boolean allowRequest(HttpUriRequest httpUriRequest) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum UpdateType {
        FROM_NETWORK,
        FROM_DISK,
        FROM_HTTP;

    }
}

