/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.service.ErrorService;
import org.limewire.setting.RemoteSettingController;
import org.limewire.setting.RemoteSettingManager;

public class SimppSettingsManager
implements RemoteSettingManager {
    private static final Log LOG = LogFactory.getLog(SimppSettingsManager.class);
    private final Properties _simppProps = new Properties();
    private final Map<String, String> _remainderSimppSettings = new HashMap<String, String>();
    private volatile RemoteSettingController _remoteController;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSimppSettings(String string) {
        if (this._remoteController == null) {
            throw new IllegalStateException("No RemoteSettingController set!");
        }
        RemoteSettingController remoteSettingController = this._remoteController;
        synchronized (remoteSettingController) {
            byte[] byArray = null;
            try {
                byArray = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                ErrorService.error(unsupportedEncodingException);
                return;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this._simppProps.clear();
            try {
                this._simppProps.load(byteArrayInputStream);
            }
            catch (IOException iOException) {
                LOG.error((Object)"IOX reading simpp properties", (Throwable)iOException);
                return;
            }
            this.activateSimppSettings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateSimppSettings() {
        LOG.debug((Object)"activating new settings");
        if (this._remoteController == null) {
            throw new IllegalStateException("No RemoteSettingController set!");
        }
        RemoteSettingController remoteSettingController = this._remoteController;
        synchronized (remoteSettingController) {
            for (Map.Entry<Object, Object> entry : this._simppProps.entrySet()) {
                String string;
                String string2 = (String)entry.getKey();
                if (this._remoteController.updateSetting(string2, string = (String)entry.getValue())) continue;
                this._remainderSimppSettings.put(string2, string);
            }
            Set<Object> set = this._simppProps.keySet();
            this._remoteController.revertRemoteSettingsUnlessIn((Set<String>)set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUnloadedValueFor(String string) {
        RemoteSettingController remoteSettingController = this._remoteController;
        synchronized (remoteSettingController) {
            return this._remainderSimppSettings.remove(string);
        }
    }

    public void setRemoteSettingController(RemoteSettingController remoteSettingController) {
        this._remoteController = remoteSettingController;
    }
}

