/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.SearchServices;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.spam.SpamManager;
import com.limegroup.gnutella.util.ClassCNetworks;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.FixedsizeForgetfulHashMap;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.util.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
final class SearchResultHandlerImpl
implements SearchResultHandler {
    private static final Log LOG = LogFactory.getLog(SearchResultHandlerImpl.class);
    private static final int QUERY_EXPIRE_TIME = 30000;
    public static final int REPORT_INTERVAL = 15;
    public static final int MAX_RESULTS = 65535;
    private final List<GuidCount> GUID_COUNTS = new Vector<GuidCount>();
    private final Map<GUID, Map<URN, ClassCNetworks[]>> cncCounter = Collections.synchronizedMap(new FixedsizeForgetfulHashMap(10));
    private final NetworkManager networkManager;
    private final SearchServices searchServices;
    private final Provider<ActivityCallback> activityCallback;
    private final Provider<ConnectionManager> connectionManager;
    private final ConnectionServices connectionServices;
    private final Provider<SpamManager> spamManager;
    private final RemoteFileDescFactory remoteFileDescFactory;
    private final NetworkInstanceUtils networkInstanceUtils;
    @InspectionPoint(value="search result handler stats")
    private final Inspectable searchResultHandler = new Inspectable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object inspect() {
            HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
            hashMap.put("ver", Integer.valueOf(1));
            Map map = SearchResultHandlerImpl.this.cncCounter;
            synchronized (map) {
                for (GUID gUID : SearchResultHandlerImpl.this.cncCounter.keySet()) {
                    Map map2 = (Map)SearchResultHandlerImpl.this.cncCounter.get(gUID);
                    ArrayList arrayList = new ArrayList(2);
                    for (ClassCNetworks[] classCNetworksArray : map2.values()) {
                        HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
                        hashMap2.put("ip", classCNetworksArray[0].getTopInspectable(10));
                        hashMap2.put("alt", classCNetworksArray[1].getTopInspectable(10));
                        arrayList.add(hashMap2);
                    }
                    hashMap.put(gUID.toHexString(), arrayList);
                }
            }
            return hashMap;
        }
    };

    @Inject
    public SearchResultHandlerImpl(NetworkManager networkManager, SearchServices searchServices, Provider<ActivityCallback> provider, Provider<ConnectionManager> provider2, ConnectionServices connectionServices, Provider<SpamManager> provider3, RemoteFileDescFactory remoteFileDescFactory, NetworkInstanceUtils networkInstanceUtils) {
        this.networkManager = networkManager;
        this.searchServices = searchServices;
        this.activityCallback = provider;
        this.connectionManager = provider2;
        this.connectionServices = connectionServices;
        this.spamManager = provider3;
        this.remoteFileDescFactory = remoteFileDescFactory;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public void addQuery(QueryRequest queryRequest) {
        LOG.trace((Object)"entered SearchResultHandler.addQuery(QueryRequest)");
        if (!queryRequest.isBrowseHostQuery() && !queryRequest.isWhatIsNewRequest()) {
            ((SpamManager)this.spamManager.get()).startedQuery(queryRequest);
        }
        GuidCount guidCount = new GuidCount(queryRequest);
        this.GUID_COUNTS.add(guidCount);
    }

    @Override
    public void removeQuery(GUID gUID) {
        LOG.trace((Object)"entered SearchResultHandler.removeQuery(GUID)");
        this.cncCounter.remove(gUID);
        GuidCount guidCount = this.removeQueryInternal(gUID);
        if (guidCount != null && !guidCount.isFinished()) {
            QueryStatusResponse queryStatusResponse = new QueryStatusResponse(gUID, 65535);
            ((ConnectionManager)this.connectionManager.get()).updateQueryStatus(queryStatusResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<QueryRequest> getQueriesToReSend() {
        LOG.trace((Object)"entered SearchResultHandler.getQueriesToSend()");
        LinkedList<QueryRequest> linkedList = null;
        List<GuidCount> list = this.GUID_COUNTS;
        synchronized (list) {
            long l = System.currentTimeMillis();
            for (GuidCount guidCount : this.GUID_COUNTS) {
                if (!this.isQueryStillValid(guidCount, l)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("adding " + guidCount + " to list of queries to resend"));
                }
                if (linkedList == null) {
                    linkedList = new LinkedList<QueryRequest>();
                }
                linkedList.add(guidCount.getQueryRequest());
            }
        }
        if (linkedList == null) {
            return Collections.emptyList();
        }
        return linkedList;
    }

    @Override
    public int getNumResultsForQuery(GUID gUID) {
        GuidCount guidCount = this.retrieveGuidCount(gUID);
        if (guidCount != null) {
            return guidCount.getNumResults();
        }
        return -1;
    }

    @Override
    public void handleQueryReply(QueryReply queryReply) {
        HostData hostData;
        try {
            hostData = queryReply.getHostData();
        }
        catch (BadPacketException badPacketException) {
            LOG.debug((Object)"bad packet reading qr", (Throwable)badPacketException);
            return;
        }
        if (!hostData.isReplyToMulticastQuery() && !queryReply.isBrowseHostReply()) {
            if (hostData.getQuality() < SearchSettings.MINIMUM_SEARCH_QUALITY.getValue()) {
                LOG.debug((Object)"Ignoring because low quality");
                return;
            }
            if (hostData.getSpeed() < SearchSettings.MINIMUM_SEARCH_SPEED.getValue()) {
                LOG.debug((Object)"Ignoring because low speed");
                return;
            }
            if (!(!hostData.isFirewalled() || this.networkInstanceUtils.isVeryCloseIP(queryReply.getIPBytes()) || this.networkManager.acceptedIncomingConnection() && !this.networkInstanceUtils.isPrivateAddress(this.networkManager.getAddress()) || this.networkManager.canDoFWT() && queryReply.getSupportsFWTransfer())) {
                LOG.debug((Object)"Ignoring from firewall funkiness");
                return;
            }
        }
        List<Response> list = null;
        try {
            list = queryReply.getResultsAsList();
        }
        catch (BadPacketException badPacketException) {
            LOG.debug((Object)"Error gettig results", (Throwable)badPacketException);
            return;
        }
        int n = queryReply.getSecureStatus();
        if (n == 1) {
            return;
        }
        boolean bl = this.isWhatIsNew(queryReply) || queryReply.isBrowseHostReply();
        int n2 = 0;
        double d = 0.0;
        for (Response response : list) {
            if (!queryReply.isBrowseHostReply() && n != 2 && (!this.searchServices.matchesType(hostData.getMessageGUID(), response) || !this.searchServices.matchesQuery(hostData.getMessageGUID(), response)) || this.searchServices.isMandragoreWorm(hostData.getMessageGUID(), response)) continue;
            LimeXMLDocument limeXMLDocument = response.getDocument();
            if (ApplicationSettings.USE_SECURE_RESULTS.getValue() && limeXMLDocument != null && !"".equals(limeXMLDocument.getAction()) && n != 2) continue;
            this.countClassC(queryReply, response);
            RemoteFileDesc remoteFileDesc = response.toRemoteFileDesc(hostData, this.remoteFileDescFactory);
            remoteFileDesc.setSecureStatus(n);
            Set<? extends IpPort> set = response.getLocations();
            ((ActivityCallback)this.activityCallback.get()).handleQueryResult(remoteFileDesc, hostData, set);
            if (bl || !((SpamManager)this.spamManager.get()).isSpam(remoteFileDesc)) {
                ++n2;
                continue;
            }
            d += 1.0;
        }
        d = Math.ceil(d * (double)SearchSettings.SPAM_RESULT_RATIO.getValue());
        this.accountAndUpdateDynamicQueriers(queryReply, n2 + (int)d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void countClassC(QueryReply queryReply, Response response) {
        Map<GUID, Map<URN, ClassCNetworks[]>> map = this.cncCounter;
        synchronized (map) {
            GUID gUID = new GUID(queryReply.getGUID());
            Map<URN, ClassCNetworks[]> map2 = this.cncCounter.get(gUID);
            if (map2 == null) {
                map2 = new HashMap<URN, ClassCNetworks[]>();
                this.cncCounter.put(gUID, map2);
            }
            for (URN uRN : response.getUrns()) {
                ClassCNetworks[] classCNetworksArray = map2.get(uRN);
                if (classCNetworksArray == null) {
                    classCNetworksArray = new ClassCNetworks[]{new ClassCNetworks(), new ClassCNetworks()};
                    map2.put(uRN, classCNetworksArray);
                }
                classCNetworksArray[0].add(ByteUtils.beb2int(queryReply.getIPBytes(), 0), 1);
                classCNetworksArray[1].addAll(response.getLocations());
            }
        }
    }

    private void accountAndUpdateDynamicQueriers(QueryReply queryReply, int n) {
        LOG.trace((Object)"SRH.accountAndUpdateDynamicQueriers(): entered.");
        if (n > 0) {
            GuidCount guidCount = this.retrieveGuidCount(new GUID(queryReply.getGUID()));
            if (guidCount == null) {
                return;
            }
            LOG.trace((Object)"SRH.accountAndUpdateDynamicQueriers(): incrementing.");
            guidCount.increment(n);
            if (this.connectionServices.isShieldedLeaf() && !guidCount.isFinished() && guidCount.getNumResults() > guidCount.getNextReportNum()) {
                LOG.trace((Object)"SRH.accountAndUpdateDynamicQueriers(): telling UPs.");
                guidCount.tallyReport();
                if (guidCount.getNumResults() > 250) {
                    guidCount.markAsFinished();
                }
                int n2 = guidCount.isFinished() ? 65535 : guidCount.getNumResults() / 4;
                QueryStatusResponse queryStatusResponse = new QueryStatusResponse(guidCount.getGUID(), n2);
                ((ConnectionManager)this.connectionManager.get()).updateQueryStatus(queryStatusResponse);
            }
        }
        LOG.trace((Object)"SRH.accountAndUpdateDynamicQueriers(): returning.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GuidCount removeQueryInternal(GUID gUID) {
        List<GuidCount> list = this.GUID_COUNTS;
        synchronized (list) {
            Iterator<GuidCount> iterator = this.GUID_COUNTS.iterator();
            while (iterator.hasNext()) {
                GuidCount guidCount = iterator.next();
                if (!guidCount.getGUID().equals(gUID)) continue;
                iterator.remove();
                return guidCount;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GuidCount retrieveGuidCount(GUID gUID) {
        List<GuidCount> list = this.GUID_COUNTS;
        synchronized (list) {
            for (GuidCount guidCount : this.GUID_COUNTS) {
                if (!guidCount.getGUID().equals(gUID)) continue;
                return guidCount;
            }
        }
        return null;
    }

    private boolean isWhatIsNew(QueryReply queryReply) {
        GuidCount guidCount = this.retrieveGuidCount(new GUID(queryReply.getGUID()));
        return guidCount != null && guidCount.getQueryRequest().isWhatIsNewRequest();
    }

    private boolean isQueryStillValid(GuidCount guidCount, long l) {
        LOG.trace((Object)"entered SearchResultHandler.isQueryStillValid(GuidCount)");
        return l < guidCount.getTime() + 30000L && guidCount.getNumResults() < 250;
    }

    private static class GuidCount {
        private final long _time;
        private final GUID _guid;
        private final QueryRequest _qr;
        private int _numGoodResults;
        private int _nextReportNum = 15;
        private boolean markAsFinished = false;

        public GuidCount(QueryRequest queryRequest) {
            this._qr = queryRequest;
            this._guid = new GUID(queryRequest.getGUID());
            this._time = System.currentTimeMillis();
        }

        public GUID getGUID() {
            return this._guid;
        }

        public int getNumResults() {
            return this._numGoodResults;
        }

        public int getNextReportNum() {
            return this._nextReportNum;
        }

        public long getTime() {
            return this._time;
        }

        public QueryRequest getQueryRequest() {
            return this._qr;
        }

        public boolean isFinished() {
            return this.markAsFinished;
        }

        public void tallyReport() {
            this._nextReportNum = this._numGoodResults + 15;
        }

        public void increment(int n) {
            this._numGoodResults += n;
        }

        public void markAsFinished() {
            this.markAsFinished = true;
        }

        public String toString() {
            return "" + this._guid + ":" + this._numGoodResults + ":" + this._nextReportNum;
        }
    }
}

