/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.search.ProbeQuery;
import com.limegroup.gnutella.search.QueryHandler;
import com.limegroup.gnutella.search.ResultCounter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.inspection.Inspectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class QueryHandlerImpl
implements Inspectable,
QueryHandler {
    private static final Log LOG = LogFactory.getLog(QueryHandlerImpl.class);
    private static final byte MAX_QUERY_TTL = 6;
    private static final int HASH_QUERY_RESULTS = 10;
    private static final int MAXIMUM_ROUTED_FOR_LEAVES = 75;
    private final int RESULTS;
    private volatile long _timeToWaitPerHop = 2400L;
    private volatile long _timeToDecreasePerHop = 10L;
    private volatile int _numDecrements = 0;
    private final List<Long> times = new ArrayList<Long>();
    private final List<Integer> results = new ArrayList<Integer>();
    private volatile int _numResultsReportedByLeaf = 0;
    private volatile long _nextQueryTime = 0L;
    private volatile int _theoreticalHostsQueried = 1;
    private final ResultCounter RESULT_COUNTER;
    private final List<RoutedConnection> QUERIED_CONNECTIONS = new ArrayList<RoutedConnection>();
    private final List<RoutedConnection> QUERIED_PROBE_CONNECTIONS = new ArrayList<RoutedConnection>();
    private volatile long _queryStartTime = 0L;
    private volatile long _curTime = 0L;
    private final ReplyHandler REPLY_HANDLER;
    private final QueryRequest QUERY;
    private volatile boolean _forwardedToLeaves = false;
    private boolean _probeQuerySent;
    private final String _prefLocale;
    private final QueryRequestFactory queryRequestFactory;
    private final ConnectionManager connectionManager;
    private final MessageRouter messageRouter;

    QueryHandlerImpl(QueryRequest queryRequest, int n, ReplyHandler replyHandler, ResultCounter resultCounter, QueryRequestFactory queryRequestFactory, ConnectionManager connectionManager, MessageRouter messageRouter) {
        this.connectionManager = connectionManager;
        this.messageRouter = messageRouter;
        if (queryRequest == null) {
            throw new IllegalArgumentException("null query");
        }
        if (replyHandler == null) {
            throw new IllegalArgumentException("null reply handler");
        }
        if (resultCounter == null) {
            throw new IllegalArgumentException("null result counter");
        }
        this.queryRequestFactory = queryRequestFactory;
        boolean bl = !queryRequest.getQueryUrns().isEmpty();
        this.QUERY = queryRequest;
        this.RESULTS = bl ? 10 : n;
        this.REPLY_HANDLER = replyHandler;
        this.RESULT_COUNTER = resultCounter;
        this._prefLocale = replyHandler.getLocalePref();
    }

    List<RoutedConnection> getQueriedConnections() {
        return this.QUERIED_CONNECTIONS;
    }

    private QueryRequest createQuery(QueryRequest queryRequest, byte by) {
        if (by < 1 || by > 6) {
            throw new IllegalArgumentException("ttl too high: " + by);
        }
        if (queryRequest == null) {
            throw new NullPointerException("null query");
        }
        return this.queryRequestFactory.createQuery(queryRequest, by);
    }

    @Override
    public QueryRequest getTemplateQueryRequest() {
        return this.QUERY;
    }

    @Override
    public QueryRequest createQuery(byte by) {
        return this.createQuery(this.QUERY, by);
    }

    @Override
    public void sendQuery() {
        Object object;
        if (this.hasEnoughResults()) {
            return;
        }
        this._curTime = System.currentTimeMillis();
        if (this._curTime < this._nextQueryTime) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Query = " + this.QUERY.getQuery() + ", numHostsQueried: " + this._theoreticalHostsQueried));
        }
        if (this._queryStartTime == 0L) {
            this._queryStartTime = this._curTime;
        }
        if (!this._forwardedToLeaves) {
            this._forwardedToLeaves = true;
            object = this.messageRouter.getQueryRouteTable();
            QueryRequest queryRequest = this.createQuery(this.QUERY, (byte)1);
            this._theoreticalHostsQueried += 25;
            if (object != null && ((QueryRouteTable)object).contains(queryRequest)) {
                this.messageRouter.forwardQueryRequestToLeaves(queryRequest, this.REPLY_HANDLER);
                this._nextQueryTime = System.currentTimeMillis() + this._timeToWaitPerHop;
                return;
            }
        }
        if (!this._probeQuerySent) {
            object = new ProbeQuery(this.connectionManager.getInitializedConnections(), this);
            long l = ((ProbeQuery)object).getTimeToWait();
            this._theoreticalHostsQueried += ((ProbeQuery)object).sendProbe();
            this._nextQueryTime = System.currentTimeMillis() + l;
            this._probeQuerySent = true;
            return;
        }
        int n = this.sendQuery(new ArrayList<RoutedConnection>(this.connectionManager.getInitializedConnections()));
        if (n == 0) {
            this._nextQueryTime = System.currentTimeMillis() + 6000L;
        }
        this._theoreticalHostsQueried += n;
        if (this._timeToWaitPerHop > 100L && System.currentTimeMillis() - this._queryStartTime > 6000L) {
            this._timeToWaitPerHop -= this._timeToDecreasePerHop;
            int n2 = Math.max(1, this.RESULTS / 2 - 30 * this.RESULT_COUNTER.getNumResults());
            int n3 = Math.max(1, this._numDecrements / 6);
            int n4 = n2 * n3;
            n4 = Math.max(5, n4);
            this._timeToDecreasePerHop += (long)n4;
            ++this._numDecrements;
            if (this._timeToWaitPerHop < 100L) {
                this._timeToWaitPerHop = 100L;
            }
        }
    }

    int sendQuery(List<? extends RoutedConnection> list) {
        int n;
        int n2;
        List<RoutedConnection> list2 = this.connectionManager.getInitializedConnectionsMatchLocale(this._prefLocale);
        this.QUERIED_CONNECTIONS.retainAll(list);
        this.QUERIED_PROBE_CONNECTIONS.retainAll(list);
        if (!list2.isEmpty()) {
            list2.removeAll(this.QUERIED_CONNECTIONS);
            list2.removeAll(this.QUERIED_PROBE_CONNECTIONS);
        }
        if (list2.isEmpty()) {
            list2 = list;
            list2.removeAll(this.QUERIED_CONNECTIONS);
            list2.removeAll(this.QUERIED_PROBE_CONNECTIONS);
        }
        int n3 = list2.size();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("potential querier size: " + n3));
        }
        int n4 = 0;
        RoutedConnection routedConnection = null;
        Collections.shuffle(list2);
        for (n2 = 0; n2 < n3; ++n2) {
            RoutedConnection routedConnection2 = list2.get(n2);
            if (!routedConnection2.isStable(this._curTime)) continue;
            routedConnection = routedConnection2;
            break;
        }
        if ((n2 = Math.max(n3 + this.QUERIED_PROBE_CONNECTIONS.size(), 0)) == 0) {
            return 0;
        }
        if (n2 > 4) {
            n2 -= 4;
        }
        boolean bl = false;
        if (routedConnection == null) {
            if (this.QUERIED_PROBE_CONNECTIONS.isEmpty()) {
                return 0;
            }
            routedConnection = this.QUERIED_PROBE_CONNECTIONS.remove(0);
            bl = true;
        }
        int n5 = this._numResultsReportedByLeaf > 0 ? this._numResultsReportedByLeaf : this.RESULT_COUNTER.getNumResults();
        double d = (double)n5 / (double)this._theoreticalHostsQueried;
        int n6 = this.RESULTS - n5;
        int n7 = 40000;
        if (d != 0.0) {
            n7 = (int)((double)n6 / d);
        }
        if ((n4 = QueryHandlerImpl.calculateNewTTL(n = n7 / n2, routedConnection.getConnectionCapabilities().getNumIntraUltrapeerConnections(), routedConnection.getConnectionCapabilities().getHeadersRead().getMaxTTL())) == 1 && (routedConnection.isUltrapeerQueryRoutingConnection() && !routedConnection.shouldForwardQuery(this.QUERY) || bl)) {
            n4 = 2;
        }
        QueryRequest queryRequest = this.createQuery(this.QUERY, (byte)n4);
        return this.sendQueryToHost(queryRequest, routedConnection);
    }

    @Override
    public int sendQueryToHost(QueryRequest queryRequest, RoutedConnection routedConnection) {
        if (!this.messageRouter.sendInitialQuery(queryRequest, routedConnection)) {
            return 0;
        }
        byte by = queryRequest.getTTL();
        if (by == 1 && routedConnection.getConnectionCapabilities().supportsProbeQueries()) {
            this.QUERIED_PROBE_CONNECTIONS.add(routedConnection);
        } else {
            this.QUERIED_CONNECTIONS.add(routedConnection);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("QUERIED_CONNECTIONS.size() = " + this.QUERIED_CONNECTIONS.size()));
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Querying host " + routedConnection.getAddress() + " with ttl " + queryRequest.getTTL()));
        }
        this._nextQueryTime = System.currentTimeMillis() + (long)by * this._timeToWaitPerHop;
        return QueryHandlerImpl.calculateNewHosts(routedConnection, by);
    }

    static byte calculateNewTTL(int n, int n2, byte by) {
        if (by > 6) {
            by = (byte)6;
        }
        for (byte by2 = 1; by2 < 6; by2 = (byte)(by2 + 1)) {
            int n3 = (int)(16.0 * (double)QueryHandlerImpl.calculateNewHosts(n2, by2));
            if (n3 < n) continue;
            if (by2 > by) {
                return by;
            }
            return by2;
        }
        return by;
    }

    static int calculateNewHosts(RoutedConnection routedConnection, byte by) {
        return QueryHandlerImpl.calculateNewHosts(routedConnection.getConnectionCapabilities().getNumIntraUltrapeerConnections(), by);
    }

    static int calculateNewHosts(int n, byte by) {
        double d = 0.0;
        while (by > 0) {
            d += Math.pow(n - 1, by - 1);
            by = (byte)(by - 1);
        }
        return (int)d;
    }

    @Override
    public boolean hasEnoughResults() {
        if (this._queryStartTime == 0L) {
            return false;
        }
        if (this._numResultsReportedByLeaf > 0) {
            if (this.RESULT_COUNTER.getNumResults() >= 75) {
                return true;
            }
            if (this._numResultsReportedByLeaf > this.RESULTS) {
                return true;
            }
        } else if (this.RESULT_COUNTER.getNumResults() >= this.RESULTS) {
            return true;
        }
        if (this._theoreticalHostsQueried > 110000) {
            return true;
        }
        int n = (int)(System.currentTimeMillis() - this._queryStartTime);
        return n > 200000;
    }

    @Override
    public void updateLeafResults(int n) {
        if (n > this._numResultsReportedByLeaf) {
            if (this.times.size() < 20) {
                this.times.add(System.currentTimeMillis() - this._queryStartTime);
                this.results.add(n);
            }
            this._numResultsReportedByLeaf = n;
        }
    }

    @Override
    public int getNumResultsReportedByLeaf() {
        return this._numResultsReportedByLeaf;
    }

    @Override
    public ReplyHandler getReplyHandler() {
        return this.REPLY_HANDLER;
    }

    @Override
    public long getTimeToWaitPerHop() {
        return this._timeToWaitPerHop;
    }

    public String toString() {
        return "QueryHandler: QUERY: " + this.QUERY;
    }

    @Override
    public GUID getGUID() {
        return new GUID(this.QUERY.getGUID());
    }

    @Override
    public Object inspect() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ver", 1);
        hashMap.put("guid", this.QUERY.getGUID());
        hashMap.put("times", this.times);
        hashMap.put("res", this.results);
        hashMap.put("twh", this._timeToWaitPerHop);
        hashMap.put("tdh", this._timeToDecreasePerHop);
        hashMap.put("dec", this._numDecrements);
        hashMap.put("nqt", this._nextQueryTime);
        hashMap.put("qst", this._queryStartTime);
        hashMap.put("ct", this._curTime);
        hashMap.put("pqs", this._probeQuerySent);
        hashMap.put("ftw", this._forwardedToLeaves);
        hashMap.put("the", this._theoreticalHostsQueried);
        hashMap.put("rpl", this._numResultsReportedByLeaf);
        hashMap.put("RES", this.RESULTS);
        if (this.RESULT_COUNTER != null) {
            hashMap.put("rc", this.RESULT_COUNTER.getNumResults());
        }
        hashMap.put("rh", this.REPLY_HANDLER.getAddress());
        ArrayList<String> arrayList = new ArrayList<String>(this.QUERIED_PROBE_CONNECTIONS.size());
        for (RoutedConnection object : this.QUERIED_PROBE_CONNECTIONS) {
            arrayList.add(object.getAddress());
        }
        hashMap.put("probes", arrayList);
        ArrayList arrayList2 = new ArrayList(this.QUERIED_CONNECTIONS.size());
        for (RoutedConnection routedConnection : this.QUERIED_CONNECTIONS) {
            arrayList2.add(routedConnection.getAddress());
        }
        hashMap.put("queried", arrayList2);
        return hashMap;
    }
}

