/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.google.inject.Singleton;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.search.QueryDispatcher;
import com.limegroup.gnutella.search.QueryHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableForSize;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.inspection.InspectionPoint;
import org.limewire.service.ErrorService;

@Singleton
public final class QueryDispatcherImpl
implements QueryDispatcher {
    @InspectableForSize(value="number of dispatched queries")
    private final Map<GUID, QueryHandler> QUERIES = new HashMap<GUID, QueryHandler>();
    @InspectionPoint(value="dispatched queries details")
    public final Inspectable queryDetail = new Inspectable(){

        public Object inspect() {
            ArrayList<Object> arrayList = new ArrayList<Object>(QueryDispatcherImpl.this.QUERIES.size());
            for (QueryHandler queryHandler : QueryDispatcherImpl.this.QUERIES.values()) {
                arrayList.add(((Inspectable)((Object)queryHandler)).inspect());
            }
            return arrayList;
        }
    };
    @InspectableForSize(value="number of newly dispatched queries")
    private final List<QueryHandler> NEW_QUERIES = Collections.synchronizedList(new LinkedList());
    private final ExecutorService PROCESSOR = ExecutorsHelper.newProcessingQueue("QueryDispatcher");
    @InspectablePrimitive(value="querydispatcher active")
    private boolean _active;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQuery(QueryHandler queryHandler) {
        queryHandler.sendQuery();
        List<QueryHandler> list = this.NEW_QUERIES;
        synchronized (list) {
            this.NEW_QUERIES.add(queryHandler);
            if (this.NEW_QUERIES.size() == 1 && !this._active) {
                this._active = true;
                this.PROCESSOR.execute(this);
            }
        }
    }

    public void removeReplyHandler(ReplyHandler replyHandler) {
        if (!replyHandler.isSupernodeClientConnection()) {
            return;
        }
        this.remove(replyHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLeafResultsForQuery(GUID gUID, int n) {
        Map<GUID, QueryHandler> map = this.QUERIES;
        synchronized (map) {
            QueryHandler queryHandler = this.QUERIES.get(gUID);
            if (queryHandler != null) {
                queryHandler.updateLeafResults(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLeafResultsForQuery(GUID gUID) {
        Map<GUID, QueryHandler> map = this.QUERIES;
        synchronized (map) {
            QueryHandler queryHandler = this.QUERIES.get(gUID);
            if (queryHandler == null) {
                return -1;
            }
            return queryHandler.getNumResultsReportedByLeaf();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ReplyHandler replyHandler) {
        QueryHandler queryHandler;
        Iterator<QueryHandler> iterator;
        Object object = this.NEW_QUERIES;
        synchronized (object) {
            iterator = this.NEW_QUERIES.iterator();
            while (iterator.hasNext()) {
                queryHandler = iterator.next();
                if (queryHandler.getReplyHandler() != replyHandler) continue;
                iterator.remove();
            }
        }
        object = this.QUERIES;
        synchronized (object) {
            iterator = this.QUERIES.values().iterator();
            while (iterator.hasNext()) {
                queryHandler = iterator.next();
                if (queryHandler.getReplyHandler() != replyHandler) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(GUID gUID) {
        QueryHandler queryHandler;
        Iterator<QueryHandler> iterator;
        Object object = this.NEW_QUERIES;
        synchronized (object) {
            iterator = this.NEW_QUERIES.iterator();
            while (iterator.hasNext()) {
                queryHandler = iterator.next();
                if (!queryHandler.getGUID().equals(gUID)) continue;
                iterator.remove();
            }
        }
        object = this.QUERIES;
        synchronized (object) {
            iterator = this.QUERIES.values().iterator();
            while (iterator.hasNext()) {
                queryHandler = iterator.next();
                if (!queryHandler.getGUID().equals(gUID)) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                if (this.processQueries()) continue;
                List<QueryHandler> list = this.NEW_QUERIES;
                synchronized (list) {
                    if (this.NEW_QUERIES.isEmpty()) {
                        this._active = false;
                        return;
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                ErrorService.error(throwable);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processQueries() {
        Object object;
        Object object2 = this.NEW_QUERIES;
        synchronized (object2) {
            object = this.QUERIES;
            synchronized (object) {
                for (QueryHandler queryHandler : this.NEW_QUERIES) {
                    this.QUERIES.put(queryHandler.getGUID(), queryHandler);
                }
            }
            this.NEW_QUERIES.clear();
        }
        object2 = this.QUERIES;
        synchronized (object2) {
            object = this.QUERIES.values().iterator();
            while (object.hasNext()) {
                QueryHandler queryHandler = (QueryHandler)object.next();
                queryHandler.sendQuery();
                if (!queryHandler.hasEnoughResults()) continue;
                object.remove();
            }
            return !this.QUERIES.isEmpty();
        }
    }

    public void addToRemove(GUID gUID) {
        this.remove(gUID);
    }
}

