/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.search.HostDataFactory;
import com.limegroup.gnutella.search.HostDataImpl;
import java.util.Set;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.util.ByteUtils;

@Singleton
public class HostDataFactoryImpl
implements HostDataFactory {
    private final NetworkManager networkManager;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public HostDataFactoryImpl(NetworkManager networkManager, NetworkInstanceUtils networkInstanceUtils) {
        this.networkManager = networkManager;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    public HostData createHostData(QueryReply queryReply) {
        byte[] byArray = queryReply.getClientGUID();
        byte[] byArray2 = queryReply.getGUID();
        String string = queryReply.getIP();
        int n = queryReply.getPort();
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        String string2 = "";
        try {
            bl = queryReply.getNeedsPush() || this.networkInstanceUtils.isPrivateAddress(string);
        }
        catch (BadPacketException badPacketException) {
            bl = true;
        }
        try {
            bl5 = queryReply.getIsMeasuredSpeed();
        }
        catch (BadPacketException badPacketException) {
            bl5 = false;
        }
        try {
            bl2 = queryReply.getIsBusy();
        }
        catch (BadPacketException badPacketException) {
            bl2 = true;
        }
        try {
            string2 = queryReply.getVendor();
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
        bl3 = queryReply.getSupportsBrowseHost();
        bl4 = queryReply.getSupportsChat() && !bl;
        bl6 = queryReply.isReplyToMulticastQuery();
        bl = bl && !bl6;
        bl5 = bl5 || bl6;
        boolean bl7 = !this.networkManager.acceptedIncomingConnection();
        int n2 = queryReply.calculateQualityOfService(bl7, this.networkManager);
        Set<? extends IpPort> set = queryReply.getPushProxies();
        boolean bl8 = queryReply.getSupportsFWTransfer();
        byte by = queryReply.getFWTransferVersion();
        boolean bl9 = queryReply.isTLSCapable();
        int n3 = bl6 ? Integer.MAX_VALUE : ByteUtils.long2int(queryReply.getSpeed());
        return new HostDataImpl(byArray, byArray2, n3, bl, bl2, bl6, bl4, bl3, bl5, string, n, n2, string2, set, bl8, by, bl9);
    }
}

