/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.rudp;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.messages.MessageFactory;
import com.limegroup.gnutella.rudp.messages.LimeRUDPMessageParser;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.observer.TransportListener;
import org.limewire.rudp.RUDPContext;
import org.limewire.rudp.RUDPSettings;
import org.limewire.rudp.UDPService;
import org.limewire.rudp.messages.RUDPMessageFactory;

@Singleton
class LimeRUDPContext
implements RUDPContext {
    private final RUDPMessageFactory rudpMessageFactory;
    private final RUDPSettings rudpSettings;
    private final UDPService udpService;
    private final NIODispatcher nioDispatcher;

    @Inject
    public LimeRUDPContext(UDPService uDPService, RUDPMessageFactory rUDPMessageFactory, RUDPSettings rUDPSettings, MessageFactory messageFactory, NIODispatcher nIODispatcher) {
        this.udpService = uDPService;
        this.rudpMessageFactory = rUDPMessageFactory;
        this.rudpSettings = rUDPSettings;
        this.nioDispatcher = nIODispatcher;
        LimeRUDPMessageParser limeRUDPMessageParser = new LimeRUDPMessageParser(rUDPMessageFactory);
        messageFactory.setParser((byte)65, limeRUDPMessageParser);
    }

    public RUDPMessageFactory getMessageFactory() {
        return this.rudpMessageFactory;
    }

    public TransportListener getTransportListener() {
        return this.nioDispatcher.getTransportListener();
    }

    public RUDPSettings getRUDPSettings() {
        return this.rudpSettings;
    }

    public UDPService getUDPService() {
        return this.udpService;
    }
}

