/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.limegroup.gnutella.routing.QRTTableStorage;
import java.util.Iterator;
import org.limewire.collection.SparseIntSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SparseSetStorage
implements QRTTableStorage {
    private final SparseIntSet set;
    private final int length;

    SparseSetStorage(int n) {
        this(new SparseIntSet(), n);
    }

    private SparseSetStorage(SparseIntSet sparseIntSet, int n) {
        this.set = sparseIntSet;
        this.length = n;
    }

    @Override
    public void clear(int n) {
        this.set.remove(n);
    }

    @Override
    public void compact() {
        this.set.compact();
    }

    @Override
    public double getPercentFull() {
        return (double)this.set.size() * 100.0 / (double)this.length;
    }

    @Override
    public int getUnitsInUse() {
        return this.set.getActualMemoryUsed() / 8;
    }

    @Override
    public int getUnusedUnits() {
        return 0;
    }

    @Override
    public int numUnitsWithLoad(int n) {
        return -1;
    }

    @Override
    public void or(QRTTableStorage qRTTableStorage) {
        if (qRTTableStorage instanceof SparseSetStorage) {
            SparseSetStorage sparseSetStorage = (SparseSetStorage)qRTTableStorage;
            this.set.addAll(sparseSetStorage.set);
        } else {
            Iterator iterator = qRTTableStorage.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                this.set.add(n);
            }
        }
    }

    @Override
    public QRTTableStorage resize(int n) {
        if (n == this.length) {
            return this;
        }
        SparseIntSet sparseIntSet = new SparseIntSet();
        for (int n2 : this.set) {
            int n3 = (int)((long)n2 * (long)n / (long)this.length);
            n2 = this.nextClearBit(n2 + 1);
            int n4 = (int)(((long)n2 * (long)n - 1L) / (long)this.length + 1L);
            for (int i = n3; i < n4; ++i) {
                sparseIntSet.add(i);
            }
        }
        return new SparseSetStorage(sparseIntSet, n);
    }

    @Override
    public void set(int n) {
        this.set.add(n);
    }

    @Override
    public void xor(QRTTableStorage qRTTableStorage) {
        for (int i = 0; i < this.length; ++i) {
            if (this.get(i) != qRTTableStorage.get(i)) {
                this.set(i);
                continue;
            }
            this.clear(i);
        }
    }

    @Override
    public int cardinality() {
        return this.set.size();
    }

    @Override
    public boolean get(int n) {
        return this.set.contains(n);
    }

    @Override
    public int maxSize() {
        return this.length;
    }

    @Override
    public int nextClearBit(int n) {
        for (int i = n; i < this.length; ++i) {
            if (this.set.contains(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int nextSetBit(int n) {
        return this.set.nextSetBit(n);
    }

    @Override
    public QRTTableStorage clone() {
        SparseIntSet sparseIntSet = new SparseIntSet();
        sparseIntSet.addAll(this.set);
        return new SparseSetStorage(sparseIntSet, this.length);
    }

    public boolean equals(Object object) {
        if (!(object instanceof QRTTableStorage)) {
            return false;
        }
        QRTTableStorage qRTTableStorage = (QRTTableStorage)object;
        if (qRTTableStorage.maxSize() != this.maxSize()) {
            return false;
        }
        if (object instanceof SparseSetStorage) {
            SparseSetStorage sparseSetStorage = (SparseSetStorage)object;
            return this.set.containsAll(sparseSetStorage.set) && this.set.size() == sparseSetStorage.set.size();
        }
        if (qRTTableStorage.cardinality() != this.cardinality()) {
            return false;
        }
        Iterator iterator = qRTTableStorage.iterator();
        for (int n : this) {
            if (n == (Integer)iterator.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.set.iterator();
    }

    public String toString() {
        return "SparseSetStorage: " + this.set;
    }
}

