/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.routing.DynamicQRTStorage;
import com.limegroup.gnutella.routing.HashFunction;
import com.limegroup.gnutella.routing.PatchTableMessage;
import com.limegroup.gnutella.routing.QRTTableStorage;
import com.limegroup.gnutella.routing.ResetTableMessage;
import com.limegroup.gnutella.routing.RouteTableMessage;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.Utilities;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.limewire.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryRouteTable {
    public static final byte DEFAULT_INFINITY = 7;
    public static final byte KEYWORD_NO_CHANGE = 0;
    public static final int MAX_PATCH_SIZE = 4096;
    private static final AtomicInteger DEFAULT_SIZE = new AtomicInteger(-1);
    private byte infinity;
    private byte keywordPresent;
    private byte keywordAbsent;
    private volatile QRTTableStorage storage;
    private int bitTableLength;
    private int sequenceNumber;
    private int sequenceSize;
    private int nextPatch;
    private volatile Inflater uncompressor;

    public QueryRouteTable() {
        DEFAULT_SIZE.compareAndSet(-1, (int)ConnectionSettings.QRT_SIZE_IN_KIBI_ENTRIES.getValue());
        long l = 1024 * DEFAULT_SIZE.get();
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Default QRT size cannot be expressed as an int.");
        }
        this.initialize((int)l, (byte)7);
    }

    public QueryRouteTable(int n) {
        this(n, 7);
    }

    public QueryRouteTable(int n, byte by) {
        this.initialize(n, by);
    }

    private void initialize(int n, byte by) {
        this.bitTableLength = n;
        this.storage = new DynamicQRTStorage(this.bitTableLength);
        this.sequenceNumber = -1;
        this.sequenceSize = -1;
        this.nextPatch = 0;
        this.keywordPresent = (byte)(1 - by);
        this.keywordAbsent = (byte)(by - 1);
        this.infinity = by;
    }

    public int getSize() {
        return this.bitTableLength;
    }

    public double getPercentFull() {
        return this.storage.getPercentFull();
    }

    public int getEmptyUnits() {
        return this.storage.getUnusedUnits();
    }

    public int getUnitsInUse() {
        return this.storage.getUnitsInUse();
    }

    public int getUnitsWithLoad(int n) {
        return this.storage.numUnitsWithLoad(n);
    }

    public boolean contains(QueryRequest queryRequest) {
        int n;
        int n2;
        int n3;
        byte by = Utilities.log2(this.bitTableLength);
        String string = queryRequest.getQuery();
        LimeXMLDocument limeXMLDocument = queryRequest.getRichQuery();
        if (string.length() == 0 && limeXMLDocument == null && !queryRequest.hasQueryUrns()) {
            return false;
        }
        if (queryRequest.hasQueryUrns()) {
            Set<URN> set = queryRequest.getQueryUrns();
            for (URN uRN : set) {
                int n4 = HashFunction.hash(uRN.toString(), by);
                if (!this.contains(n4)) continue;
                return true;
            }
            return false;
        }
        int n5 = 0;
        while ((n3 = HashFunction.keywordStart(string, n5)) >= 0) {
            n2 = HashFunction.keywordEnd(string, n3);
            n = HashFunction.hash(string, n3, n2, by);
            if (!this.contains(n)) {
                return false;
            }
            n5 = n2 + 1;
        }
        if (limeXMLDocument == null) {
            return true;
        }
        String string2 = limeXMLDocument.getSchemaURI();
        n3 = HashFunction.hash(string2, by);
        if (!this.contains(n3)) {
            return false;
        }
        n2 = 0;
        n = 0;
        for (String string3 : limeXMLDocument.getKeyWords()) {
            int n6;
            int n7 = 0;
            while ((n6 = HashFunction.keywordStart(string3, n7)) >= 0) {
                int n8 = HashFunction.keywordEnd(string3, n6);
                int n9 = HashFunction.hash(string3, n6, n8, by);
                if (this.contains(n9)) {
                    ++n;
                }
                ++n2;
                n7 = n8 + 1;
            }
        }
        for (String string3 : limeXMLDocument.getKeyWordsIndivisible()) {
            n3 = HashFunction.hash(string3, by);
            if (this.contains(n3)) {
                ++n;
            }
            ++n2;
        }
        if (n2 < 3) {
            return n2 == n;
        }
        return (double)((float)n / (float)n2) > 0.67;
    }

    private final boolean contains(int n) {
        return this.storage.get(n);
    }

    public void add(String string) {
        this.addBTInternal(string);
    }

    private void addBTInternal(String string) {
        String[] stringArray = HashFunction.keywords(string);
        String[] stringArray2 = HashFunction.getPrefixes(stringArray);
        byte by = Utilities.log2(this.bitTableLength);
        for (int i = 0; i < stringArray2.length; ++i) {
            int n = HashFunction.hash(stringArray2[i], by);
            if (this.storage.get(n)) continue;
            this.storage.set(n);
        }
    }

    public void addIndivisible(String string) {
        int n = HashFunction.hash(string, Utilities.log2(this.bitTableLength));
        if (!this.storage.get(n)) {
            this.storage.set(n);
        }
    }

    public void addAll(QueryRouteTable queryRouteTable) {
        this.storage.or(queryRouteTable.storage.resize(this.bitTableLength));
        this.storage.compact();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof QueryRouteTable)) {
            return false;
        }
        QueryRouteTable queryRouteTable = (QueryRouteTable)object;
        if (this.bitTableLength != queryRouteTable.bitTableLength) {
            return false;
        }
        return this.storage.equals(queryRouteTable.storage);
    }

    public int hashCode() {
        return this.storage.hashCode() * 17;
    }

    public String toString() {
        return "QueryRouteTable: " + this.storage.toString();
    }

    public void reset(ResetTableMessage resetTableMessage) {
        this.initialize(resetTableMessage.getTableSize(), resetTableMessage.getInfinity());
    }

    public void patch(PatchTableMessage patchTableMessage) throws BadPacketException {
        this.handlePatch(patchTableMessage);
    }

    private void handlePatch(PatchTableMessage patchTableMessage) throws BadPacketException {
        if (this.sequenceSize != -1 && this.sequenceSize != patchTableMessage.getSequenceSize()) {
            throw new BadPacketException("Inconsistent seq size: " + patchTableMessage.getSequenceSize() + " vs. " + this.sequenceSize);
        }
        if (this.sequenceNumber == -1 ? patchTableMessage.getSequenceNumber() != 1 : this.sequenceNumber + 1 != patchTableMessage.getSequenceNumber()) {
            throw new BadPacketException("Inconsistent seq number: " + patchTableMessage.getSequenceNumber() + " vs. " + this.sequenceNumber);
        }
        byte[] byArray = patchTableMessage.getData();
        if (patchTableMessage.getCompressor() == 1) {
            try {
                if (patchTableMessage.getSequenceNumber() == 1) {
                    this.uncompressor = new Inflater();
                }
                assert (this.uncompressor != null) : "Null uncompressor.  Sequence: " + patchTableMessage.getSequenceNumber();
                byArray = this.uncompress(byArray);
            }
            catch (IOException iOException) {
                throw new BadPacketException("Couldn't uncompress data: " + iOException);
            }
        } else if (patchTableMessage.getCompressor() != 0) {
            throw new BadPacketException("Unknown compressor");
        }
        if (patchTableMessage.getEntryBits() == 4) {
            byArray = QueryRouteTable.unhalve(byArray);
        } else if (patchTableMessage.getEntryBits() != 8) {
            throw new BadPacketException("Unknown value for entry bits");
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (this.nextPatch >= this.bitTableLength) {
                throw new BadPacketException("Tried to patch " + this.nextPatch + " on a bitTable of size " + this.bitTableLength);
            }
            if (byArray[i] < 0) {
                this.storage.set(this.nextPatch);
            } else if (byArray[i] > 0) {
                this.storage.clear(this.nextPatch);
            }
            ++this.nextPatch;
        }
        this.storage.compact();
        this.sequenceSize = patchTableMessage.getSequenceSize();
        if (patchTableMessage.getSequenceNumber() != patchTableMessage.getSequenceSize()) {
            this.sequenceNumber = patchTableMessage.getSequenceNumber();
        } else {
            this.sequenceNumber = -1;
            this.sequenceSize = -1;
            this.nextPatch = 0;
            if (this.uncompressor != null) {
                IOUtils.close(this.uncompressor);
                this.uncompressor = null;
            }
        }
    }

    public List<RouteTableMessage> encode(QueryRouteTable queryRouteTable) {
        return this.encode(queryRouteTable, true);
    }

    public List<RouteTableMessage> encode(QueryRouteTable queryRouteTable, boolean bl) {
        byte[] byArray;
        Object object;
        LinkedList<RouteTableMessage> linkedList = new LinkedList<RouteTableMessage>();
        if (queryRouteTable == null) {
            linkedList.add(new ResetTableMessage(this.bitTableLength, this.infinity));
        } else assert (queryRouteTable.bitTableLength == this.bitTableLength) : "TODO: can't deal with tables of different lengths";
        byte[] byArray2 = new byte[this.bitTableLength];
        Utilities.fill(byArray2, 0, this.bitTableLength, (byte)0);
        boolean bl2 = false;
        if (queryRouteTable != null) {
            if (!this.storage.equals(queryRouteTable.storage)) {
                object = this.storage.clone();
                object.xor(queryRouteTable.storage);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    byArray2[n] = this.storage.get(n) ? this.keywordPresent : this.keywordAbsent;
                    bl2 = true;
                }
            }
        } else {
            object = this.storage.iterator();
            while (object.hasNext()) {
                int n = (Integer)object.next();
                byArray2[n] = this.keywordPresent;
                bl2 = true;
            }
        }
        if (!bl2) {
            return linkedList;
        }
        byte by = 8;
        if (this.keywordPresent >= -8 && this.keywordAbsent <= 7) {
            by = 4;
            byArray2 = QueryRouteTable.halve(byArray2);
        }
        byte by2 = 0;
        if (bl && (byArray = IOUtils.deflate(byArray2)).length < byArray2.length) {
            byArray2 = byArray;
            by2 = 1;
        }
        int n = (int)Math.ceil((float)byArray2.length / 4096.0f);
        int n2 = 1;
        for (int i = 0; i < byArray2.length; i += 4096) {
            int n3 = Math.min(i + 4096, byArray2.length);
            linkedList.add(new PatchTableMessage((short)n2, (short)n, by2, by, byArray2, i, n3));
            ++n2;
        }
        return linkedList;
    }

    private byte[] uncompress(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.uncompressor.setInput(byArray);
        try {
            int n;
            byte[] byArray2 = new byte[1024];
            while ((n = this.uncompressor.inflate(byArray2)) != 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byteArrayOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (DataFormatException dataFormatException) {
            throw new IOException("Bad deflate format");
        }
    }

    public byte[] getRawDump() {
        byte[] byArray = new byte[this.bitTableLength / 8];
        Iterator iterator = this.storage.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            byArray[n / 8] = (byte)(byArray[n / 8] | 1 << 7 - n % 8);
        }
        return byArray;
    }

    static byte[] halve(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length / 2];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = (byte)(byArray[2 * i] << 4 | byArray[2 * i + 1] & 0xF);
        }
        return byArray2;
    }

    static byte[] unhalve(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[2 * i] = (byte)(byArray[i] >> 4);
            byArray2[2 * i + 1] = QueryRouteTable.extendNibble((byte)(byArray[i] & 0xF));
        }
        return byArray2;
    }

    static byte extendNibble(byte by) {
        if ((by & 8) != 0) {
            return (byte)(0xF0 | by);
        }
        return by;
    }
}

