/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.limegroup.gnutella.routing.BitSetQRTTableStorage;
import com.limegroup.gnutella.routing.QRTTableStorage;
import com.limegroup.gnutella.routing.SparseSetStorage;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DynamicQRTStorage
implements QRTTableStorage {
    private final float TRESHOLD = 2.5f;
    private QRTTableStorage storage;

    DynamicQRTStorage(int n) {
        this(new SparseSetStorage(n));
    }

    private DynamicQRTStorage(QRTTableStorage qRTTableStorage) {
        this.storage = qRTTableStorage;
    }

    @Override
    public void clear(int n) {
        this.storage.clear(n);
    }

    @Override
    public void compact() {
        this.changeStorage();
        this.storage.compact();
    }

    private void changeStorage() {
        if (this.storage.getPercentFull() > 2.5) {
            if (this.storage instanceof SparseSetStorage) {
                BitSetQRTTableStorage bitSetQRTTableStorage = new BitSetQRTTableStorage(this.storage.maxSize());
                bitSetQRTTableStorage.or(this.storage);
                this.storage = bitSetQRTTableStorage;
            }
        } else if (this.storage instanceof BitSetQRTTableStorage) {
            SparseSetStorage sparseSetStorage = new SparseSetStorage(this.storage.maxSize());
            sparseSetStorage.or(this.storage);
            this.storage = sparseSetStorage;
        }
    }

    @Override
    public double getPercentFull() {
        return this.storage.getPercentFull();
    }

    @Override
    public int getUnitsInUse() {
        return this.storage.getUnitsInUse();
    }

    @Override
    public int getUnusedUnits() {
        return this.storage.getUnusedUnits();
    }

    @Override
    public int numUnitsWithLoad(int n) {
        return this.storage.numUnitsWithLoad(n);
    }

    @Override
    public void or(QRTTableStorage qRTTableStorage) {
        if (qRTTableStorage instanceof DynamicQRTStorage) {
            qRTTableStorage = ((DynamicQRTStorage)qRTTableStorage).storage;
        }
        this.storage.or(qRTTableStorage);
    }

    @Override
    public QRTTableStorage resize(int n) {
        return this.storage.resize(n);
    }

    @Override
    public void set(int n) {
        this.storage.set(n);
    }

    @Override
    public void xor(QRTTableStorage qRTTableStorage) {
        if (qRTTableStorage instanceof DynamicQRTStorage) {
            qRTTableStorage = ((DynamicQRTStorage)qRTTableStorage).storage;
        }
        this.storage.xor(qRTTableStorage);
    }

    @Override
    public int cardinality() {
        return this.storage.cardinality();
    }

    @Override
    public boolean get(int n) {
        return this.storage.get(n);
    }

    @Override
    public int maxSize() {
        return this.storage.maxSize();
    }

    @Override
    public int nextClearBit(int n) {
        return this.storage.nextClearBit(n);
    }

    @Override
    public int nextSetBit(int n) {
        return this.storage.nextSetBit(n);
    }

    @Override
    public DynamicQRTStorage clone() {
        return new DynamicQRTStorage(this.storage.clone());
    }

    public boolean equals(Object object) {
        if (object instanceof DynamicQRTStorage) {
            object = ((DynamicQRTStorage)object).storage;
        }
        return this.storage.equals(object);
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.storage.iterator();
    }

    public String toString() {
        return "DynamicQRTStorage: " + this.storage.toString();
    }
}

