/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.limegroup.gnutella.routing.QRTTableStorage;
import java.util.Iterator;
import org.limewire.collection.BitSet;
import org.limewire.collection.UnmodifiableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BitSetQRTTableStorage
implements QRTTableStorage {
    private final BitSet bitSet;
    private final int bitTableLength;
    private BitSet cachedResizedSet;
    private int cachedResizedSetLength;

    BitSetQRTTableStorage(int n) {
        this.bitTableLength = n;
        this.bitSet = new BitSet();
    }

    private BitSetQRTTableStorage(BitSet bitSet, int n) {
        this.bitSet = bitSet;
        this.bitTableLength = n;
    }

    @Override
    public double getPercentFull() {
        return (double)this.bitSet.cardinality() * 100.0 / (double)this.bitTableLength;
    }

    @Override
    public QRTTableStorage clone() {
        return new BitSetQRTTableStorage((BitSet)this.bitSet.clone(), this.bitTableLength);
    }

    @Override
    public void clear(int n) {
        this.cachedResizedSet = null;
        this.bitSet.clear(n);
    }

    @Override
    public void compact() {
        this.bitSet.compact();
    }

    @Override
    public int getUnitsInUse() {
        return this.bitSet.getUnitsInUse();
    }

    @Override
    public int getUnusedUnits() {
        return this.bitSet.unusedUnits();
    }

    @Override
    public int numUnitsWithLoad(int n) {
        return this.bitSet.numUnitsWithLoad(n);
    }

    @Override
    public void or(QRTTableStorage qRTTableStorage) {
        if (qRTTableStorage instanceof BitSetQRTTableStorage) {
            BitSetQRTTableStorage bitSetQRTTableStorage = (BitSetQRTTableStorage)qRTTableStorage;
            this.bitSet.or(bitSetQRTTableStorage.bitSet);
        } else {
            Iterator iterator = qRTTableStorage.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                this.bitSet.set(n);
            }
        }
    }

    @Override
    public QRTTableStorage resize(int n) {
        if (this.bitTableLength == n) {
            return this;
        }
        if (this.cachedResizedSet != null && this.cachedResizedSetLength == n) {
            return new BitSetQRTTableStorage(this.cachedResizedSet, this.cachedResizedSetLength);
        }
        this.cachedResizedSet = new BitSet();
        this.cachedResizedSetLength = n;
        int n2 = this.bitTableLength;
        int n3 = this.cachedResizedSetLength;
        int n4 = this.bitSet.nextSetBit(0);
        while (n4 >= 0) {
            int n5 = (int)((long)n4 * (long)n3 / (long)n2);
            n4 = this.bitSet.nextClearBit(n4 + 1);
            int n6 = (int)(((long)n4 * (long)n3 - 1L) / (long)n2 + 1L);
            this.cachedResizedSet.set(n5, n6);
            n4 = this.bitSet.nextSetBit(n4 + 1);
        }
        return new BitSetQRTTableStorage(this.cachedResizedSet, this.cachedResizedSetLength);
    }

    @Override
    public void set(int n) {
        this.cachedResizedSet = null;
        this.bitSet.set(n);
    }

    @Override
    public void xor(QRTTableStorage qRTTableStorage) {
        if (qRTTableStorage instanceof BitSetQRTTableStorage) {
            BitSetQRTTableStorage bitSetQRTTableStorage = (BitSetQRTTableStorage)qRTTableStorage;
            this.bitSet.xor(bitSetQRTTableStorage.bitSet);
        } else {
            for (int i = 0; i < this.bitTableLength; ++i) {
                this.bitSet.set(i, this.bitSet.get(i) != qRTTableStorage.get(i));
            }
        }
    }

    @Override
    public Iterator<Integer> iterator() {
        return new BitSetIterator();
    }

    @Override
    public int cardinality() {
        return this.bitSet.cardinality();
    }

    @Override
    public boolean get(int n) {
        return this.bitSet.get(n);
    }

    @Override
    public int maxSize() {
        return this.bitTableLength;
    }

    @Override
    public int nextClearBit(int n) {
        return this.bitSet.nextClearBit(n);
    }

    @Override
    public int nextSetBit(int n) {
        return this.bitSet.nextSetBit(n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof QRTTableStorage)) {
            return false;
        }
        if (object instanceof BitSetQRTTableStorage) {
            BitSetQRTTableStorage bitSetQRTTableStorage = (BitSetQRTTableStorage)object;
            return this.bitSet.equals(bitSetQRTTableStorage.bitSet);
        }
        QRTTableStorage qRTTableStorage = (QRTTableStorage)object;
        if (this.cardinality() != qRTTableStorage.cardinality()) {
            return false;
        }
        Iterator iterator = qRTTableStorage.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (this.get(n)) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BitSetIterator
    extends UnmodifiableIterator<Integer> {
        private int current;

        private BitSetIterator() {
            this.current = BitSetQRTTableStorage.this.bitSet.nextSetBit(0);
        }

        @Override
        public boolean hasNext() {
            return this.current >= 0;
        }

        @Override
        public Integer next() {
            int n = this.current;
            this.current = BitSetQRTTableStorage.this.bitSet.nextSetBit(n + 1);
            return n;
        }
    }
}

