/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.video.reader;

import com.limegroup.gnutella.metadata.video.reader.VideoDataReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.limewire.io.IOUtils;
import org.limewire.util.ByteUtils;

public class RIFFMetaData
extends VideoDataReader {
    public RIFFMetaData(File file) throws IOException {
        super(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseFile(File file) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            this.readRIFFHeader(dataInputStream);
        }
        catch (Throwable throwable) {
            IOUtils.close(fileInputStream);
            throw throwable;
        }
        IOUtils.close(fileInputStream);
    }

    private void readRIFFHeader(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[4];
        dataInputStream.readFully(byArray);
        if (byArray[0] != 82 || byArray[1] != 73 || byArray[2] != 70 || byArray[3] != 70) {
            return;
        }
        IOUtils.ensureSkip(dataInputStream, 4L);
        dataInputStream.readFully(byArray);
        if (byArray[0] != 65 || byArray[1] != 86 || byArray[2] != 73 || byArray[3] != 32) {
            return;
        }
        IOUtils.ensureSkip(dataInputStream, 12L);
        IOUtils.ensureSkip(dataInputStream, 8L);
        dataInputStream.readFully(byArray);
        int n = ByteUtils.leb2int(byArray, 0, 4);
        IOUtils.ensureSkip(dataInputStream, 12L);
        dataInputStream.readFully(byArray);
        int n2 = ByteUtils.leb2int(byArray, 0, 4);
        this.videoData.setLength((short)(1L * (long)n * (long)n2 / 1000L));
        IOUtils.ensureSkip(dataInputStream, 4L);
        dataInputStream.readFully(byArray);
        IOUtils.ensureSkip(dataInputStream, 4L);
        dataInputStream.readFully(byArray);
        this.videoData.setWidth(ByteUtils.leb2int(byArray, 0, 4));
        dataInputStream.readFully(byArray);
        this.videoData.setHeight(ByteUtils.leb2int(byArray, 0, 4));
        IOUtils.ensureSkip(dataInputStream, 16L);
    }
}

